# 
# whereis-archive.sh - print an archive's location
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "print the registered location of an archive\\n"
		printf "usage: whereis-archive [options] archive\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf " -R --root                     specify a local archive root\\n"
		printf "\\n"
		printf "Print the registered location of an archive.\\n"
		printf "\\n"
		printf "Usually the archive must have been previously registered with\\n"
		printf "\"larch register-archive\".\\n"
		printf "\\n"
		printf "As a special exception, the the archive is not registered, but\\n"
		printf "is the name of the archive rooted at the location given with\\n"
		printf "the option -R (--root) or in the environment variable ARCHROOT\\n"
		printf "then print that root directory.\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)		shift
    			if test $# -eq 0 ; then
			  printf "whereis-archive: -R and --root require an argument\\n" 1>&2
			  printf "try --help\\n" 1>&2
			  exit 1
			fi
			archroot="$1"
			shift
			;;
    -*)			printf "whereis-archive: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 1 ; then
  printf "usage: whereis-archive [options]\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

archive="$1"

################################################################
# Validate Arguments
# 

larch valid-archive-name -e whereis-archive -- "$archive"

################################################################
# Print the Location, If it Can be Found
# 

cd ~/.arch-params/=locations

if test -e "$archive" ; then

  cat "$archive"

else

  # Not a registered archive.  Is it the user's default archive?
  #

  from="-R"

  if test "x$archroot" = x ; then
    archroot="$ARCHROOT"
    from="the environment"
  fi

  if test "x$archroot" != x ; then

    # allow ARCHROOT to be relative to the user's home directory
    # 
    cd

    if test ! -d "$archroot" ; then
      printf "whereis-archive: archive root from %s is not a directory\\n" "$from" 1>&2
      printf "  specified root: %s\\n" "$archroot" 1>&2
      exit 1
    fi

    cd "$archroot"
    name="`cat =meta-info/name`"

    if test "x$name" = "x$archive" ; then
      pwd
      exit 0
    fi
  fi

  # not registered and not the default archive
  # 
  printf "whereis-archive: archive not registered (%s)\\n" "$archive" 1>&2
  printf "  see \"larch whereis-archive --help\"\\n" 1>&2
  exit 1

fi
