dnl Convenient macros, by Mikhael Goikhman (taken from fvwm-themes)

dnl mg_ARG_WITH(NAME, HELP-STRING, VAR [, DEFAULT-VALUE])
AC_DEFUN([mg_ARG_WITH], [
	AC_ARG_WITH(
		[$1],
		AS_HELP_STRING([--with-$1], [$2]),
		[$3=$withval], [$3=$4]
	)
])

dnl mg_DEFAULT_DIR_ARG(ARG, DEFAULT_VALUE)
AC_DEFUN([mg_DEFAULT_DIR_ARG], [
	var=`echo [$]$1`
	if echo "${var}NONE" | ${AWK} '/^\$|^NONE/ { exit 1 }'; then
		$1=$var
	else
		$1=$2
	fi
	case "[$]$1" in "") echo "No value for $1. Failed."; exit 1;; esac
])

dnl mg_CHECK_PERL()
AC_DEFUN([mg_CHECK_PERL], [
	if test x"$PERL" = x; then
		AC_PATH_PROG(PERL, perl)
	fi
	if test x"$PERL" != x; then
		AC_MSG_CHECKING([for perl $REQUIRED_PERL_VERSION or greater])
		if "$PERL" -M"$REQUIRED_PERL_VERSION" -e 1 2>/dev/null; then
			AC_MSG_RESULT(yes)
		else
			AC_MSG_RESULT(no)
			AC_MSG_WARN([$PERL is invalid or too old])
		fi
	else
		AC_MSG_WARN([Can't find perl executable on your system.])
		AC_MSG_WARN([Install perl >= $REQUIRED_PERL_VERSION first.])
		PERL=/usr/bin/perl
	fi
	AC_MSG_RESULT([assuming $PERL as perl location])
	AC_SUBST(PERL)
])

dnl mg_CHECK_ARCH_PERL
AC_DEFUN([mg_CHECK_ARCH_PERL], [
	mg_ARG_WITH([arch-perl], [whether to install perllib/Arch, auto-detected], [WITH_ARCH_PERL])
	if test x"$WITH_ARCH_PERL" = x; then
		if $PERL -e "use Arch $REQUIRED_ARCH_PM_VERSION" 2>/dev/null; then
			WITH_ARCH_PERL=no
		else
			WITH_ARCH_PERL=yes
		fi
	fi
#	if ! $PERL -Iperllib -e "use Arch $REQUIRED_ARCH_PM_VERSION" 2>/dev/null; then
#		AC_MSG_WARN([It seems your perllib/Arch version is old])
#	fi
	AC_SUBST(WITH_ARCH_PERL)
	if test -d '{arch}'; then
		( \
			echo .extra-dist; \
			tla inventory -s | grep -v '^perllib/Arch$'; \
			tla inventory -s perllib/Arch \
		) | env LANG=C sort >.extra-dist
	else
		echo "Do not check arch devel dependencies" >check-dependencies
	fi
])

