# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package ArchZoom::TemplateEngine;

use Arch::Util qw(load_file);
use ArchZoom::TemplateEngine::Native;

sub new ($@) {
	my $class = shift;
	my %init = @_;

	my $dir = $init{dir} || die "TemplateEngine: No template dir\n";
	my $set = $init{set} || die "TemplateEngine: No template set\n";
	my $set_dir = "$init{dir}/$init{set}";
	die "No template dir $dir\n" unless -d $dir;
	die "No template set dir $set_dir" unless -d $set_dir;
	my $engine = "Native";

	if ($class eq __PACKAGE__) {
		$engine = $1 if load_file("$set_dir/=engine") =~ /^\s*(\w+)\s*$/;
		$class = "${class}::$engine"
	}

	if ($engine ne "Native" && !(eval "use $class;" && $class->isa(__PACKAGE__)))	{
		warn "$@Can't load $engine engine, reverting to default template set\n";
		return ArchZoom::TemplateEngine::Native->new(
			dir => $dir, set => 'default',
		);
	}

	my $self = {
		dir => $dir,
		set => $set,
		set_dir => $set_dir,
		engine => $engine,
		default_stash => $class->get_builtin_stash,
	};

	return bless $self, $class;
}

sub get_builtin_stash ($) {
	$ArchZoom::VERSION ||= "";
	$ArchZoom::VERSIONINFO ||= "";
	%ArchZoom::Config || ();
	return {
		archzoom_version => "$ArchZoom::VERSION$ArchZoom::VERSIONINFO",
		Config => \%ArchZoom::Config,
	};
}

sub add_default_stash ($%) {
	my $self = shift;
	my %stash = @_;
	while (my ($key, $value) = each %stash) {
		$self->{default_stash}{$key} = $value if defined $value;
	}
}

1;
