
/*
 * Argus Client Software.  Tools to read, analyze and manage Argus data.
 * Copyright (C) 2000-2001 QoSient, LLC.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 */

/*
 * rahosts - argus data client  that printouts the unique IP addrs in
 *           in data stream.
 *
 * written by Carter Bullard
 * QoSient, LLC
 *
 */


#include <argus_client.h>
int RaInitialized = 0;

void
ArgusClientInit ()
{
   if (!(RaInitialized)) {
      RaInitialized++;
   }
}

int RaParseCompleting = 0;

struct hnamemem {
   arg_uint32 addr;
   char *name;
   struct hnamemem *nxt;
};

void
RaParseComplete (int sig)
{
   int i;
   extern struct hnamemem hnametable[];
   struct hnamemem *p;

   if (!RaParseCompleting) {
      RaParseCompleting++;
   }

   for (i = 0; i < HASHNAMESIZE; i++) {
      p = &hnametable[i];
      while (p && p->name) {
         printf ("%s\n", p->name);
         p = p->nxt;
      }
   }
   fflush (stdout);
}

void
ArgusClientTimeout ()
{
}

void
parse_arg (int argc, char**argv)
{ 
}


void
usage ()
{
   extern char version[];
   fprintf (stderr, "Ratemplate Version %s\n", version);
   fprintf (stderr, "usage: %s \n", ArgusProgramName);
   fprintf (stderr, "usage: %s [options] -S remoteServer  [- filter-expression]\n", ArgusProgramName);
   fprintf (stderr, "usage: %s [options] -r argusDataFile [- filter-expression]\n\n", ArgusProgramName);

   fprintf (stderr, "options: -a             print record summaries on termination.\n");
   fprintf (stderr, "         -A             print application bytes.\n");
   fprintf (stderr, "         -b             dump packet-matching code.\n");
   fprintf (stderr, "         -c             print packet and byte counts.\n");
   fprintf (stderr, "         -C             treat the remote source as a Cisco Netflow source.\n");
   fprintf (stderr, "         -D <level>     specify debug level\n");
   fprintf (stderr, "         -E <file>      write records that are rejected by the filter into <file>\n");
   fprintf (stderr, "         -f <flowfile>  read flow model from <flowfile>.\n");
   fprintf (stderr, "         -F <conffile>  read configuration from <conffile>.\n");
   fprintf (stderr, "         -g             print record time duration.\n");
   fprintf (stderr, "         -G             print both start and last time values.\n");
   fprintf (stderr, "         -h             print help.\n");
   fprintf (stderr, "         -I             print transaction state and option indicators.\n");
   fprintf (stderr, "         -l             print last time values [default is start time].\n");
   fprintf (stderr, "         -m             print MAC addresses.\n");
   fprintf (stderr, "         -n             don't convert numbers to names.\n");
   fprintf (stderr, "         -p <digits>    print fractional time with <digits> precision.\n");
   fprintf (stderr, "         -P <portnum>   specify remote argus <portnum> (tcp/561).\n");
   fprintf (stderr, "         -q             quiet mode. don't print record outputs.\n");
   fprintf (stderr, "         -r <file>      read argus data <file>. '-' denotes stdin.\n");
   fprintf (stderr, "         -R             print out response data when availabile.\n");
   fprintf (stderr, "         -S <host>      specify remote argus <host>.\n");
   fprintf (stderr, "         -t <timerange> specify <timerange> for reading records.\n");
   fprintf (stderr, "               format:  timeSpecification[-timeSpecification]\n");
   fprintf (stderr, "                        timeSpecification: [mm/dd[/yy].]hh[:mm[:ss]]\n");
   fprintf (stderr, "                                            mm/dd[/yy]\n");
   fprintf (stderr, "         -T <secs>      attach to remote server for T seconds.\n");
   fprintf (stderr, "         -u             print time in Unix time format.\n");
#ifdef ARGUS_SASL
   fprintf (stderr, "         -U <user/auth> specify <user/auth> authentication information.\n");
#endif
   fprintf (stderr, "         -w <file>      write output to <file>. '-' denotes stdout.\n");
   fprintf (stderr, "         -z             print Argus TCP state changes.\n");
   fprintf (stderr, "         -Z <s|d|b>     print actual TCP flag values.<'s'rc | 'd'st | 'b'oth>\n");
   exit(1);
}


void
RaProcessRecord (struct ArgusRecord *argus)
{
   char *str;

   str = getname((unsigned char *)&argus->argus_far.flow.ip_flow.ip_src);
   str = getname((unsigned char *)&argus->argus_far.flow.ip_flow.ip_dst);
}


void
process_man (struct ArgusRecord *argus)
{
}


void
process_tcp (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_icmp (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_udp (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_ip (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_arp (struct ArgusRecord *argus)
{
   RaProcessRecord (argus);
}


void
process_non_ip (struct ArgusRecord *argus)
{
}

void RaSendArgusRecord(struct ArgusRecordStore *argus) {};

