#! /usr/bin/perl 
#  Copyright (c) 2000-2001 QoSient, LLC
#  All rights reserved.
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear
#  in supporting documentation, and that the name of QoSient not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  QOSIENT, LLC DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
#  SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
#  FITNESS, IN NO EVENT SHALL QOSIENT, LLC BE LIABLE FOR ANY
#  SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
#  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
#  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
#  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# ragraph-histogram.pl
#  
#
use lib qw( /usr/local/rrdtool-1.0.33/lib/perl ../lib/perl );
use RRDs;
use POSIX;
use strict;

print "@ARGV\n";
my $tmpfile = @ARGV;
my $title = @ARGV;

open(SESAME, @ARGV);
my $k;
my $v;
my $data;
my $START;
my $END;
my $STEP;
my $COLUMNS;
my $RUNS;

for (1 .. 6) {
   if ($data = <SESAME>) {
      if ( ($k, $v) = $data =~ m/(\w+)=(\w*)/ ) {
         for ($k) {
            /StartTime/	and do {$START = $v;};
            /StopTime/	and do {$END = $v;};
            /BinSize/	and do {$STEP = $v;};
            /Columns/	and do {$COLUMNS = $v;};
            /Bins/	and do {$RUNS = $v;};
         }
      }
   }
}

print "input   is $tmpfile\n";
print "start   is $START\n";
print "end     is $END\n";
print "binsize is $STEP\n";

my $RRD   = "/tmp/ragraph-histogram.rrd";
my $GIF   = "/tmp/ragraph.gif";

$START = $START - 1;

my @options = ("-b", $START, "-s", $STEP,
 "DS:srcPkts:GAUGE:$STEP:U:U",
 "DS:dstPkts:GAUGE:$STEP:U:U",
 "DS:srcBytes:GAUGE:$STEP:U:U",
 "DS:dstBytes:GAUGE:$STEP:U:U",
 "RRA:AVERAGE:0.5:1:100000");

RRDs::create $RRD, @options;

my $ERROR = RRDs::error;
if ($ERROR) {
  die "$0: unable to create `$RRD': $ERROR\n";
}

my $last = RRDs::last $RRD;
if ($ERROR = RRDs::error) {
  die "$0: unable to get last `$RRD': $ERROR\n";
}

@options = ();

while (my $data = <SESAME>) {
   push(@options, "$data");
   RRDs::update $RRD, "$data";

   if ($ERROR = RRDs::error) {
      die "$0: unable to update `$RRD': $ERROR\n";
   }
}

close(SESAME);

my @rrd_gifs = ($RRD, $GIF);
while (@rrd_gifs) {
  my $RRD = shift(@rrd_gifs);
  my $GIF = shift(@rrd_gifs);
  my ($graphret,$xs,$ys) = RRDs::graph $GIF, "--title", $title, 
      '--base', '1024',
      "--vertical-label", 'Packets Per Sec',
#     "--x-grid", $xgrid,
      "--start", $START,
      "--end", $END,
#     "--logarithmic",
      "--width", 800, "--height", 275,
      "--interlace", "--imgformat","GIF",
      "DEF:alpha=$RRD:srcPkts:AVERAGE",
      "CDEF:ralpha=alpha,$STEP,/",
      "DEF:beta=$RRD:dstPkts:AVERAGE",
      "CDEF:rbeta=beta,$STEP,/",
#     "DEF:gamma=$RRD:srcBytes:AVERAGE",
#     "CDEF:rgamma=gamma,$STEP,/",
#     "DEF:delta=$RRD:dstBytes:AVERAGE",
#     "CDEF:rdelta=delta,$STEP,/",
      "LINE1:ralpha#e00000:SrcPkts",
      "LINE2:rbeta#0000e0:DstPkts";
#     "LINE2:rgamma#00f000:SrcBytes",
#     "LINE3:rdelta#104f04:DstBytes";

   if ($ERROR = RRDs::error) {
      print "ERROR: $ERROR\n";
   }
}

`rm $tmpfile $RRD`
