/*
 * Copyright (c) 2001 Tony Sideris
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __UTILS_H__
#define __UTILS_H__

#include <qvaluelist.h>
#include <qstring.h>
#include <qxml.h>

/*========================================================*/

class ArsonNetFile
{
public:
	ArsonNetFile (void) {}
	ArsonNetFile (const KURL &url);
	ArsonNetFile (const ArsonNetFile &nf)
		: m_local(nf.m_local), m_bLocal(nf.m_bLocal) { }

	~ArsonNetFile (void);

	const QString &path (void) const { return m_local; }

private:
	QString m_local;
	bool m_bLocal;
};

/*========================================================*/

class ArsonFileListDoc;

class ArsonFileFilter
{
	class Filter {
	public:
		Filter (const QString &str = QString::null) { fromString(str); }
		Filter (const QString &desc, const QString &filter)
			: m_desc(desc), m_filter(filter) { }

		void fromString (const QString &str);
		QString toString (void) const;

		const QString &filter (void) const { return m_filter; }
		const QString &desc (void) const { return m_desc; }

		bool operator== (const Filter &filt) const
		{ return (filter() == filt.filter() && desc() == filt.desc()); }

	private:
		QString m_filter;
		QString m_desc;
	};

	typedef QValueList<Filter> FILTERS;
	
public:
	enum {
		AllFiles = 0x01,
		AllTypes = 0x02,
		Default = (AllFiles | AllTypes)
	};

	ArsonFileFilter (uint flags = Default) : m_flags(flags) { }
	ArsonFileFilter (const QString &init, uint flags = Default);
	ArsonFileFilter (const QString *arr, size_t cnt, uint flags = Default);
	ArsonFileFilter (ArsonFileListDoc *pd, uint flags = Default);

	void fromString (const QString &str);
	QString toString (void) const;
	QString filters (void) const;

	void addFilter (const QString &desc, const QString &filter);
	void addFilter (const Filter &filter);
	void addFilter (const QString &str);

	static const Filter allFiles;

private:
	FILTERS m_filters;
	uint m_flags;
};

/*========================================================*/

class ArsonUserCfg : public QXmlDefaultHandler
{
public:
	ArsonUserCfg (void)
		: QXmlDefaultHandler()
	{}

	int readConfig (const char *fname, bool userOnly = false);

	enum {
		global = 0x01,
		local = 0x02,
	};
	
protected:
	bool readCfg (const char *fname);
};

/*========================================================*/
#endif	/*	__UTILS_H__	*/
