------------------------------------------------------------------------------
--                                                                          --
--                          GNATCHECK COMPONENTS                            --
--                                                                          --
--      G N A T S Y N C . G L O B A L _ I N F O . C A L L _ G R A P H       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                       Copyright (C) 2007, AdaCore                        --
--                                                                          --
-- GNATSYNC  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATSYNC is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

--  The package contains data structures and routines that implement a call
--  graph.

package Gnatsync.Global_Info.Call_Graph is

   procedure Collect_Call_Graph_Info (El : Element);
   --  If the argument Element is a scope or a callable entity, stores it as
   --  a node in the call graph (if it has not been stored yet). If it is a
   --  scope, put it in the scope stack. If it is a call, stores the
   --  corresponding link. See the body for more details.
   --
   --  This procedure also generates diagnostic messages in case when it
   --  detects situations that do not allow to do the statical call graph
   --  analyzis (such as dispatching calls or bynaming subprogram calls through
   --  an access-to-subprogram value).

   procedure Complete_Call_Graph_Info (El : Asis.Element);
   --  This procedure is supposed to be called during the element traversal
   --  as a part of post-operation for each element being visited. It completes
   --  the information stored in the call graph for the given Element and
   --  updates the scope stack if needed

end Gnatsync.Global_Info.Call_Graph;
