------------------------------------------------------------------------------
--                                                                          --
--                 ASIS-for-GNAT IMPLEMENTATION COMPONENTS                  --
--                                                                          --
--                             A 4 G . N O R M                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- ASIS-for-GNAT is free software; you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. ASIS-for-GNAT is distributed  in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License  distributed with ASIS-for-GNAT; see file     --
-- COPYING. If not, write to the Free Software Foundation,  59 Temple Place --
-- - Suite 330,  Boston, MA 02111-1307, USA.                                --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- ASIS-for-GNAT was originally developed  by the ASIS-for-GNAT team at the --
-- Software  Engineering  Laboratory  of  the Swiss  Federal  Institute  of --
-- Technology (LGL-EPFL) in Lausanne,  Switzerland, in cooperation with the --
-- Scientific  Research  Computer  Center of  Moscow State University (SRCC --
-- MSU), Russia,  with funding partially provided  by grants from the Swiss --
-- National  Science  Foundation  and  the  Swiss  Academy  of  Engineering --
-- Sciences.  ASIS-for-GNAT is now maintained by  Ada Core Technologies Inc --
-- (http://www.gnat.com).                                                   --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines routines needed for yielding and processing
--  normalized associations and their components

with Asis;

with Types; use Types;

package A4G.Norm is

   ---------------------------------------
   -- Obtaining normalized associations --
   ---------------------------------------

   function Normalized_Param_Associations
     (Call_Elem : Asis.Element;
      Call_Node : Node_Id)
      return Asis.Association_List;
   --  creates the list of normalized associations for a given call to an
   --  entry, a procedure or to a function (is intended to be used in the
   --  implementation of Asis.Expressions.Function_Call_Parameters and
   --  Asis.Statements.Call_Statement_Parameters)
   --  This function assumes, that Call_Node is of N_Function_Call or
   --  of N_Procedure_Call kind, it is an error to call it for other
   --  nodes. This function also assumes, that the association list
   --  to be returned cannot be empty. It is an error to call it when
   --  Sinfo.Parameter_Assoccciations function gives No_List for
   --  Call_Node

   function Normalized_Discriminant_Associations
     (Constr_Elem : Asis.Element;
      Constr_Node : Node_Id)
      return Asis.Association_List;
   --  creates the list of normalized associations for a given discriminant
   --  constraint; is intended to be used in the implementation of
   --  Asis.Definitions.Discriminant_Associations. This function assumes,
   --  that Constr_Node is of N_Index_Or_Discriminant_Constraint,
   --  it is an error to call it for other nodes.

   function Normalized_Generic_Associations
     (Inst_Elem          : Asis.Element;
      Templ_Node         : Node_Id;
      Association_Number : Positive)
      return Asis.Association_List;
   --  creates the list of normalized associations for a given generic
   --  instantiation (is intended to be used in the implementation of
   --  Asis.Decalarations.Generic_Actual_Part. Templ_Node should be the
   --  node representing the corresponding generic template declaration,
   --  and Association_Numder should be the number of its formal parameters.
   --
   --  See the documentation of the body for the description of the
   --  representation of the normalized generic associations.

   function Defining_Gen_Parameter (Gen_Form_Par : Node_Id) return Node_Id;
   --  Assuming that Gen_Form_Par is a node representing a
   --  generic_formal_parameter_SELECTOR_NAME (it is an error to call this
   --  function for another actual!!!), this function finds the node
   --  representing the defining occurrence of this generic formal
   --  parameter.
   --
   --  ??? Is here a really good place for this function?
   --
   --  ???  And do we really need it???
   --
   --  For now this function is PARTIALLY IMPLEMENTED - it can work only
   --  with a generic_formal_parameter_SELECTOR_NAME which is
   --  operator_symbol "+" or "-"

   ----------------------------------------
   -- Processing normalized associations --
   ----------------------------------------

   function Discr_Def_Name
     (Association : in Asis.Discriminant_Association)
      return Asis.Defining_Name;
   --  from a normalized discriminant association  this function creates
   --  the ASIS Element representing the defining occurrence of the
   --  discriminant. (Is intended to be used in
   --  Asis.Expressions.Discriminant_Selector_Names).
   --
   --  !!!NOTE: for now the implementation is unstable and definitely
   --           contains holes.
end A4G.Norm;