------------------------------------------------------------------------------
--                                                                          --
--                      DISPLAY_SOURCE COMPONENTS                           --
--                                                                          --
--                         I M A G E _ T R A V                              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--            Copyright (c) 1995-1999, Free Software Foundation, Inc.       --
--                                                                          --
-- Display_Source is free software; you can redistribute it and/or modify it--
-- under terms of the  GNU General Public License  as published by the Free --
-- Software Foundation;  either version 2,  or  (at your option)  any later --
-- version. Display_Source is distributed in the hope  that it will be use- --
-- ful, but WITHOUT ANY WARRANTY; without even the implied warranty of MER- --
-- CHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General  --
-- Public License for more details. You should have received a copy of the  --
-- GNU General Public License distributed with GNAT; see file COPYING. If   --
-- not, write to the Free Software Foundation, 59 Temple Place Suite 330,   --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
-- Display_Source is distributed as a part of the ASIS implementation for   --
-- GNAT (ASIS-for-GNAT).                                                     --
--                                                                          --
-- The   original   version   of  Display_Source  has  been  developed  by  --
-- Jean-Charles  Marteau and Serge Reboul,  ENSIMAG  High School Graduates  --
-- (Computer sciences)  Grenoble,  France  in  Sema Group Grenoble, France. --
--                                                                          --
-- Display_Source is now maintained by Ada Core Technologies Inc            --
-- (http://www.gnat.com).                                                   --
------------------------------------------------------------------------------

-----------------------------------------------------------------
-- This package is part of the ASIS application display_source --
-----------------------------------------------------------------
--  It contains procedures to instantiate Traverse_Element with --
--  in order to make an image display of a source. (ie it      --
--  displays something closer to the initial source than        --
--  source display)                                            --
--  If you compare it with source_trav, you'll see that it's    --
--  based on Asis.Text, it's simpler, and probably better as    --
--  a basis for many applications that would display Ada sources--
--                                                              --
--  The basic principle of this application is to use spans,    --
--  so we deal with spans corresponding to elements and span    --
--  corresponding to the space between elements.                --
-----------------------------------------------------------------

with Asis;
with Asis.Text;

package Image_Trav is

   type Info_Image is record
      --  Last_Printed_Span is used to know what has already been displayed
      --  it is assumed that everything before the end of this span has been
      --  displayed.
      Last_Printed_Span : Asis.Text.Span := Asis.Text.Nil_Span;
      --  An_Element is used by terminate_image in order to have some
      --  element in the concerned library ...
      --  You must set this to some element of your compilation_unit if you
      --  want terminate_image to work.
      An_Element : Asis.Element := Asis.Nil_Element;
      --  Finishing_Traversal is used by terminate_image to finish the
      --  the application.
      Finishing_Traversal : Boolean := False;
      --  Horizontal_Position is the current position of the cursor
      --  in the output text.
      --  It can be used as an indentation when you want to replace
      --  something with another. (After a Display_Before).
      Horizontal_Position : Natural := 0;
      --  With_Comments says if we want or not to see comments displayed.
      With_Comments : Boolean := True;
      --  Handled_In_Pre : if True, it says to post_operation that the
      --  last element has been displayed in Pre_operation and that
      --  there is no point in printing it again ...
      Handled_In_Pre : Boolean := False;
   end record;

   procedure Pre_Image
     (Element : in     Asis.Element;
      Control : in out Asis.Traverse_Control;
      State   : in out Info_Image);

   procedure Post_Image
     (Element : in     Asis.Element;
      Control : in out Asis.Traverse_Control;
      State   : in out Info_Image);

   procedure Initiate_Image
     (Element : in     Asis.Element;
      Control : in out Asis.Traverse_Control;
      State   : in out Info_Image);

   procedure Terminate_Image
     (Control : in out Asis.Traverse_Control;
      State : in out Info_Image);

end Image_Trav;