#ifndef __skip_t_hh__
#define __skip_t_hh__

#include "skip.hh"
#include "clone_ptr-t.hh"

namespace afilter {

  template <typename RS>
  RegionSkipItr<RS>::RegionSkipItr() 
    : blank_char(' ') 
  {}

  template <typename RS>
  RegionSkipItr<RS>::RegionSkipItr(ConfigData & opts)
    : skip (opts), blank_char(' ')
  {}

  template <typename RS>
  RegionSkipItr<RS>::RegionSkipItr(const RS & rs)
    : skip (rs), blank_char(' ')
  {}

  template <typename RS>
  RegionSkipItr<RS> * RegionSkipItr<RS>::clone() const {
    return new RegionSkipItr(*this);
  }

  template <typename RS>
  void RegionSkipItr<RS>::assign(const FilterItrPart * other) {
    *this = *static_cast<const RegionSkipItr *>(other);
  }

  template <typename RS>
  string RegionSkipItr<RS>::name() const {
    return skip.name();
  }

  template <typename RS>
  double RegionSkipItr<RS>::order_num() const {
    return skip.order_num();
  }

  template <typename RS>
  void RegionSkipItr<RS>::reset() {
    skip.reset();
  }

  template <typename RS>
  void RegionSkipItr<RS>::scan(const FilterItrRoot & stop) {
    skip.scan(*itr, stop);
  }


  template <typename RS>
  char RegionSkipItr<RS>::first() {
    char c = itr->first();
    if (blank_char == '\0')
      while (c != 0 && skip.skip(c,itr)) c = itr->next();
    else
      if (skip.skip(c,itr)) return blank_char;
    return c;
  }

  template <typename RS>
  char RegionSkipItr<RS>::next() {
    char c = itr->next();
    if (blank_char == '\0')
      while (c != 0 && skip.skip(c,itr)) c = itr->next();
    else
      if (skip.skip(c,itr)) return blank_char;
    return c;
  }
}
#endif
