// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#ifndef __aspell_invalid_word__
#define __aspell_invalid_word__

#include "file_exceps.hh"

namespace aspell {
  
  using namespace autil;

  struct InvalidWord : public Exception, public RethrowWFile
  {
    string word;
    InvalidWord(const string & w, const string & m);
    ~InvalidWord() throw() {}
    void rethrow_w_file(const string &f) const;
  protected:
    InvalidWord(const string & w);
    void add_message(const string & m);
  };

  struct InvalidWordInFile : public InvalidWord, public WithFileException
  {
    InvalidWordInFile(const string & w, const string & m, const string & f);
    ~InvalidWordInFile() throw() {}
  };
}

#endif
