// Copyright 2000 by Kevin Atkinson under the terms of the LGPL

#include "invalid_word.hh"

namespace aspell {

  void InvalidWord::add_message(const string & m) {
    message += "Invalid word \"";
    message += word;
    message += "\": ";
    message += m;
  }

  InvalidWord::InvalidWord(const string & w) 
    : word(w.c_str())
  {
    number = PERROR_INVALID_WORD; 
 }

  InvalidWord::InvalidWord(const string & w, const string & m) 
    : word(w)
  {
    number = PERROR_INVALID_WORD;
    add_message(m);
  }

  void InvalidWord::rethrow_w_file(const string & f) const {
    InvalidWordInFile e(word, message, f);
    throw e;
  }

  InvalidWordInFile::InvalidWordInFile(const string & w, 
				       const string & m, 
				       const string & f) 
    : InvalidWord(w), WithFileException(f)
  {
    message += "In file \"";
    message += f;
    message += "\": ";
    add_message(m);
  }
}
