# -*- mode: python; coding: utf-8 -*-

import atheist


class TaskFinished(atheist.Condition):
    """Check if some tasks has been executed or not (pending of execution)"""

    def __init__(self, *tasks):
        for t in tasks:
            assert isinstance(t, atheist.Task)
        self.the_tasks = list(tasks)[:]
        atheist.Condition.__init__(self)

    def run(self):
        return all([t.result in (atheist.FAIL, atheist.OK)
                    for t in self.the_tasks])


class TaskRunning(atheist.Condition):
    """Check whether some tasks is running or not"""

    def __init__(self, *tasks):
        for t in tasks:
            assert isinstance(t, atheist.Task)
        self.the_tasks = list(tasks)[:]
        atheist.Condition.__init__(self)

    def run(self):
        return all([(t.ps is not None) and (t.ps.poll() is None)
                    for t in self.the_tasks])

    def basic_info(self):
        return "%s" % [t.name for t in self.the_tasks]


class TaskTerminator(atheist.Task):
    """A special task to kill and ensure the termination of other tasks."""

    def __init__(self, *tasks, **kargs):
        if isinstance(tasks, atheist.Task):
            tasks = [tasks]

        self.tasks = atheist.TypedList(atheist.Task)
        for t in tasks:
            self.tasks += t

        atheist.Task.__init__(self, **kargs)

        # FIXME: aún no está fijado el indx
        self.desc = "Terminates %s" % \
            ', '.join(['T'+str(x.indx) for x in self.tasks])

        for t in self.tasks:
            self.post += atheist.Poll(atheist.Not(TaskRunning(t)))

    def exec_task(self):
        for t in self.tasks:
            self.log.debug("terminates %s sending signal %s" % \
                               (t.name, t.signal))
            t.kill()

    def str_param(self):
        return [x.name for x in self.tasks]

