// This file may be redistributed and modified only under the terms of
// the GNU Lesser General Public License (See COPYING for details).
// Copyright (C) 2000-2001 Stefanus Du Toit

#include <Atlas/Objects/Decoder.h>

#include <Atlas/Objects/Root.h>
#include <Atlas/Objects/Entity/Account.h>
#include <Atlas/Objects/Entity/Admin.h>
#include <Atlas/Objects/Entity/AdminEntity.h>
#include <Atlas/Objects/Entity/Game.h>
#include <Atlas/Objects/Entity/Player.h>
#include <Atlas/Objects/Entity/RootEntity.h>
#include <Atlas/Objects/Operation/Action.h>
#include <Atlas/Objects/Operation/Appearance.h>
#include <Atlas/Objects/Operation/Combine.h>
#include <Atlas/Objects/Operation/Communicate.h>
#include <Atlas/Objects/Operation/Create.h>
#include <Atlas/Objects/Operation/Delete.h>
#include <Atlas/Objects/Operation/Disappearance.h>
#include <Atlas/Objects/Operation/Divide.h>
#include <Atlas/Objects/Operation/Error.h>
#include <Atlas/Objects/Operation/Feel.h>
#include <Atlas/Objects/Operation/Get.h>
#include <Atlas/Objects/Operation/Imaginary.h>
#include <Atlas/Objects/Operation/Info.h>
#include <Atlas/Objects/Operation/Listen.h>
#include <Atlas/Objects/Operation/Login.h>
#include <Atlas/Objects/Operation/Logout.h>
#include <Atlas/Objects/Operation/Look.h>
#include <Atlas/Objects/Operation/Move.h>
#include <Atlas/Objects/Operation/Perceive.h>
#include <Atlas/Objects/Operation/Perception.h>
#include <Atlas/Objects/Operation/RootOperation.h>
#include <Atlas/Objects/Operation/Set.h>
#include <Atlas/Objects/Operation/Sight.h>
#include <Atlas/Objects/Operation/Smell.h>
#include <Atlas/Objects/Operation/Sniff.h>
#include <Atlas/Objects/Operation/Sound.h>
#include <Atlas/Objects/Operation/Talk.h>
#include <Atlas/Objects/Operation/Touch.h>

using Atlas::Message::Element;

#define ARR(a, b) if (parent == a) { \
    b obj; \
    for (Element::MapType::const_iterator I = o.asMap().begin(); \
            I != o.asMap().end(); I++) \
        obj.setAttr(I->first, I->second); \
    objectArrived(obj);\
    return;\
}

namespace Atlas { namespace Objects {

Decoder::~Decoder()
{
}

void Decoder::objectArrived(const Element& o)
{
    if (!o.isMap()) return;
    Element::MapType::const_iterator I = o.asMap().find("parents");
    if (I == o.asMap().end())
        { unknownObjectArrived(o); return; }
    if ((*I).second.asList().size() != 1)
        { unknownObjectArrived(o); return; }
    
    const std::string & parent = (*(*I).second.asList().begin()).asString();
    
    ARR("root", Root)
    ARR("account", Entity::Account)
    ARR("admin", Entity::Admin)
    ARR("admin_entity", Entity::AdminEntity)
    ARR("game", Entity::Game)
    ARR("player", Entity::Player)
    ARR("root_entity", Entity::RootEntity)
    ARR("action", Operation::Action)
    ARR("appearance", Operation::Appearance)
    ARR("combine", Operation::Combine)
    ARR("create", Operation::Create)
    ARR("delete", Operation::Delete)
    ARR("disappearance", Operation::Disappearance)
    ARR("divide", Operation::Divide)
    ARR("error", Operation::Error)
    ARR("feel", Operation::Feel)
    ARR("get", Operation::Get)
    ARR("imaginary", Operation::Imaginary)
    ARR("info", Operation::Info)
    ARR("listen", Operation::Listen)
    ARR("login", Operation::Login)
    ARR("logout", Operation::Logout)
    ARR("look", Operation::Look)
    ARR("move", Operation::Move)
    ARR("perceive", Operation::Perceive)
    ARR("perception", Operation::Perception)
    ARR("root_operation", Operation::RootOperation)
    ARR("set", Operation::Set)
    ARR("sight", Operation::Sight)
    ARR("smell", Operation::Smell)
    ARR("sniff", Operation::Sniff)
    ARR("sound", Operation::Sound)
    ARR("talk", Operation::Talk)
    ARR("touch", Operation::Touch)

    unknownObjectArrived(o);
}

} } // namespace Atlas::Objects
