/****************************************************************
**
** Attal : Lords of Doom
**
** insideAction.cpp
** Dialogs for actions of inside buildings
**
** Version : $Id: insideAction.cpp,v 1.11 2004/12/07 19:05:29 lusum Exp $
**
** Author(s) : Pascal Audoux - Sardi Carlo 
**
** Date : 10/05/2002
**
** Licence :
**	This program is free software; you can redistribute it and/or modify
**   	it under the terms of the GNU General Public License as published by
**     	the Free Software Foundation; either version 2, or (at your option)
**      any later version.
**
**	This program is distributed in the hope that it will be useful,
** 	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
**
****************************************************************/

#include "insideAction.h"

// generic include files
// include files for QT
#include <qlabel.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include <qsignalmapper.h>
// application specific include files
#include "libClient/displayCreature.h"
#include "libClient/gui.h"
#include "libCommon/attalSocket.h"
#include "libCommon/dataTheme.h"
#include "libCommon/genericBase.h"
#include "libCommon/genericInsideBuilding.h"
#include "libCommon/genericPlayer.h"
#include "libCommon/genericRessources.h"
#include "libCommon/genericInsideBuilding.h"

extern QString IMAGE_PATH;
extern DataTheme DataTheme;

//
// ----- InsideActionAllBuildings -----
//

InsideActionAllBuildings::InsideActionAllBuildings( GenericBase * base, QWidget * parent, const char * name )
	:QDialog( parent, name, true )
{
	_base = base;
	_socket = 0;
	_player = 0;
	_buildings = 0;

	QVBoxLayout * layout = new QVBoxLayout( this );

	QScrollView * scroll = new QScrollView( this );
	scroll->setVScrollBarMode( QScrollView::AlwaysOn );
	_buildings = new BuildingsView( base, scroll->viewport() );
	scroll->addChild( _buildings );
	layout->addWidget( scroll, 1 );
	//layout->addStretch( 1 );

	QHBoxLayout * layH = new QHBoxLayout();
	layH->addStretch( 1 );
	QPushButton * pbOk = createButtonOk( this );
	layH->addWidget( pbOk );
	layH->addStretch( 1 );
	layout->addSpacing( 5 );
	layout->addLayout( layH );

	layout->activate();

	connect( pbOk, SIGNAL( clicked() ), SLOT( accept() ) );
	connect( _buildings, SIGNAL( sig_buy( int ) ), SLOT( slot_buy( int ) ) );
	connect( _buildings, SIGNAL( sig_sell( int ) ), SLOT( slot_sell( int ) ) );
	setFixedSize( 800, 600 );
}

void InsideActionAllBuildings::slot_buy( int building )
{
	// XXX: check if 'buy' is possible...
	if( _player && _socket ) {
		if( _player->canBuy( DataTheme.bases.at( _base->getRace() )->getBuildingModel( building ) ) ) {
			_socket->requestBuilding( _base, building, true );
		} else {
			QMessageBox::warning( this, "Can't buy", "Not enough ressources to buy this building" );
		}
	} else {
		logEE( "Player or socket not initialized for InsideActionAllBuildings" );
	}
}

void InsideActionAllBuildings::slot_sell( int building )
{	
	if( _player && _socket ) {	
		QMessageBox msb( tr( "Building" ), tr( "Are you sure to sell this building?" ), QMessageBox::Warning, QMessageBox::Yes | 			QMessageBox::Default, QMessageBox::No | QMessageBox::Escape, 0, this );
		if( msb.exec() == QMessageBox::Yes){
			_socket->requestBuilding( _base, building, false );
		}
	}
}

void InsideActionAllBuildings::updateView()
{
	_buildings->updateView();
}


//
// ----- BuildingsView -----
//

BuildingsView::BuildingsView( GenericBase * base, QWidget * parent, const char * name )
	:QWidget( parent, name )
{
	_base=base;
	QSignalMapper * sigmap = new QSignalMapper( this );
	QSignalMapper * sigmap2 = new QSignalMapper( this );
	GenericBaseModel * baseModel = DataTheme.bases.at( base->getRace() );
	QVBoxLayout * layout = new QVBoxLayout( this );

	_panels = new BuildingPanel * [baseModel->getBuildingCount()];
	for( uint i = 0; i < baseModel->getBuildingCount(); i++ ) {
		_panels[i] = 0;
		if( ! base->isForbidden( i ) ) {
			InsideBuildingModel * building = baseModel->getBuildingModel( i );
			_panels[i] = new BuildingPanel( building, this );
			layout->addWidget( _panels[i] );
			sigmap->setMapping( _panels[i], i );
			sigmap2->setMapping( _panels[i], i );
			connect( _panels[i], SIGNAL( sig_buy() ), sigmap, SLOT( map() ) );
			connect( _panels[i], SIGNAL( sig_sell() ), sigmap2, SLOT( map() ) );
			if( base->hasBuildingType( i ) ) {
				_panels[i]->setBuyable( false );
				_panels[i]->setSellable( true );
			} else {
				_panels[i]->setBuyable( true );
				_panels[i]->setSellable( false );
			}
		}
	}

	layout->activate();
	connect( sigmap, SIGNAL( mapped( int ) ), SIGNAL( sig_buy( int ) ) );
	connect( sigmap2, SIGNAL( mapped(int) ), SIGNAL( sig_sell(int) ) );
}

void BuildingsView::buy( int building )
{
	if( _panels[building] ) {
		_panels[building]->setBuyable( false );
		_panels[building]->setSellable( true );
	}
}

void BuildingsView::updateView()
{
	GenericBaseModel * baseModel = DataTheme.bases.at( _base->getRace() );
	for( uint i = 0; i < baseModel->getBuildingCount(); i++ ) {
		if( ! _base->isForbidden( i ) ) {
			if( _base->hasBuildingType( i ) ) {
				_panels[i]->setBuyable( false );
				_panels[i]->setSellable( true );
			} else {
				_panels[i]->setBuyable( true );
				_panels[i]->setSellable( false );
			}
		}
	}
}

//
// ----- BuildingPanel -----
//

BuildingPanel::BuildingPanel( InsideBuildingModel * model, QWidget * parent, const char * name )
	:QFrame( parent, name )
{
	_model = model;
	_buyEnabled = true;
	
	setFrameStyle( Box | Raised );
	setLineWidth( 1 );
	setMidLineWidth( 1 );

	// XXX: add pic of building first...
	QLabel * smallPic = new QLabel( this );
	QString pixmapPath;
	pixmapPath.sprintf( "base/buildingView_%d_%d.png", _model->getRace(), _model->getLevel() );
	smallPic->setPixmap( IMAGE_PATH + pixmapPath );
	smallPic->setFixedSize( 100, 80 );

	QLabel * thename = new QLabel( this );
	thename->setText( "Name: " + model->getName() );
	FIXEDSIZE( thename );
	
	QHBoxLayout * layH1 = new QHBoxLayout();
	layH1->addSpacing( 5 );
	layH1->addWidget( thename );
	layH1->addStretch( 1 );
	
	QLabel * desc = new QLabel( this );
	desc->setText( "Description: " + model->getDescription() );
	FIXEDSIZE( desc );
	
	QHBoxLayout * layH2 = new QHBoxLayout();
	layH2->addSpacing( 5 );
	layH2->addWidget( desc );
	layH2->addStretch( 1 );
		
	QVBoxLayout * layV1 = new QVBoxLayout();
	layV1->setMargin( 5 );
	layV1->setSpacing( 5 );
	layV1->addLayout( layH1 );
	layV1->addLayout( layH2 );
	layV1->addStretch( 1 );
	
	QPushButton * pbInfo = new QPushButton( this );
	pbInfo->setText( tr( "Info" ) );
	FIXEDSIZE( pbInfo );
	
	_pbBuySell = new QPushButton( this );
	updateBuySell();
	
	QVBoxLayout * layV2 = new QVBoxLayout();
	layV2->setMargin( 5 );
	layV2->setSpacing( 5 );
	layV2->addStretch( 1 );
	layV2->addWidget( pbInfo );
	layV2->addStretch( 1 );
	layV2->addWidget( _pbBuySell );
	layV2->addStretch( 1 );
	
	QHBoxLayout * layout = new QHBoxLayout( this );
	layout->setMargin( 5 );
	layout->setSpacing( 5 );
	layout->addWidget( smallPic );
	layout->addLayout( layV1 );
	layout->addStretch( 1 );
	layout->addLayout( layV2 );
	layout->activate();
	
	connect( pbInfo, SIGNAL( clicked() ), SLOT( slot_info() ) );
	connect( _pbBuySell, SIGNAL( clicked() ), SLOT( slot_buysell() ) );
}

void BuildingPanel::slot_info()
{
	GenericRessources & themeResources = DataTheme.resources;
	uint nbRes = themeResources.count();
	QString text = "";
	
	for( uint i = 0; i < nbRes; ++i ) {
		if( _model->getCost( i ) != 0 ) {
			if( text != "" ) {
				text += " + ";
			}
			text += QString::number( _model->getCost( i ) )
				+ " " + themeResources.getRessource( i );
		}
	}
	if( text == "" ) {
		text = "0";
	}
	text = tr( "Cost: " ) + text;
	text += tr( "\n" );
	if(_model->getAction()){
		switch (_model->getAction()->getType()){
			case INSIDE_NONE: 
				text+=tr("Not implemented");
				break;
			case INSIDE_VILLAGE: 
				text+=tr("Main Building");
				break;
			case INSIDE_CASTLE: 
				text+=tr("Castle");
				break;
			case INSIDE_CREA:{ 
							 /* specify what kind and number of units produced */
							 text+=tr("Produce ");
							 if(_model->getAction()->getParamNumber() == 3) {
								 text+=QString("%1 ").arg(_model->getAction()->getParam(2));
								 text+= DataTheme.creatures.at(_model->getAction()->getParam(0),_model->getAction()->getParam(1))->getName();
							 }
							 break;
						 }
			case INSIDE_MARKET: 
						 text+=tr("Market");
						 break;
			default: 
						 break;
		}
	} else {
		text+=tr("Not implemented");
	}
			
						
	QMessageBox::information( this, tr( "Building informations" ), text, tr( "Ok" ) );
}

void BuildingPanel::slot_buysell()
{
	if( _buyEnabled ) {
		emit sig_buy();
	} else {
		emit sig_sell();
	}
}

void BuildingPanel::setBuyable( bool state )
{
	_buyEnabled = state;
	updateBuySell();
}

void BuildingPanel::setSellable( bool state )
{
	_buyEnabled = ! state;
	updateBuySell();
}

void BuildingPanel::updateBuySell()
{
	if( _buyEnabled ) {
		_pbBuySell->setText( tr( "Buy" ) );
	} else {
		_pbBuySell->setText( tr( "Sell" ) );
	}
	FIXEDSIZE( _pbBuySell );
}

//
// ----- InsideActionSomeCreature -----
//
/*
InsideActionSomeCreature::InsideActionSomeCreature( int race, int level, QWidget * parent, const char * name )
	: QDialog( parent, name, true )
{
	QGridLayout * layout = new QGridLayout( this );
	DisplayCreature * cre = new DisplayCreature( this );
	cre->setCreature( race, level );
	layout->addWidget( cre, 0, 0 );
	layout->setRowStretch( 0, 1 );
	layout->setColStretch( 0, 1 );
	layout->activate();
}*/

//
// ----- DisplayCreatureBase -----
//

DisplayCreatureBase::DisplayCreatureBase( GenericBase * base ,QWidget * parent, const char * name )
	: QDialog( parent, name, true )
{
	_player = 0;
	_base = base;
	_socket = 0;

	QVBoxLayout * lay = new QVBoxLayout( this );

	uint i,nbLay ;

	QSignalMapper * sigmap = new QSignalMapper( this );
	for( i = 0; i < DataTheme.creatures.getRace(_base->getRace())->count();i++ ) {
		_buy[i] = new DisplayCreature( this );
		_buy[i]->setCreature( _base->getRace(), i );
		
		if((i % 2) == 0){
			nbLay = (i/2) + 1;
			_layH[nbLay] = new QHBoxLayout();
		}
		_layH[nbLay]->addWidget( _buy[i], 1 );
		_layH[nbLay]->addSpacing( 5 );
		sigmap->setMapping( _buy[i], i );
		connect( _buy[i], SIGNAL( sig_clicked() ), sigmap, SLOT( map() ) );
	}

	if((DataTheme.creatures.getRace(_base->getRace())->count() % 2) != 0){
		_layH[nbLay]->addStretch( 1 );
	}

	for( i = 1; i <= nbLay; i++) {
		lay->addLayout( _layH[i], 1 );
		lay->addSpacing( 5 );
	}

	lay->activate();

	connect( sigmap, SIGNAL( mapped( int ) ), SLOT( slot_buyUnit( int ) ) );
}
	
void DisplayCreatureBase::init( GenericPlayer * player)
{
	_player = player;
}

void DisplayCreatureBase::slot_buyUnit( int num )
{
	BuyCreature es( this );
	es.initSocket(_socket);
	es.init( _player, _base, _buy[num]->getCreature() );
	es.exec();
}


