
#include "macros.inc"

#define dest_hi r25
#define dest_lo r24
#define src_hi r23
#define src_lo r22
#define len_hi r21
#define len_lo r20

; char *strncpy_P(char *dest, const char flash *src, size_t len)

	.text
	.global	_U(strncpy_P)
	.type	_U(strncpy_P), @function
_U(strncpy_P):
	LOAD_Z(src_lo, src_hi)
	LOAD_X(dest_lo, dest_hi)
.strncpy_P_loop:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcs	.strncpy_P_done
	LPM_R0_ZP
	st	X+, r0
	tst	r0
	brne	.strncpy_P_loop
; store null characters up to the end of dest
; as the glibc manual says:
; This behavior is rarely useful, but it is specified by the ISO C standard.
	rjmp	.strncpy_P_clr_start
.strncpy_P_clr_loop:
	st	X+, __zero_reg__
.strncpy_P_clr_start:
	subi	len_lo, lo8(1)
	sbci	len_hi, hi8(1)
	brcc	.strncpy_P_clr_loop
.strncpy_P_done:
; return dest (unchanged)
	ret
.strncpy_P_end:
	.size	_U(strncpy_P), .strncpy_P_end - _U(strncpy_P)

