#----------------------------------------------------------------
# new file selection dialog
# copyright (c) 1997-1998  Takashi Iwai
#----------------------------------------------------------------

#
# filebrowser window-path current-directory filter-pattern create-flag
#
# The selected or input file name is returned.
#
proc filebrowser {w {curdir ""} {filter ""} {singlefile 0} {creatable 0}} {
    global fs

    if {$curdir == {}} {
	set fs(curdir) [pwd]
    } else {
	set savedir [pwd]
	cd $curdir
	set fs(curdir) [pwd]
	cd $savedir
    }
    set fs(filter) $filter
    set fs(singlefile) $singlefile
    set fs(found) {}

    fs:init $w
    fs:update

    set oldFocus [focus]
    tkwait visibility $w
    push-grab $w
    focus $w
    tkwait window $w
    pop-grab
    focus $oldFocus

    if {$fs(found) == {}} {
	return $fs(found)
    }

    # convert to relative path from the current directory
    set cwd [pwd]
    cd $fs(curdir)
    set newcwd [pwd]/
    cd $cwd
    if {[string match $cwd/* $newcwd]} {
	set newcwd [string range $newcwd [string length $cwd/] end]
    }
    set newlist {}
    foreach i $fs(found) {
	lappend newlist $newcwd$i
    }
    return $newlist
}

#
# create a filebrowser dialog
#
proc fs:init {w} {
    global fs
    set f [my-dialog $w "File Selector" 0 1 [list\
	    [list { OK } "fs:select $w 1"]\
	    [list "Cancel" "destroy $w"]\
	    [list "All" "fs:doall $w"]]]

    set fs(topdir) ""

    set fs(dirw) $f.curdir
    menubutton $f.curdir -relief sunken -bd 2\
	    -indicatoron 1\
	    -menu $f.curdir.m
    menu $f.curdir.m -tearoff 0

    pack $f.curdir -side top -fill x

    frame $f.list
    if {$fs(singlefile)} {
	set mode single
    } else {
	set mode extended
    }
    set fs(list) [make-listbox $f.list 25 15 0 $mode]
    #bind $fs(list) <Button-1> {%W select anchor [%W nearest %y]}
    bind $fs(list) <Double-1> [list +fs:select $w]
    pack $f.list -side top -fill x

    button $f.selectall -text "Select All"\
	    -command "fs:selectall $w"
    entry $f.filter -relief sunken -bd 2 -textvariable fs(filter)
    bind $f.filter <Return> {}
    pack $f.filter -side top -fill x
}

#
# select all files except directories
#
proc fs:doall {w} {
    global fs

    foreach i [$fs(list) get 0 end] {
	if {! [string match */ $i]} {
	    lappend fs(found) $i
	}
    }
    if {$fs(found) != {}} {
	destroy $w
    }
}

#
# select a directory or files
#
proc fs:select {w {selfile 0}} {
    global fs

    # check directory
    foreach i [$fs(list) curselection] {
	set path [$fs(list) get $i]
	if {[string match */ $path]} {
	    set path [string range $path 0 [expr [string length $path] - 2]]
	    fs:chdir $fs(curdir)/$path
	    return
	}
    }
	    
    if {$selfile} {
	foreach i [$fs(list) curselection] {
	    lappend fs(found) [$fs(list) get $i]
	}
	destroy $w
    }
}


#
# update file selection menu and list
#
proc fs:update {} {
    global fs

    set mw $fs(dirw)
    set dlist [split $fs(curdir) "/"]
    set ctop [lindex $dlist [expr [llength $dlist] - 1]]
    if {$ctop == {}} {
	set ctop "/"
    }
    $mw configure -text $ctop

    $mw.m delete 0 end
    for {set i 0} {$i < [llength $dlist]} {incr i} {
	set ctop [lindex $dlist $i]
	if {$ctop == {}} {
	    set ctop "/"
	}
	set cdir [join [lrange $dlist 0 $i] "/"]
	$mw.m add command -label $ctop -command [list fs:chdir $cdir]
    }

    set lw $fs(list)
    $lw delete 0 end
    foreach i [lsort [glob -nocomplain $fs(curdir)/*]] {
	set base [file tail $i]
	if {$i == {}} {
	    continue
	}
	if {[file isdirectory $i]} {
	    $lw insert end $base/
	} elseif {$fs(filter) == {} || [string match $fs(filter) $base]} {
	    $lw insert end $base
	}
    }
    $lw select clear 0 end
}

#
# change current directory
#
proc fs:chdir {curdir} {
    global fs
    set fs(curdir) $curdir
    fs:update
}

