/*----------------------------------------------------------------
 * glinfo.c -- default settings of midi info record
 *
 * Copyright (C) 1996-1998 Takashi Iwai
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *----------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include "config.h"

/* default settings */
MidiInfo gl_default = {
	/* midi info: format, tracks, divisions */
	0, 0, 0,
	/* variable: startcs, endcs, prevcs, curcs */
	0, 0, 0, 0,
	/* variable: updatecs, echocs, prevev, curev, tempo */
	0, 0, 0, 0, 0,
	/* midi data: nlists, list */
	0, NULL,

	/* configuration data */
	/* controls: chorus, reverb, chorusdepth, reverbdepth */
	DEF_CHORUS_MODE, DEF_REVERB_MODE, DEF_CHORUS_DEPTH, DEF_REVERB_DEPTH,
	/* controls: volume, master, bass, treble */
	DEF_VOLUME, 100, DEF_BASS, DEF_TREBLE,
	/* controls: alloff, realpan, multi, checkcs */
	DEF_ALLOFF, DEF_REALTIME_PAN, DEF_NEWVOLUME, DEF_MULTIPART, DEF_CHECKCS,
	/* controls: midi_mode, gsmacro, xgmacro, chhprior, do_tuning */
	MODE_GM, DEF_GSMACRO, DEF_XGMACRO, DEF_XGMAP, DEF_CHN_PRIOR, TRUE,
	/* controls: drumflag, tracks */
	DEF_DRUMFLAG, DEF_TRACKS,
	/* controls: volscale, skipblank */
	DEF_VOLSCALE, DEF_SKIPBLANK,
	/* controls: chn_volflag, base_offset, parse_title */
	0, 0, DEF_PARSETITLE,
	/* controls: seq_buffered, use_echoback */
	DEF_SEQ_BUFFERED, DEF_USE_ECHOBACK,
	/* controls: incremental, use_effects */
	DEF_INCREMENTAL, DEF_USEFX,
	/* effect sense: */
	{
		DEF_FX_CUTOFF, DEF_FX_RESONANCE, DEF_FX_ATTACK, DEF_FX_RELEASE,
		DEF_FX_VIBRATE, DEF_FX_VIBDEPTH, DEF_FX_VIBDELAY
	},
	/* name, dynamicload, xgload, loaded */
	NULL, NULL, NULL, FALSE,
};

void copy_midi_info(MidiInfo *dst, MidiInfo *src, char *fname)
{
	memcpy(dst, src, sizeof(MidiInfo));
	dst->filename = fname;
}

