# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::magic::highlight;
use base 'AXP::Command::magic';

use Arch::FileHighlighter;
use Arch::Util qw(save_file);

sub optusage {
	"[options] file"
}

sub infoline {
	"syntax-highlight source file using html"
}

sub options {
	(
		output => { sh => 'o', type => "=s", arg => 'FILE', desc => "write to FILE rather than stdout" },
		internal => { sh => 'i', desc => "only use internal highlighting" },
		enscript => { sh => 'e', desc => "only use enscript highlighting" },
		none     => { sh => 'n', desc => "just html-escape without highlighting" },
	)
}

sub helptext {
	q{
		Try to produce an html'd version of the file with syntax
		highlighting.  The output html uses <span class="syntax_*">
		</span> markup.  To get colored pages, add css definition.
		See 'axp man Arch::FileHighlighter' for more information.

		The enscript utility is used if installed, otherwise the
		highlighting may be pretty poor.  Multiple programming
		languages are supported, but not all.
	}
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	my $filters =
		$opt{none}? []: $opt{enscript}? [ 'enscript(asis)' ]:
		$opt{internal}? [ 'internal' ]: [ 'enscript', 'internal' ];

	my $src = shift @ARGV || die "Please specify file to syntax highlight\n";
	my $fh = Arch::FileHighlighter->new($filters);
	my $html_ref = $fh->highlight($src);

	my $file = $opt{output} || "-";
	save_file($file, $html_ref);
}

1;
