<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    axyl-users.php                                          */
/* Author:      Paul Waite                                              */
/* Date:        February 2002                                           */
/* Description: User setup page                                         */
/*              DEPRECATED in favour of the schema independent approach */
/*              using the maintainer-defs.php module. This is retained  */
/*              for non-Postgres implementations of Axyl due to the     */
/*              schema-independent parts not being written as yet.      */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("User Setup", "main", $theme);

$RESPONSE->set_onload("initialise()");
$RESPONSE->head->add_script(
   "function initialise() {\n"
 . " for (var i=0; i < document.forms[0].length; i++) {\n"
 . "   var e=document.forms[0].elements[i];\n"
 . "   if (e.type == \"text\") {\n"
 . "     e.focus();\n"
 . "     break;\n"
 . "   }\n"
 . " }\n"
 . "}\n"
);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");

//debug_on(DBG_DUMP|DBG_SQL|DBG_DIAGNOSTIC);
//debug_output(DBG_O_LOG);

// -----------------------------------------------------------------------------------------------
// AUTHORISATION
// Must have authorisation code of valid admin user by now..
$AUTH_CODE_HIDDEN = "<input type=hidden name=auth_code value='$auth_code'>";

// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group("Admin")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take

// -----------------------------------------------------------------------------------------------
// HEADING
$HEADING = "User Setup";
$recvalid = false;

// -----------------------------------------------------------------------------------------------
// MAIN CONTENT

// ###############################################################################################
// POST PROCESSING

// SAVE SETUP
if (isset($save_x)) {
  if (isset($userid)) {
    // USER DETAILS
    if ($mode == "add") {
      if ($password != "" && $password == $confirm) {
        if ($RESPONSE->encrypted_passwords) {
          $password = "axenc_" . md5($password);
        }
        $auth = md5($userid . $full_name . microtime());
        $query = new dbinsert("ax_user");
        $query->set("user_id",           $userid);
        $query->set("password",          $password);
        $query->set("full_name",         $full_name);
        $query->set("user_type",         "user");
        $query->set("email",             $email);
        $query->set("address",           $address);
        $query->set("phone",             $phone);
        $query->set("fax",               $fax);
        $query->set("mobile",            $mobile);
        $query->set("total_logins",      0);
        $query->set("limit_logins",      0);
        $query->set("enabled",           isset($enabled));
        $query->set("auth_code",         $auth);
        $query->set("org_id",            $org_id);
        $query->execute();
      }
      else {
        $errmsgs[] = "Passwords do not match. New user was not created.";
      }
      $mode = "edit";
    }
    else {
      $query = new dbupdate("ax_user");
      if ($password != "") {
        if ($password == $confirm) {
          if ($RESPONSE->encrypted_passwords) {
            $password = "axenc_" . md5($password);
          }
          $query->set("password", $password);
        }
        else {
          $errmsgs[] = "Passwords do not match!";
        }
      }
      $query->set("full_name",         $full_name);
      $query->set("email",             $email);
      $query->set("address",           $address);
      $query->set("phone",             $phone);
      $query->set("fax",               $fax);
      $query->set("mobile",            $mobile);
      $query->set("limit_logins",      $limit_logins);
      $query->set("enabled",           isset($enabled));
      $query->set("org_id",            $org_id);
      $query->where("user_id='$userid'");
      $query->execute();
    }

    // RECREATE USER GROUPS
    begin_transaction();
    $gdel = new dbdelete("ax_user_group");
    $gdel->where("user_id='" . escape_string($userid) . "'");
    $gdel->execute();
    $allgQ = dbrecordset("SELECT * FROM ax_group");
    if ($allgQ->hasdata) {
      do {
        $group_id = $allgQ->field("group_id");
        $postvarname = "group_$group_id";
        if (isset($$postvarname)) {
          $ins = new dbinsert("ax_user_group");
          $ins->set("user_id", $userid);
          $ins->set("group_id", $group_id);
          $ins->execute();
        }
      } while ($allgQ->get_next());
    }
    commit();

    // RECREATE IP ADDRESSES
    begin_transaction();
    $ipdel = new dbdelete("ax_user_ip");
    $ipdel->where("user_id='" . escape_string($userid) . "'");
    $ipdel->execute();
    if (isset($iplist) && trim($iplist) != "") {
      $iplist = str_replace(",", "", $iplist);
      $ips = explode("\n", $iplist);
      foreach($ips as $ip) {
        // Avoid duplicates..
        $ip = ip_format($ip);
        $q  = "SELECT * FROM ax_user_ip";
        $q .= " WHERE user_id='" . escape_string($userid) . "'";
        switch ($RESPONSE->datasource->dbtype()) {
          case "postgres":
            $q .= " AND ip= inet '$ip'";
            break;
          default:
            $q .= " AND ip='$ip'";
        }
        $exists = dbrecordset($q);
        if (!$exists->hasdata) {
          $ins = new dbinsert("ax_user_ip");
          $ins->set("user_id", $userid);
          $ins->set("ip", $ip);
          $ins->execute();
        }
      }
    }
    commit();
  } // isset userid
}
// DELETE USER
elseif ($mode == "remove") {
  if (isset($userid)) {
    // Delete all related records, then, finally, ax_user..
    start_transaction();
    $udel = new dbdelete("ax_wwwsession");
    $udel->where("user_id='" . escape_string($userid) . "'");
    $udel->execute();

    $udel = new dbdelete("ax_user_ip");
    $udel->where("user_id='" . escape_string($userid) . "'");
    $udel->execute();

    $udel = new dbdelete("ax_forum_member");
    $udel->where("user_id='" . escape_string($userid) . "'");
    $udel->execute();

    $udel = new dbdelete("ax_user_group");
    $udel->where("user_id='" . escape_string($userid) . "'");
    $udel->execute();

    $udel = new dbdelete("ax_user");
    $udel->where("user_id='" . escape_string($userid) . "'");
    $udel->execute();
    commit();
  }
  $mode = "edit";
  $userid = "";
}
// ADD NEW USER
elseif (isset($add_x)) {
  $mode = "add";
  $userid = "#new#";
}
// CANCEL ADD
elseif (isset($cancel_x)) {
  $mode = "edit";
}

// -----------------------------------------------------------------------------------------------
// Get current user, if any..
if (isset($userid)) {
  $curuser = new user($userid);
  if ($curuser->valid) {
    $HEADING .= " - " . stripslashes($curuser->name);
    $recvalid = true;
  }
}

// ###############################################################################################
// FORM ELEMENTS

// -----------------------------------------------------------------------------------------------
// USER SELECT MENU
$s = "";
if ($mode != "add") {
  $Sel_F = new form_combofield("userid", "Users", "$userid", EDITABLE, "width: 300px");
  $Sel_F->additem("");
  $Sel_F->set_onchange("document.forms.usersetup_fm.submit()");

  $uQ = new dbselect();
  $uQ->from("ax_user u,ax_organisation o");
  $uQ->where("o.org_id=u.org_id");
  if ($RESPONSE->user_type != 'sys') {
    $uQ->where("AND u.user_type='user'");
  }
  $uQ->orderby("u.full_name");
  $uQ->execute();

  if ($uQ->rowcount > 0) {
    do {
      $user_id = $uQ->field("user_id");
      $org_name = $uQ->field("org_name");
      $full_name = $uQ->field("full_name");
      if ($org_name != "") $full_name .= " ($org_name)";
      $Sel_F->additem($user_id, $full_name);
    } while ($uQ->get_next());
  }
  $Tsel = new table("selector");
  $Tsel->setpadding(2);
  $Tsel->tr();
  $Tsel->td("<b>Select:</b>&nbsp;" . $Sel_F->render(), "formele");
  $Tsel->td_alignment("right");
  $s = $Tsel->render();
}
$REC_SELECT = $s;

// -----------------------------------------------------------------------------------------------
// CONTROL BUTTONS
$addbtn = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new record",        57, 15 );
$canbtn = new form_imagebutton("cancel", "", "", "$LIBDIR/img/_cancel.gif", "Cancel this operation", 57, 15 );
$rembtn = new form_imagebutton("remove", "", "", "$LIBDIR/img/_remove.gif", "Remove this record",    57, 15 );
$savbtn = new form_imagebutton("save",   "", "", "$LIBDIR/img/_save.gif",   "Save changes",          57, 15 );
$rembtn->set_onclick("delWarn()");
$Tbtns = new table("buttons");
$Tbtns->setpadding(2);
$Tbtns->tr();
$Tbtns->td();
if ($recvalid) {
  $Tbtns->td_content( "&nbsp;" . $savbtn->render() );
}
if ($mode != "add") {
  $Tbtns->td_content( "&nbsp;" . $addbtn->render() );
  if ($recvalid) {
    $Tbtns->td_content( "&nbsp;" . $rembtn->render() );
  }
}
else {
  $Tbtns->td_content( "&nbsp;" . $canbtn->render() );
}
$Tbtns->td_content("&nbsp;");
$Tbtns->td_alignment("right", "bottom");
$CONTROL_BUTTONS = $Tbtns->render();

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this user?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.usersetup_fm.mode.value='remove';\n"
  . "   document.forms.usersetup_fm.submit();\n"
  . " }\n"
  . " else alert(\"User survives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------------------------------
// USER DETAILS

$s = "";
if ($recvalid) {
  $s .= "<table border=0 cellpadding=2 cellspacing=0 width=100%\n";
  $s .= "<tr><td class=sep_heavy><h3>User details</h3></td></tr>\n";

  // FIELD - User ID
  if ($mode == "add") {
    $uid_F = new form_textfield("userid", "User ID", $curuser->userid);
    $uid_F->setstyle("width: 150px");
  }
  else {
    $uid_F = new form_labelfield("User ID", $curuser->userid);
  }

  // FIELD - Displayonly current password
  // Axyl-encrypted passwords always have 'axenc_' prefix..
  if ($RESPONSE->encrypted_passwords) {
    if (substr($curuser->password, 0, 6) == "axenc_") {
      $displaypass = "(encrypted)";
    }
    else {
      $displaypass = "(plain text - please change)";
    }
  }
  else {
    $displaypass = $curuser->password;
  }
  $pwdNow_F = new form_labelfield("Password", $displaypass);

  // FIELD - Password and confirm
  $passwd_F = new form_passwordfield("password", "Change Password");
  $passwd_F->setstyle("width: 150px");
  $passcf_F = new form_passwordfield("confirm", "Confirm password");
  $passcf_F->setstyle("width: 150px");

  // FIELD - Organisation
  $org_F = new form_combofield("org_id", "Organisation", $curuser->user_record["org_id"], EDITABLE, "width: 250px");
  $oQ = dbrecordset("SELECT * FROM ax_organisation ORDER BY org_name");
  if ($oQ->rowcount > 0) {
    do {
      $orgid = $oQ->field("org_id");
      $orgname = $oQ->field("org_name");
      $org_F->additem($orgid, $orgname);
    } while ($oQ->get_next());
  }

  // FIELD - Full name
  $name_F = new form_textfield("full_name", "Name", stripslashes($curuser->name));
  $name_F->setstyle("width: 300px");

  // FIELD - Address
  $addr_F = new form_textfield("address", "Address", stripslashes($curuser->user_record["address"]));
  $addr_F->setstyle("width: 300px");

  // FIELD - E-mail
  $email_F = new form_textfield("email", "e-mail", $curuser->user_record["email"]);
  $email_F->setstyle("width: 200px");

  // FIELD - Phone
  $phone_F = new form_textfield("phone", "Phone", $curuser->user_record["phone"]);
  $phone_F->setstyle("width: 150px");

  // FIELD - Fax
  $fax_F = new form_textfield("fax", "Fax", $curuser->user_record["fax"]);
  $fax_F->setstyle("width: 150px");

  // FIELD - Mobile
  $mobile_F = new form_textfield("mobile", "Mobile", $curuser->user_record["mobile"]);
  $mobile_F->setstyle("width: 150px");

  // FIELD - Last login
  $last_login = datetime_to_displaydate(NICE_DATETIME, $curuser->user_record["last_login"]);
  $login_F = new form_textfield("last_login", "Last Login", $last_login);
  $login_F->editable = false;

  // FIELD - Total logins
  $total_logins = $curuser->user_record["total_logins"];
  $totlog_F = new form_textfield("total_logins", "Total logins", $total_logins);
  $totlog_F->setstyle("width: 30px");
  $totlog_F->editable = false;

  // FIELD - Login limit
  $limit_logins = $curuser->user_record["limit_logins"];
  $limit_logins_F = new form_textfield("limit_logins", "Logins limit", $limit_logins);
  $limit_logins_F->setstyle("width: 30px");

  // FIELD - Enabled flag
  $enb_F = new form_checkbox("enabled", "Enabled");
  $enb_F->checked = $RESPONSE->datasource->bool_from_db_value($curuser->user_record["enabled"]);

  // FORM..
  $uform = new subform();
  $uform->add($uid_F);
  $uform->add($pwdNow_F);
  $uform->add($passwd_F);
  $uform->add($passcf_F);
  $uform->add($org_F);
  $uform->add($name_F);
  $uform->add($addr_F);
  $uform->add($email_F);
  $uform->add($phone_F);
  $uform->add($fax_F);
  $uform->add($mobile_F);
  $uform->add($login_F);
  $uform->add($totlog_F);
  $uform->add($limit_logins_F);
  $uform->add($enb_F);

  $s .= "<tr><td align=center valign=top>" . $uform->render() . "</td></tr>\n";
  $s .= "</table>\n";
}
$REC_DETAILS = $s;

// -----------------------------------------------------------------------------------------------
// USER GROUPS

// Checkboxes used generically below..
$ugchk = new form_checkbox("",  "", $value="yes");

$s  = "";
if ($recvalid) {
  $usrgps = array();
  $usrgQ = dbrecordset("SELECT * FROM ax_user_group WHERE user_id='$curuser->userid'");
  if ($usrgQ->hasdata) {
    do {
      $group_id = $usrgQ->field("group_id");
      $usrgps[] = $group_id;
    } while ($usrgQ->get_next());
  }

  if (!isset($allgQ)) $allgQ = dbrecordset("SELECT * FROM ax_group");
  else $allgQ->get_first();

  if ($allgQ->hasdata) {
    $cols = 5; // Number of checkbox cell-pairs
    $pct = number_format(floor(100/($cols * 2)), 0); // %width of each cell
    $Tmem = new table("GroupMembership");
    $Tmem->setpadding(3);
    $Tmem->setwidth("100%");
    $Tmem->tr();
    $Tmem->td("<h3>Group membership</h3>");
    $Tmem->td_colspan($cols * 2);
    $col = 0;
    do {
      // Start row if at first column..
      if ($col == 0 || ($col % $cols) == 0) $Tmem->tr();

      // Render group checkbox in a pair of cells..
      $group_id = $allgQ->field("group_id");
      $group_desc = $allgQ->field("group_desc");
      $Tmem->td($group_desc);
      $Tmem->td_width("$pct%");
      $Tmem->td_alignment("right");

      $ugchk->checked = in_array($group_id, $usrgps);
      $Tmem->td($ugchk->render("group_$group_id"));
      $Tmem->td_width("$pct%");

      // End row if at last column..
      $col += 1;
    } while ($allgQ->get_next());

    // Tidy up..
    if ($col > 0) {
      if ($col < $cols) {
        $Tmem->td("&nbsp;");
        $Tmem->td_colspan( 2 * ($cols - $col) );
        $Tmem->td_width( ((2 * ($cols - $col)) * $pct) . "%" );
      }
    }
  }
  $Tgp = new table("Groups");
  $Tgp->setpadding(2);
  $Tgp->setwidth("100%");
  $Tgp->tr();
  $Tgp->td( $Tmem->render() );
  $s = $Tgp->render();
}
$REC_GROUPS = $s;

// -----------------------------------------------------------------------------------------------
// IP ADDRESSES SETUP
if ($recvalid) {
  $s  = "<table border=0 cellpadding=2 cellspacing=0 width=100%>";
  $s .= "<tr><td>";

  $ipQ = dbrecordset("SELECT * FROM ax_user_ip WHERE user_id='" . escape_string($userid) . "'");
  $ips = array();
  if ($ipQ->hasdata) {
    do {
      $ips[] = $ipQ->field("ip");
    } while ($ipQ->get_next());
  }
  $iplist = implode("\n", $ips);
  $iplist_F = new form_memofield(
                 "iplist",
                 "IP Addresses",
                 $iplist,
                 EDITABLE,
                 "width:250px",
                 STD_WIDTH, 7,
                 "physical"
                 );
  $s .= "<table border=0 cellpadding=2 cellspacing=0 width=100%>\n";
  $s .= "<tr><td class=sep_heavy><h3>IP Addresses for Automatic Login</h3></td></tr>\n";
  $s .= "<tr><td align=center>";
  $s .= "<table border=0 cellpadding=4 cellspacing=0>\n";
  $s .= "<tr><td valign=top width=\"40%\">";
  $s .= "<p class=smnote>Enter IP addresses for either single hosts or networks. ";
  $s .= "with each address on a separate line.</p>";
  $s .= "<p class=smnote>A host is a full address like this: 204.13.223.3. A Class C ";
  $s .= "network of machines can be entered short-hand like this: 204.13.223 or like ";
  $s .= "this: 204.13.223.0, or properly, like this: 204.13.223.0/24. When you save ";
  $s .= "the list, the system will re-format your entries</p>";
  $s .= "</td>";

  $s .= "<td valign=top width=\"60%\">";
  $s .= $iplist_F->render();
  $s .= "</td></tr>";
  $s .= "</table>\n";

  $s .= "</td></tr>";
  $s .= "</table>\n";
  $s .= "</td</tr>";
  $s .= "</table>\n";
  $IP_ADDRESSES = $s;
}

// -----------------------------------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------------------------------
// mode field
$act = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $act->render();

// ###############################################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form name=usersetup_fm method="post">
  <!--AUTH_CODE_HIDDEN-->
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width=100%>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td colspan=2><!--CONTROL_BUTTONS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td colspan=2 valign=top width=70%><!--REC_SELECT--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--REC_DETAILS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td valign=top colspan=2><!--REC_GROUPS--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--IP_ADDRESSES--></td>
    </tr>
    <tr class="axfoot">
      <td colspan=2></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// ###############################################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("AUTH_CODE_HIDDEN",  $AUTH_CODE_HIDDEN);
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("REC_SELECT",        $REC_SELECT);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);
$RESPONSE->plugin("REC_DETAILS",       $REC_DETAILS);
$RESPONSE->plugin("REC_GROUPS",        $REC_GROUPS);
$RESPONSE->plugin("IP_ADDRESSES",      $IP_ADDRESSES);

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>