<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/*                                                                      */
/* Filename:    axyl-meta-elements.php                                  */
/* Author:      Paul Waite                                              */
/* Date:        September 2004                                          */
/* Description: Meta Elements setup page                                */
/*              DEPRECATED in favour of the schema independent approach */
/*              using the maintainer-defs.php module. This is retained  */
/*              for non-Postgres implementations of Axyl due to the     */
/*              schema-independent parts not being written as yet.      */
/*                                                                      */
/************************************************************************/
include_once("application.php");

// -----------------------------------------------------------------------
// You can customise these values, and most of the work of changing to
// maintain another single-key table is done. You still have to go
// and define the individual field retreival/save/widgets though!

// Heading for the maintainer..
$HEADING = "METADATA ELEMENTS";

// Name of the table being maintained..
$maint_tablename = "ax_meta_element";

// Name of the key field for this record..
$record_keyfield = "element_id";

// Name of field to display in dropdown menu..
$record_displayfield = "label";

// Width style for the selector dropdown..
$selector_width = "width:250px";

// Short form widget width - eg. for dates, abrrevs etc.
$smallpx = "width:100px";
// General textbox widget width
$normpx = "width:250px";
// Wide widget width - eg. memo fields, drop-downs
$widepx = "width:350px";

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page($HEADING, "main", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("form-defs.php");
include_once("button-defs.php");

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin")) {
  $RESPONSE->send();
  exit;
}

// -----------------------------------------------------------------------
// INITIALISE VARS
if (!isset($mode)) $mode = "edit";  // Determines the action(s) we take
$recvalid = false;
if (isset($$record_keyfield)) {
  $record_keyvalue = $$record_keyfield;
}
// -----------------------------------------------------------------------
// MAIN CONTENT

//debug_on(DBG_SQL|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);


// #######################################################################
// POST PROCESSING

// SAVE SETUP
if (isset($save_x)) {
  if (isset($record_keyvalue)) {
    if ($mode == "add") {
      $query = new dbinsert($maint_tablename);
      $query->set($record_keyfield, $record_keyvalue);
    }
    else {
      $query = new dbupdate("$maint_tablename");
      $query->where("$record_keyfield='$record_keyvalue'");
    }
    $query->set("label",          $label);
    $query->set("tag_name",       $tag_name);
    $query->set("definition",     $definition);
    $query->set("parent_element", $parent_element);
    $query->set("parent_schema",  $parent_schema);
    $query->set("enabled",        isset($enabled));
    $query->execute();
    $mode = "edit";
  }
}
// DELETE PACKAGE
elseif ($mode == "remove") {
  if (isset($record_keyvalue)) {
    dbcommand("DELETE FROM $maint_tablename WHERE $record_keyfield=$record_keyvalue");
  }
  $record_keyvalue = 0;
  $recvalid = false;
  $mode = "edit";
}
// ADD NEW PACKAGE
elseif (isset($add_x)) {
  $record_keyvalue = get_next_sequencevalue("seq_$record_keyfield", "$maint_tablename", "$record_keyfield");
  $label = "";
  $tag_name = "";
  $definition = "";
  $parent_element = NULLVALUE;
  $parent_schema = "Dublin Core";
  $enabled = true;
  $HEADING .= " - New";
  $recvalid = true;
  $mode = "add";
}
// CANCEL ADD
elseif (isset($cancel_x)) {
  $mode = "edit";
}

// -----------------------------------------------------------------------
// Get current package, if any..
if ($mode != "add" && isset($record_keyvalue)) {
  $recordQ = dbrecordset("SELECT * FROM $maint_tablename WHERE $record_keyfield=$record_keyvalue");
  if ($recordQ->hasdata) {
    // Populate all table field values here..
    $label          = $recordQ->field("label");
    $tag_name       = $recordQ->field("tag_name");
    $definition     = $recordQ->field("definition");
    $parent_element = $recordQ->field("parent_element");
    $parent_schema  = $recordQ->field("parent_schema");
    $enabled        = $recordQ->istrue("enabled");
    $HEADING .= " - $label";
    $recvalid = true;
  }
}

// #######################################################################
// FORM ELEMENTS

// -----------------------------------------------------------------------
// CONTROL BUTTONS
$addbtn = new form_imagebutton("add",    "", "", "$LIBDIR/img/_add.gif",    "Add new record",        57, 15 );
$canbtn = new form_imagebutton("cancel", "", "", "$LIBDIR/img/_cancel.gif", "Cancel this operation", 57, 15 );
$rembtn = new form_imagebutton("remove", "", "", "$LIBDIR/img/_remove.gif", "Remove this record",    57, 15 );
$savbtn = new form_imagebutton("save",   "", "", "$LIBDIR/img/_save.gif",   "Save changes",          57, 15 );
$rembtn->set_onclick("delWarn()");
$Tbtns = new table("buttons");
$Tbtns->setpadding(2);
$Tbtns->tr();
$Tbtns->td();
if ($recvalid) {
  $Tbtns->td_content( "&nbsp;" . $savbtn->render() );
}
if ($mode != "add") {
  $Tbtns->td_content( "&nbsp;" . $addbtn->render() );
  if ($recvalid) {
    $Tbtns->td_content( "&nbsp;" . $rembtn->render() );
  }
}
else {
  $Tbtns->td_content( "&nbsp;" . $canbtn->render() );
}
$Tbtns->td_content("&nbsp;");
$Tbtns->td_alignment("right", "bottom");
$CONTROL_BUTTONS = $Tbtns->render();

// Put in some javascript to prevent accidental deletes..
$RESPONSE->body->add_script(
    "function delWarn() {\n"
  . " var msg = \"WARNING:\\n\\n\";\n"
  . " msg+=\"Do you really want to delete this item?\\n\\n\";\n"
  . " var rc = confirm(msg);\n"
  . " if (rc) {\n"
  . "   document.forms.main_fm.mode.value='remove';\n"
  . "   document.forms.main_fm.submit();\n"
  . " }\n"
  . " else alert(\"Item survives to fight another day.\");\n"
  . "}\n"
);

// -----------------------------------------------------------------------
// SELECT MENU
$s = "";
if ($mode != "add") {
  $Sel_F = new form_combofield($record_keyfield, $HEADING, $record_keyvalue, EDITABLE, $selector_width);
  $Sel_F->additem("");
  $Sel_F->set_onchange("document.forms.main_fm.submit()");
  $oQ = dbrecordset("SELECT * FROM $maint_tablename ORDER BY $record_displayfield");
  if ($oQ->rowcount > 0) {
    do {
      $keyvalue = $oQ->field($record_keyfield);
      $keylabel = $oQ->field($record_displayfield);
      $Sel_F->additem($keyvalue, $keylabel);
    } while ($oQ->get_next());
  }
  $Tsel = new table("selector");
  $Tsel->setpadding(2);
  $Tsel->tr();
  $Tsel->td("<b>$HEADING:</b>&nbsp;" . $Sel_F->render(), "formele");
  $Tsel->td_alignment("right");
  $s = $Tsel->render();
}
$REC_SELECT = $s;

// -----------------------------------------------------------------------
// DETAILS
$s = "";
if ($recvalid) {
  $Tdetail = new table("details");
  $Tdetail->setpadding(2);
  $Tdetail->tr();
  $Tdetail->td("<h3>Details</h3>" );

  // FIELD - ID
  if ($mode == "add") {
    $oid_F = new form_hiddenfield($record_keyfield, $record_keyvalue);
  }
  else {
    $oid_F = new form_labelfield("Element ID", $record_keyvalue);
  }
  // FIELD - Label
  $lab_F = new form_textfield("label", "Label", $label);
  $lab_F->setclass("axtxtbox");
  $lab_F->setstyle($normpx);

  // FIELD - Tag name
  $tag_F = new form_textfield("tag_name", "Tag name", $tag_name);
  $tag_F->setclass("axtxtbox");
  $tag_F->setstyle($normpx);

  // FIELD - Definition
  $defn_F = new form_memofield("definition", "Definition", $definition);
  $defn_F->setclass("axmemo");
  $defn_F->setstyle("$widepx;height:100px");

  // FIELD - Parent element
  $pare_F = new form_combofield("parent_element", "Parent element", $parent_element, EDITABLE, $widepx);
  $pare_F->additem(NULLVALUE, "");
  $oQ = dbrecordset("SELECT * FROM $maint_tablename ORDER BY label");
  $oQ->get_first();
  if ($oQ->rowcount > 0) {
    do {
      $elemid = $oQ->field($record_keyfield);
      $lab = $oQ->field("label");
      $pare_F->additem($elemid, $lab);
    } while ($oQ->get_next());
  }

  // FIELD - Parent schema
  $pars_F = new form_combofield("parent_schema", "Parent schema", $parent_schema, EDITABLE, $widepx);
  $schQ = dbrecordset("SELECT * FROM ax_meta_schema ORDER BY schema_name");
  if ($schQ->rowcount > 0) {
    do {
      $schname = $schQ->field("schema_name");
      $desc = $schQ->field("description");
      $pars_F->additem($schname, $desc);
    } while ($schQ->get_next());
  }

  // FIELD - Enabled
  $enb_F = new form_checkbox("enabled", "Enabled");
  $enb_F->setclass("axchkbox");
  $enb_F->checked = $enabled;


  // FORM..
  $oform = new subform();
  $oform->add($oid_F);
  $oform->add($lab_F);
  $oform->add($tag_F);
  $oform->add($defn_F);
  $oform->add($pare_F);
  $oform->add($pars_F);
  $oform->add($enb_F);

  $Tdetail->tr();
  $Tdetail->td( $oform->render() );
  $Tdetail->td_alignment("center", "top");
  $s = $Tdetail->render();
}
$REC_DETAILS = $s;

// -----------------------------------------------------------------------
// ERROR MESSAGES
// Messages added to the errmsgs[] array above..
$s = "";
if (isset($errmsgs)) {
  foreach ($errmsgs as $errmsg) {
    $s .= "$errmsg<br>";
  }
}
$ERROR_MSG = $s;

// -----------------------------------------------------------------------
// mode field
$mod = new form_hiddenfield("mode", "$mode");
$MODE_HIDDEN = $mod->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<form name=main_fm method="post">
  <!--MODE_HIDDEN-->
  <table border=0 cellspacing=3 cellpadding=0 width=100%>
    <tr class="axtitle">
      <td colspan=2 align="center" class="axtitle"><!--HEADING--></td>
    </tr>
    <tr>
      <td align=center colspan=2 class=axerror><!--ERROR_MSG--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td colspan=2><!--CONTROL_BUTTONS--></td>
    </tr>
    <tr class="axyl_rowstripe_lite">
      <td colspan=2 valign=top width=70%><!--REC_SELECT--></td>
    </tr>
    <tr class="axyl_rowstripe_dark">
      <td valign=top colspan=2><!--REC_DETAILS--></td>
    </tr>
    <tr class="axfoot">
      <td colspan=2></td>
    </tr>
  </table>
</form>
<?php
$RESPONSE->plugin_inline();

// #######################################################################
// OUTPUT..
// These go last of all, since they are content
// replacements within replacements..
$RESPONSE->plugin("MODE_HIDDEN",       $MODE_HIDDEN);
$RESPONSE->plugin("HEADING",           $HEADING);
$RESPONSE->plugin("ERROR_MSG",         $ERROR_MSG);
$RESPONSE->plugin("REC_SELECT",        $REC_SELECT);
$RESPONSE->plugin("CONTROL_BUTTONS",   $CONTROL_BUTTONS);
$RESPONSE->plugin("REC_DETAILS",       $REC_DETAILS);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>