/*
 * File:          vector_Utils_Impl.c
 * Symbol:        vector.Utils-v1.0
 * Symbol Type:   class
 * Babel Version: 1.2.0
 * Description:   Server-side implementation for vector.Utils
 * 
 * WARNING: Automatically generated; only changes within splicers preserved
 * 
 */

/*
 * DEVELOPERS ARE EXPECTED TO PROVIDE IMPLEMENTATIONS
 * FOR THE FOLLOWING METHODS BETWEEN SPLICER PAIRS.
 */

/*
 * Symbol "vector.Utils" (version 1.0)
 */

#include "vector_Utils_Impl.h"
#include "sidl_NotImplementedException.h"
#include "sidl_Exception.h"
#ifndef included_sidl_MemAllocException_h
#include "sidl_MemAllocException.h"
#endif

#line 29 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
/* DO-NOT-DELETE splicer.begin(vector.Utils._includes) */
/************************** Includes **************************/
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include "sidlArray.h"
#include "sidl_Exception.h"
#include "vector_Exception.h"
#include "vector_DivideByZeroException.h"
#include "vector_NegativeValueException.h"

/* DO-NOT-DELETE splicer.end(vector.Utils._includes) */
#line 42 "../regression/assertions/libC/vector_Utils_Impl.c"

#define SIDL_IOR_MAJOR_VERSION 2
#define SIDL_IOR_MINOR_VERSION 0
/*
 * Static class initializer called exactly once before any user-defined method is dispatched
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils__load"

#ifdef __cplusplus
extern "C"
#endif
void
impl_vector_Utils__load(
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 63 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils._load) */
    /* Nothing to do here */
    /* DO-NOT-DELETE splicer.end(vector.Utils._load) */
#line 66 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}
/*
 * Class constructor called when the class is created.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils__ctor"

#ifdef __cplusplus
extern "C"
#endif
void
impl_vector_Utils__ctor(
  /* in */ vector_Utils self,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 87 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils._ctor) */
    /* Nothing to do here */
    /* DO-NOT-DELETE splicer.end(vector.Utils._ctor) */
#line 90 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Special Class constructor called when the user wants to wrap his own private data.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils__ctor2"

#ifdef __cplusplus
extern "C"
#endif
void
impl_vector_Utils__ctor2(
  /* in */ vector_Utils self,
  /* in */ void* private_data,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 113 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils._ctor2) */
    /* Nothing to do here */
    /* DO-NOT-DELETE splicer.end(vector.Utils._ctor2) */
#line 116 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}
/*
 * Class destructor called when the class is deleted.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils__dtor"

#ifdef __cplusplus
extern "C"
#endif
void
impl_vector_Utils__dtor(
  /* in */ vector_Utils self,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 137 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils._dtor) */
    /* Nothing to do here */
    /* DO-NOT-DELETE splicer.end(vector.Utils._dtor) */
#line 140 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Static Method to handle assertion violations.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils__check_error_static"

#ifdef __cplusplus
extern "C"
#endif
void
impl_vector_Utils__check_error_static(
  /* in */ const char* msg,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 162 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils._check_error_static) */
    /* DO-NOT-DELETE splicer.end(vector.Utils._check_error_static) */
#line 164 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Method to handle assertion violations.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils__check_error"

#ifdef __cplusplus
extern "C"
#endif
void
impl_vector_Utils__check_error(
  /* in */ vector_Utils self,
  /* in */ const char* msg,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 187 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils._check_error) */
    /* DO-NOT-DELETE splicer.end(vector.Utils._check_error) */
#line 189 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * boolean result operations 
 * Return TRUE if the specified vector is the zero vector, within the
 * given tolerance level; otherwise, return FALSE.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_isZero"

#ifdef __cplusplus
extern "C"
#endif
sidl_bool
impl_vector_Utils_isZero(
  /* in array<double> */ struct sidl_double__array* u,
  /* in */ double tol,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 214 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.isZero) */
    sidl_bool is = TRUE;
    int       i, maxI;
    double    absDiff;
  
    if (u != NULL) 
    {
      maxI = sidl_double__array_upper(u, 0);
      for (i=sidl_double__array_lower(u, 0); (i <= maxI) && is; i++) 
      {
        absDiff = fabs(sidl_double__array_get1(u, i));
        if ( absDiff > tol ) {
           is = FALSE;
        } 
      }
    } else {
      is = FALSE;
    }

    return is;
    /* DO-NOT-DELETE splicer.end(vector.Utils.isZero) */
#line 235 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return TRUE if the specified vector is the unit vector, within the
 * given tolerance level; otherwise, return FALSE.
 * 
 * Note that the PostViolation can arise since the implementation
 * invokes norm through the stub.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_isUnit"

#ifdef __cplusplus
extern "C"
#endif
sidl_bool
impl_vector_Utils_isUnit(
  /* in array<double> */ struct sidl_double__array* u,
  /* in */ double tol,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 262 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.isUnit) */
    sidl_bool is   = FALSE;

    double absDiff = fabs(impl_vector_Utils_norm(u, tol, 0, _ex) 
                          - 1.0); SIDL_CHECK(*_ex);
    if ( absDiff <= tol ) {
      is = TRUE;
    } else {
      is = FALSE;
    }
  
    EXIT:;
    return is;
    /* DO-NOT-DELETE splicer.end(vector.Utils.isUnit) */
#line 276 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return TRUE if the specified vectors are equal, within the given
 * tolerance level; otherwise, return FALSE.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_areEqual"

#ifdef __cplusplus
extern "C"
#endif
sidl_bool
impl_vector_Utils_areEqual(
  /* in array<double> */ struct sidl_double__array* u,
  /* in array<double> */ struct sidl_double__array* v,
  /* in */ double tol,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 301 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.areEqual) */
    sidl_bool are = FALSE;
    int       i, sizeU, sizeV;
    double    absDiff;
  
    if ( (u != NULL) && (v != NULL) ) 
    {
      sizeU = sidlLength(u, 0);
      sizeV = sidlLength(v, 0);
      if (  (sizeU == sizeV)
         && (sidlArrayDim(u) == 1) 
         && (sidlArrayDim(v) == 1) ) 
      {
        are = TRUE;
        for (i=0; (i < sizeU) && are; i++) 
        {
          absDiff = fabs(sidl_double__array_get1(u, i) 
                    - sidl_double__array_get1(v, i));
          if ( absDiff > tol ) {
            are = FALSE;
          } 
        } 
      }
    }
  
    return are;
    /* DO-NOT-DELETE splicer.end(vector.Utils.areEqual) */
#line 328 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return TRUE if the specified vectors are orthogonal, within the given
 * tolerance; otherwise, return FALSE.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_areOrthogonal"

#ifdef __cplusplus
extern "C"
#endif
sidl_bool
impl_vector_Utils_areOrthogonal(
  /* in array<double> */ struct sidl_double__array* u,
  /* in array<double> */ struct sidl_double__array* v,
  /* in */ double tol,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 353 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.areOrthogonal) */
    sidl_bool are    = FALSE;
    double    absVal;
  
    if ( (u != NULL) && (v != NULL) ) 
    {
      absVal = fabs(impl_vector_Utils_dot(u, v, tol, 0, _ex)); SIDL_CHECK(*_ex);
      if ( absVal <= tol ) {
        are = TRUE;
      } else {
        are = FALSE;
      }
    }
  
    EXIT:;
    return are;
    /* DO-NOT-DELETE splicer.end(vector.Utils.areOrthogonal) */
#line 370 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return TRUE if the Schwarz (or Cauchy-Schwarz) inequality holds, within
 * the given tolerance; otherwise, return FALSE.
 * 
 * Note that the PostViolation can arise since the implementation
 * invokes norm through the stub.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_schwarzHolds"

#ifdef __cplusplus
extern "C"
#endif
sidl_bool
impl_vector_Utils_schwarzHolds(
  /* in array<double> */ struct sidl_double__array* u,
  /* in array<double> */ struct sidl_double__array* v,
  /* in */ double tol,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 398 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.schwarzHolds) */
    sidl_bool holds    = FALSE;
    double    absDot, absNorms;
  
    if ( (u != NULL) && (v != NULL) ) 
    {
      absDot = fabs(impl_vector_Utils_dot(u, v, tol, 0, _ex)); SIDL_CHECK(*_ex);
      absNorms = fabs(impl_vector_Utils_norm(u, tol, 0, _ex) 
                 * impl_vector_Utils_norm(v, tol, 0, _ex)); SIDL_CHECK(*_ex);
      if ( absDot <= (absNorms + tol) ) {
        holds = TRUE;
      } else {
        holds = FALSE;
      }
    }
  
    EXIT:;
    return holds;
    /* DO-NOT-DELETE splicer.end(vector.Utils.schwarzHolds) */
#line 417 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return TRUE if the Minkowski (or triangle) inequality holds, within the
 * given tolerance; otherwise, return FALSE.
 * 
 * Note that the PostViolation can arise since the implementation
 * invokes norm through the stub.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_triangleInequalityHolds"

#ifdef __cplusplus
extern "C"
#endif
sidl_bool
impl_vector_Utils_triangleInequalityHolds(
  /* in array<double> */ struct sidl_double__array* u,
  /* in array<double> */ struct sidl_double__array* v,
  /* in */ double tol,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 445 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.triangleInequalityHolds) */
    sidl_bool                  holds = FALSE;
    struct sidl_double__array* sum   = NULL;
    double absNormSum, normU, normV, absSumNorms;

    if ( (u != NULL) && (v != NULL) ) 
    {
      if (  (sidlArrayDim(u) == 1) && (sidlArrayDim(v) == 1) ) 
      {
        sum = impl_vector_Utils_sum(u,v,0,_ex); SIDL_CHECK(*_ex);
        absNormSum = fabs(impl_vector_Utils_norm(sum, tol, 0, 
                          _ex)); SIDL_CHECK(*_ex);
        normU = impl_vector_Utils_norm(u, tol, 0, _ex); SIDL_CHECK(*_ex);
        normV = impl_vector_Utils_norm(v, tol, 0, _ex); SIDL_CHECK(*_ex);
        absSumNorms = fabs(normU + normV);
        if ( absNormSum <= absSumNorms ) {
          holds = TRUE;
        } else {
          holds = FALSE;
        }
      }
    }
  
    EXIT:;
    if (sum != NULL) sidl_double__array_deleteRef(sum);
    return holds;
    /* DO-NOT-DELETE splicer.end(vector.Utils.triangleInequalityHolds) */
#line 472 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * double result operations 
 * Return the norm (or length) of the specified vector.
 * 
 * Note that the size exception is given here simply because the 
 * implementation is leveraging the dot method.  Also the tolerance
 * is included to enable the caller to specify the tolerance
 * used in assertion checking.
 * 
 * Also note that badLevel has been added only to facilitate regression
 * testing of postconditions.  The levels are:
 * 0 = NONE  (i.e., no deliberate postcondition violation)
 * 1 = Return a negative result (regardless of input)
 * 2 = Return a positive result not near zero (regardless of input), 
 * which means a violation will occur only if u is the zero
 * vector
 * 3 = Return a zero result (regardless of input), which means a
 * violation will occur only if u is not the zero vector.
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_norm"

#ifdef __cplusplus
extern "C"
#endif
double
impl_vector_Utils_norm(
  /* in array<double> */ struct sidl_double__array* u,
  /* in */ double tol,
  /* in */ int32_t badLevel,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 512 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.norm) */
    double dot;
    double res = 0.0;
    char*  msg = 
    "NegativeValue_Exception: Cannot take the square root of a negative value";
  
    if (u != NULL) 
    {
      if (badLevel == 0) 
      {
        dot = impl_vector_Utils_dot(u, u, tol, 0, _ex); SIDL_CHECK(*_ex);
        if (dot > 0.0) {
          res = (double) sqrt(dot);
        } else if (dot < 0.0) {
          /* Note that this should NEVER happen! */
          res = -5.0;
          SIDL_THROW(*_ex, vector_NegativeValueException, msg);
        }
      } else if (badLevel == 1) {
        res = -5.0;
      } else if (badLevel == 2) {
        res = 5.0;
      } else if (badLevel == 3) {
        res = 0.0;
      } else {
        res = -5.0;
      }
    }
  
    EXIT:;
    return res;
    /* DO-NOT-DELETE splicer.end(vector.Utils.norm) */
#line 544 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return the dot (, inner, or scalar) product of the specified vectors.
 * 
 * Note that badLevel has been added only to facilitate regression
 * testing of postconditions.  The levels are:
 * 0 = NONE  (i.e., no deliberate postcondition violation)
 * 1 = Return a negative result (regardless of input)
 * 2 = Return a positive result not near zero (regardless of input), 
 * which means a violation will occur only if u and v are the zero
 * vector
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_dot"

#ifdef __cplusplus
extern "C"
#endif
double
impl_vector_Utils_dot(
  /* in array<double> */ struct sidl_double__array* u,
  /* in array<double> */ struct sidl_double__array* v,
  /* in */ double tol,
  /* in */ int32_t badLevel,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 577 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.dot) */
    double dot = 0.0;
    int    i, sizeU, sizeV;
  
    if ( (u != NULL) && (v != NULL) ) 
    {
      if (badLevel == 0) {
        sizeU = sidlLength(u, 0);
        sizeV = sidlLength(v, 0);
        if (  (sizeU == sizeV)
           && (sidlArrayDim(u) == 1) 
           && (sidlArrayDim(v) == 1) ) 
        {
          for (i=0; i < sizeU; ++i) {
            dot += (sidlArrayElem1(u, i) * sidlArrayElem1(v, i));
          }
        }
      } else if (badLevel == 1) {
        dot = -5.0;
      } else if (badLevel == 2) {
        dot = 5.0;
      } else {
        dot = -1.0;
      }
    }

    return dot;
    /* DO-NOT-DELETE splicer.end(vector.Utils.dot) */
#line 605 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * vector result operations 
 * Return the (scalar) product of the specified vector.
 * 
 * Note that badLevel has been added only to facilitate regression
 * testing of postconditions.  The levels are:
 * 0 = NONE  (i.e., no deliberate postcondition violation)
 * 1 = Return a null result (regardless of input)
 * 2 = Return a 2D array result (regardless of input)
 * 3 = Return an array of different size (regardless of input)
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_product"

#ifdef __cplusplus
extern "C"
#endif
struct sidl_double__array*
impl_vector_Utils_product(
  /* in */ double a,
  /* in array<double> */ struct sidl_double__array* u,
  /* in */ int32_t badLevel,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 637 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.product) */
    struct sidl_double__array* prod = NULL;
    int    i, sizeU;
  
    if (u != NULL) {
      sizeU = sidlLength(u, 0);
      if (badLevel == 0) {
        prod = sidl_double__array_create1d(sizeU);
        memset(sidl_double__array_first(prod), 0, 
               (size_t)(sizeU * sizeof(double)));
        for (i=0; i < sizeU; i++) {
          sidl_double__array_set1(prod, i, a * sidl_double__array_get1(u,i));
        }
      } else if (badLevel == 1) {
        prod = NULL;
      } else if (badLevel == 2) {
        prod = sidl_double__array_create2dCol(sizeU, sizeU);
      } else if (badLevel == 3) {
        prod = sidl_double__array_create1d(sizeU+5);
      } else {
        prod = NULL;
      }
    }

    return prod;
    /* DO-NOT-DELETE splicer.end(vector.Utils.product) */
#line 663 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return the negation of the specified vector.
 * 
 * Note that badLevel has been added only to facilitate regression
 * testing of postconditions.  The levels are:
 * 0 = NONE  (i.e., no deliberate postcondition violation)
 * 1 = Return a null result (regardless of input)
 * 2 = Return a 2D array result (regardless of input)
 * 3 = Return an array of different size (regardless of input)
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_negate"

#ifdef __cplusplus
extern "C"
#endif
struct sidl_double__array*
impl_vector_Utils_negate(
  /* in array<double> */ struct sidl_double__array* u,
  /* in */ int32_t badLevel,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 693 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.negate) */
    struct sidl_double__array* negU  = NULL;
    int                        sizeU;
  
    if (u != NULL)
    {
      sizeU = sidlLength(u, 0);
      if (badLevel == 0) {
        negU = impl_vector_Utils_product(-1.0, u, 0, _ex);  SIDL_CHECK(*_ex);
      } else if (badLevel == 1) {
        negU = NULL;
      } else if (badLevel == 2) {
        negU = sidl_double__array_create2dCol(sizeU, sizeU);
      } else if (badLevel == 3) {
        negU = sidl_double__array_create1d(sizeU+5);
      } else {
        negU = NULL;
      }
    }

    EXIT:;
    return negU;
    /* DO-NOT-DELETE splicer.end(vector.Utils.negate) */
#line 716 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return the normalization of the specified vector.
 * 
 * Note that the PostViolation can arise since the implementation
 * invokes norm through the stub.  Also, the tolerance is included because
 * the implementation invokes dot through the stub.
 * 
 * Note that badLevel has been added only to facilitate regression
 * testing of postconditions.  The levels are:
 * 0 = NONE  (i.e., no deliberate postcondition violation)
 * 1 = Return a null result (regardless of input)
 * 2 = Return a 2D array result (regardless of input)
 * 3 = Return an array of different size (regardless of input)
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_normalize"

#ifdef __cplusplus
extern "C"
#endif
struct sidl_double__array*
impl_vector_Utils_normalize(
  /* in array<double> */ struct sidl_double__array* u,
  /* in */ double tol,
  /* in */ int32_t badLevel,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 751 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.normalize) */
    struct sidl_double__array* prod  = NULL;
    int                        sizeU;
    double                     val;
  
    if (u != NULL)
    {
      sizeU = sidlLength(u, 0);
      if (badLevel == 0) {
        val = impl_vector_Utils_norm(u, tol, 0, _ex); SIDL_CHECK(*_ex);
        if (val != 0.0) {
          prod = impl_vector_Utils_product(1.0/val, u, 0, 
                                           _ex); SIDL_CHECK(*_ex);
        } else {
          SIDL_THROW(*_ex, vector_DivideByZeroException, 
            "DivideByZeroException: Divide by zero attempted in normalize");
        }
      } else if (badLevel == 1) {
        prod = NULL;
      } else if (badLevel == 2) {
        prod = sidl_double__array_create2dCol(sizeU, sizeU);
      } else if (badLevel == 3) {
        prod = sidl_double__array_create1d(sizeU+5);
      } else {
        prod = NULL;
      }
    }
  
    EXIT:;
    return prod;
    /* DO-NOT-DELETE splicer.end(vector.Utils.normalize) */
#line 782 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return the sum of the specified vectors.
 * 
 * Note that badLevel has been added only to facilitate regression
 * testing of postconditions.  The levels are:
 * 0 = NONE  (i.e., no deliberate postcondition violation)
 * 1 = Return a null result (regardless of input)
 * 2 = Return a 2D array result (regardless of input)
 * 3 = Return an array of different size (regardless of input)
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_sum"

#ifdef __cplusplus
extern "C"
#endif
struct sidl_double__array*
impl_vector_Utils_sum(
  /* in array<double> */ struct sidl_double__array* u,
  /* in array<double> */ struct sidl_double__array* v,
  /* in */ int32_t badLevel,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 813 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.sum) */
    struct sidl_double__array* sum = NULL;
    int                        i, sizeU, sizeV;
  
    if ( (u != NULL) && (v != NULL) ) 
    {
      sizeU = sidlLength(u, 0);
      sizeV = sidlLength(v, 0);
      if (badLevel == 0) 
      {
        if (  (sizeU == sizeV)
           && (sidlArrayDim(u) == 1) 
           && (sidlArrayDim(v) == 1) ) 
        {
          sum = sidl_double__array_create1d(sizeU);
          memset(sidl_double__array_first(sum), 0,
                 (size_t)(sizeU * sizeof(double)));
          for (i=0; i < sizeU; i++) {
            sidl_double__array_set1(sum, i, 
              sidl_double__array_get1(u,i) + sidl_double__array_get1(v,i));
          }
        }
      } else if (badLevel == 1) {
        sum = NULL;
      } else if (badLevel == 2) {
        sum = sidl_double__array_create2dCol(sizeU, sizeU);
      } else if (badLevel == 3) {
        sum = sidl_double__array_create1d(sizeU+5);
      } else {
        sum = NULL;
      }
    }

    return sum;
    /* DO-NOT-DELETE splicer.end(vector.Utils.sum) */
#line 848 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}

/*
 * Return the difference of the specified vectors.
 * 
 * Note that badLevel has been added only to facilitate regression
 * testing of postconditions.  The levels are:
 * 0 = NONE  (i.e., no deliberate postcondition violation)
 * 1 = Return a null result (regardless of input)
 * 2 = Return a 2D array result (regardless of input)
 * 3 = Return an array of different size (regardless of input)
 */

#undef __FUNC__
#define __FUNC__ "impl_vector_Utils_diff"

#ifdef __cplusplus
extern "C"
#endif
struct sidl_double__array*
impl_vector_Utils_diff(
  /* in array<double> */ struct sidl_double__array* u,
  /* in array<double> */ struct sidl_double__array* v,
  /* in */ int32_t badLevel,
  /* out */ sidl_BaseInterface *_ex)
{
  *_ex = 0;
  {
#line 879 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
    /* DO-NOT-DELETE splicer.begin(vector.Utils.diff) */
    struct sidl_double__array* diff  = NULL;
    int                        i, sizeU, sizeV;
  
    if ( (u != NULL) && (v != NULL) ) 
    {
      sizeU = sidlLength(u, 0);
      sizeV = sidlLength(v, 0);
      if (badLevel == 0) 
      {
        if (  (sizeU == sizeV)
           && (sidlArrayDim(u) == 1) 
           && (sidlArrayDim(v) == 1) ) 
        {
          diff = sidl_double__array_create1d(sizeU);
          memset(sidl_double__array_first(diff), 0,
                 (size_t)(sizeU * sizeof(double)));
          for (i=0; i < sizeU; i++) {
            sidl_double__array_set1(diff, i, 
              sidl_double__array_get1(u,i) - sidl_double__array_get1(v,i));
          }
        }
      } else if (badLevel == 1) {
        diff = NULL;
      } else if (badLevel == 2) {
        diff = sidl_double__array_create2dCol(sizeU, sizeU);
      } else if (badLevel == 3) {
        diff = sidl_double__array_create1d(sizeU+5);
      } else {
        diff = NULL;
      }
    }

    return diff;
    /* DO-NOT-DELETE splicer.end(vector.Utils.diff) */
#line 914 "../regression/assertions/libC/vector_Utils_Impl.c"
  }
}
/* Babel internal methods, Users should not edit below this line. */

#line 920 "/home/epperly/current/release_1.2.0/linux_dist/../babel_branch/regression/assertions/libC/vector_Utils_Impl.c"
/* DO-NOT-DELETE splicer.begin(_misc) */
/* Insert-Code-Here {_misc} (miscellaneous code) */
/* DO-NOT-DELETE splicer.end(_misc) */
#line 923 "../regression/assertions/libC/vector_Utils_Impl.c"

