/*
 * Copyright 2000 Murray Cumming
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef BAKERY_APP_GNOMEUI_H
#define BAKERY_APP_GNOMEUI_H

#include "bakery/App/App.h"
#include <libgnomeuimm.h>
#include <gtkmm.h>
//#include <libgnome/gnome-i18n.h>


namespace Bakery
{

/** Bakery's Main Window.
 * Features:
 * - Override methods to add/change menus/toolbars/statusbar.
 *   - Default is basic File, Edit, Help menus and toolbar icons.
 * - Configurable about box via set_about_information().
 *
 * TODO:
 * - Command-line args - wrap popt?
 * - Session Management - need Command-line args.
 *
 * Extra notes:
 * - The App is the main window.
 */
class App_GnomeUI
 : virtual public Bakery::App,
   public Gnome::UI::App
{
public:
  friend class AppInstanceManager;

  ///Don't forget to call init() too.
  App_GnomeUI(const Glib::ustring& appname, const Glib::ustring& title);
  virtual ~App_GnomeUI();
	
  virtual void init(); //Sets it up and shows it.

  static void set_command_line_args(int argc, char **&argv); //Needed for session management.


  typedef std::map<GnomeUIInfoConfigurableTypes, Gtk::Widget*> type_mapMenuItemWidgets;
		
protected:
  virtual void init_menus(); //Override this to add more menu or different menus.
  virtual void init_menus_file(); //Call this from init_menus() to add the standard file menu.
  virtual void init_menus_edit(); //Call this from init_menus() to add the standard edit menu
  virtual void init_menus_help(); //Call this from init_menus() to add the standard help menu.	
  virtual void init_toolbars();
  

  //Signal handlers:

  //Menus:  
  virtual void on_menu_help_about();


  virtual void on_about_close();

  //GnomeClient Session Management:
  virtual void on_session_die();
  virtual bool on_session_save_yourself(int phase, Gnome::UI::SaveStyle save_style, bool is_shutdown, Gnome::UI::InteractStyle interact_style, bool is_fast);

  virtual void on_hide(); //override.
    
  virtual void ui_hide();
  virtual void ui_bring_to_front();
  
  virtual bool on_delete_event(GdkEventAny *event); //override

  //virtual void destroy_and_remove_from_list();


  //Menus, toolbars:
  typedef std::vector<Gnome::UI::Items::SubTree> type_vecGnome_UI_SubTree;
  type_vecGnome_UI_SubTree m_menu_UI_Infos; //Filled by init_menus;
  typedef std::vector<Gnome::UI::Items::Info> type_vecGnome_UI_Info;
  type_vecGnome_UI_Info m_toolbar_UI_Infos; //Filled by init_toolbars;

  //Member widgets:
  Gnome::UI::AppBar m_Status;

  //All instances share 1 About box:
  static Gnome::UI::About* m_pAbout; //About box.
  
  //Command line args:
  static Glib::ustring m_strCommandLine_0;
};

} //namespace

#endif //BAKERY_APP_GNOMEUI_H
