/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qtabwidget.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <knuminput.h>
#include <kcolorcombo.h>
#include <kiconloader.h>
#include <kconfig.h>
#include <kglobal.h>
#include <klocale.h>
#include <kglobalsettings.h>
#include <kurllabel.h>
#include <qwhatsthis.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

#include "linklabel.h"
#include "settings.h"
#include "container.h"
#include "variouswidgets.h"

// FIXME: For ViewSizeDialog class
#include "additemdialog.h"

/** Settings */

bool   Settings::s_tabsOnTop            = true;
bool   Settings::s_searchOnTop          = true;
bool   Settings::s_onlyBasketsIcon      = false;
bool   Settings::s_showItemsToolTip     = true;
bool   Settings::s_blinkedSearch        = false;
bool   Settings::s_useSystray           = true;
/*bool Settings::s_wasShown             = true;*/
bool   Settings::s_showIconInSystray    = false;
bool   Settings::s_startDocked          = false;
int    Settings::s_middleAction         = 0;
int    Settings::s_writingAction        = 0;
int    Settings::s_writingCommaAction   = 0;
int    Settings::s_clickConf            = 2;
bool   Settings::s_useInlineEditors     = true;
bool   Settings::s_enterValidateInline  = false;
bool   Settings::s_hideOnMouseOut       = false;
int    Settings::s_timeToHideOnMouseOut = 0;
bool   Settings::s_showOnMouseIn        = false;
int    Settings::s_timeToShowOnMouseIn  = 1;
int    Settings::s_lastBasket           = 0;
int    Settings::s_dropTimeToShow       = 7;
bool   Settings::s_instantToolTips      = true;
bool   Settings::s_usePassivePopup      = true;
bool   Settings::s_clickCopyToSelection = true;
QPoint Settings::s_mainWindowPosition   = QPoint();
QSize  Settings::s_mainWindowSize       = QSize();
bool   Settings::s_showEmptyBasketInfo  = true;
// Programs :
bool    Settings::s_textUseProg       = false;
bool    Settings::s_htmlUseProg       = false;
bool    Settings::s_imageUseProg      = true;
bool    Settings::s_animationUseProg  = true;
bool    Settings::s_soundUseProg      = false;
QString Settings::s_textProg          = "";
QString Settings::s_htmlProg          = "quanta";
QString Settings::s_imageProg         = "kolourpaint";
QString Settings::s_animationProg     = "gimp";
QString Settings::s_soundProg         = "";
// Insert item Default Values :
int     Settings::s_defTextFont       = 0;
QColor  Settings::s_defTextColor      = Qt::black;
//bool    Settings::s_defHtmlShowSource = false;
int     Settings::s_defImageX         = 300;
int     Settings::s_defImageY         = 200;
int     Settings::s_defIconSize       = 32;

bool Settings::singleClick()
{
	switch (s_clickConf) {
		case 0:
			return true;
		case 1:
			return false;
		default: // case 2 and others (default value is 2)
			return KGlobalSettings::singleClick();
	}
}

void Settings::loadConfig()
{
	LinkLook *defaultSoundLook = new LinkLook( false, false,  false, false,
	                                           kapp->palette().active().foreground(), QColor("red"),
	                                           true, 16, false );
	LinkLook *defaultFileLook  = new LinkLook( false, false,  false, false,
	                                           kapp->palette().active().foreground(), QColor("red"),
	                                           true, 16, false );
	LinkLook *defaultLocalLook = new LinkLook( false, true,   false, true,
	                                           kapp->palette().active().link(),       QColor("red"),
	                                           true, 16, false );
	LinkLook *defaultUrlLook   = new LinkLook( true,  false,  false, true,
	                                           kapp->palette().active().link(),       QColor("red"),
	                                           true, 16, false );
	LinkLook *defaultNoUrlLook = new LinkLook( false,  false, true,  false,
	                                           kapp->palette().active().link(),       QColor("red"),
	                                           true, 48, false );

	loadLinkLook(LinkLook::soundLook, "Sounds look",        defaultSoundLook);
	loadLinkLook(LinkLook::fileLook,  "Files look",         defaultFileLook );
	loadLinkLook(LinkLook::localLook, "Local links look",   defaultLocalLook);
	loadLinkLook(LinkLook::urlLook,   "Network links look", defaultUrlLook  );
	loadLinkLook(LinkLook::noUrlLook, "NoUrl links look",   defaultNoUrlLook);

	KConfig *config = KGlobal::config();
	config->setGroup("Main window"); // TODO: Split with a "System tray icon" group !
	setTabsOnTop(            config->readBoolEntry("tabsOnTop",            true)  );
	setSearchOnTop(          config->readBoolEntry("searchOnTop",          true)  );
	setOnlyBasketsIcon(      config->readBoolEntry("onlyBasketsIcon",      false) );
	setShowItemsToolTip(     config->readBoolEntry("showItemsToolTip",     true)  );
	setBlinkedSearch(        config->readBoolEntry("blinkedSearch",        false) );
	setUseSystray(           config->readBoolEntry("useSystray",           true)  );
/*	setWasShown(             config->readBoolEntry("wasShown",             true)  );*/
	setShowIconInSystray(    config->readBoolEntry("showIconInSystray",    false) );
	setStartDocked(          config->readBoolEntry("startDocked",          false) );
	setMiddleAction(         config->readNumEntry( "middleAction",         0)     );
	setWritingAction(        config->readNumEntry( "writingAction",        0)     );
	setWritingCommaAction(   config->readNumEntry( "writingCommaAction",   0)     );
	setClickConf(            config->readNumEntry( "clickConf",            2)     );
	setUseInlineEditors(     config->readBoolEntry("useInlineEditors",     true)  );
	setEnterValidateInline(  config->readBoolEntry("enterValidateInline",  false) );
	setHideOnMouseOut(       config->readBoolEntry("hideOnMouseOut",       false) );
	setTimeToHideOnMouseOut( config->readNumEntry( "timeToHideOnMouseOut", 0)     );
	setShowOnMouseIn(        config->readBoolEntry("showOnMouseIn",        false) );
	setTimeToShowOnMouseIn(  config->readNumEntry( "timeToShowOnMouseIn",  1)     );
	setLastBasket(           config->readNumEntry( "lastBasket",           0)     );
	setDropTimeToShow(       config->readNumEntry( "dropTimeToShow",       7)     );
	setInstantToolTips(      config->readBoolEntry("instantToolTips",      true)  );
	setUsePassivePopup(      config->readBoolEntry("usePassivePopup",      true)  );
	setClickCopyToSelection( config->readBoolEntry("clickCopyToSelection", true)  );
	setMainWindowPosition(   config->readPointEntry("position"             )      );
	setMainWindowSize(       config->readSizeEntry( "size"                 )      );

	config->setGroup("Notification Messages");
	setShowEmptyBasketInfo(  config->readBoolEntry("emptyBasketInfo",      true)  );

	config->setGroup("Programs");
	setIsTextUseProg(        config->readBoolEntry("textUseProg",         false)         );
	setIsHtmlUseProg(        config->readBoolEntry("htmlUseProg",         false)         );
	setIsImageUseProg(       config->readBoolEntry("imageUseProg",        true)          );
	setIsAnimationUseProg(   config->readBoolEntry("animationUseProg",    true)          );
	setIsSoundUseProg(       config->readBoolEntry("soundUseProg",        false)         );
	setTextProg(             config->readEntry(    "textProg",            "")            );
	setHtmlProg(             config->readEntry(    "htmlProg",            "quanta")      );
	setImageProg(            config->readEntry(    "imageProg",           "kolourpaint") );
	setAnimationProg(        config->readEntry(    "animationProg",       "gimp")        );
	setSoundProg(            config->readEntry(    "soundProg",           "")            );

	config->setGroup("Insert item Default Values");
	QColor *color = new QColor(Qt::black);
	setDefTextFont(          config->readNumEntry(   "defTextFont",       0)             );
	setDefTextColor(         config->readColorEntry( "defTextColor",      color)         );
//	setDefHtmlShowSource(    config->readBoolEntry(  "defHtmlShowSource", false)         );
	setDefImageX(            config->readNumEntry(   "defImageX",         300)           );
	setDefImageY(            config->readNumEntry(   "defImageY",         200)           );
	setDefIconSize(          config->readNumEntry(   "defIconSize",       32)            );
	delete color;
}

void Settings::saveConfig()
{
	saveLinkLook(LinkLook::soundLook, "Sounds look"       );
	saveLinkLook(LinkLook::fileLook,  "Files look"        );
	saveLinkLook(LinkLook::localLook, "Local links look"  );
	saveLinkLook(LinkLook::urlLook,   "Network links look");
	saveLinkLook(LinkLook::noUrlLook, "NoUrl links look"  );

	KConfig *config = KGlobal::config();
	config->setGroup("Main window");
	config->writeEntry( "tabsOnTop",            tabsOnTop()            );
	config->writeEntry( "searchOnTop",          searchOnTop()          );
	config->writeEntry( "onlyBasketsIcon",      onlyBasketsIcon()      );
	config->writeEntry( "showItemsToolTip",     showItemsToolTip()     );
	config->writeEntry( "blinkedSearch",        blinkedSearch()        );
	config->writeEntry( "useSystray",           useSystray()           );
/*	config->writeEntry( "wasShown",             wasShown()             );*/
	config->writeEntry( "showIconInSystray",    showIconInSystray()    );
	config->writeEntry( "startDocked",          startDocked()          );
	config->writeEntry( "middleAction",         middleAction()         );
	config->writeEntry( "writingAction",        writingAction()        );
	config->writeEntry( "writingCommaAction",   writingCommaAction()   );
	config->writeEntry( "clickConf",            clickConf()            );
	config->writeEntry( "useInlineEditors",     useInlineEditors()     );
	config->writeEntry( "enterValidateInline",  enterValidateInline()  );
	config->writeEntry( "hideOnMouseOut",       hideOnMouseOut()       );
	config->writeEntry( "timeToHideOnMouseOut", timeToHideOnMouseOut() );
	config->writeEntry( "showOnMouseIn",        showOnMouseIn()        );
	config->writeEntry( "timeToShowOnMouseIn",  timeToShowOnMouseIn()  );
	config->writeEntry( "lastBasket",           lastBasket()           );
	config->writeEntry( "dropTimeToShow",       dropTimeToShow()       );
	config->writeEntry( "instantToolTips",      instantToolTips()      );
	config->writeEntry( "usePassivePopup",      usePassivePopup()      );
	config->writeEntry( "clickCopyToSelection", clickCopyToSelection() );
	config->writeEntry( "position",             mainWindowPosition()   );
	config->writeEntry( "size",                 mainWindowSize()       );

	config->setGroup("Notification Messages");
	config->writeEntry( "emptyBasketInfo",      showEmptyBasketInfo()  );

	config->setGroup("Programs");
	config->writeEntry( "textUseProg",          isTextUseProg()        );
	config->writeEntry( "htmlUseProg",          isHtmlUseProg()        );
	config->writeEntry( "imageUseProg",         isImageUseProg()       );
	config->writeEntry( "animationUseProg",     isAnimationUseProg()   );
	config->writeEntry( "soundUseProg",         isSoundUseProg()       );
	config->writeEntry( "textProg",             textProg()             );
	config->writeEntry( "htmlProg",             htmlProg()             );
	config->writeEntry( "imageProg",            imageProg()            );
	config->writeEntry( "animationProg",        animationProg()        );
	config->writeEntry( "soundProg",            soundProg()            );

	config->setGroup("Insert item Default Values");
	config->writeEntry( "defTextFont",       defTextFont()       );
	config->writeEntry( "defTextColor",      defTextColor()      );
//	config->writeEntry( "defHtmlShowSource", defHtmlShowSource() );
	config->writeEntry( "defImageX",         defImageX()         );
	config->writeEntry( "defImageY",         defImageY()         );
	config->writeEntry( "defIconSize",       defIconSize()       );
}

void Settings::loadLinkLook(LinkLook* &look, const QString &name, LinkLook *defaultL)
{
	KConfig *config = KGlobal::config();
	config->setGroup(name);

	bool   underline  = config->readBoolEntry(     "underline",  defaultL->underline()  );
	bool   italic     = config->readBoolEntry(     "italic",     defaultL->italic()     );
	bool   bold       = config->readBoolEntry(     "bold",       defaultL->bold()       );
	bool   hoverUnder = config->readBoolEntry(     "hoverUnder", defaultL->hoverUnder() );
	QColor color      = config->readPropertyEntry( "color",      defaultL->color()      ).asColor();
	QColor hoverColor = config->readPropertyEntry( "hoverColor", defaultL->hoverColor() ).asColor();
	bool   showIcon   = config->readBoolEntry(     "showIcon",   defaultL->showIcon()   );
	int    iconSize   = config->readNumEntry(      "iconSize",   defaultL->iconSize()   );
	bool   onTopIcon  = config->readBoolEntry(     "onTopIcon",  defaultL->onTopIcon()  );

	if (look)
		delete look;//look->setLook( underline, italic, bold, hoverUnder, color, hoverColor, showIcon, iconSize, onTopIcon );
		            //else  // TODO: when look change, compare pointers and update LinkLabel only if != ??
	look = new LinkLook( underline, italic, bold, hoverUnder, color, hoverColor, showIcon, iconSize, onTopIcon );
}

void Settings::saveLinkLook(LinkLook *look, const QString &name)
{
	KConfig *config = KGlobal::config();
	config->setGroup(name);

	config->writeEntry( "underline",  look->underline()  );
	config->writeEntry( "italic",     look->italic()     );
	config->writeEntry( "bold",       look->bold()       );
	config->writeEntry( "hoverUnder", look->hoverUnder() );
	config->writeEntry( "color",      look->color()      );
	config->writeEntry( "hoverColor", look->hoverColor() );
	config->writeEntry( "showIcon",   look->showIcon()   );
	config->writeEntry( "iconSize",   look->iconSize()   );
	config->writeEntry( "onTopIcon",  look->onTopIcon()  );
}

/** SettingsDialog */

SettingsDialog::SettingsDialog(QWidget *parent)
 : KDialogBase(KDialogBase::IconList, i18n("Configure"),
               KDialogBase::Default | KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel, KDialogBase::Ok, parent)
{
	QFrame *page1 = addPage( i18n("General"),              QString::null, DesktopIcon("basket",     KIcon::SizeMedium) );
	QFrame *page5 = addPage( i18n("Items Default Values"), QString::null, DesktopIcon("edit",       KIcon::SizeMedium) );
	QFrame *page3 = addPage( i18n("Items Look"),           QString::null, DesktopIcon("colorize"/*"appearance"*/, KIcon::SizeMedium) );
	QFrame *page4 = addPage( i18n("Applications"),         QString::null, DesktopIcon("run",        KIcon::SizeMedium) );
	QFrame *page6 = addPage( i18n("Addictive Features"),   QString::null, DesktopIcon("package_utilities",
	                                                                                                KIcon::SizeMedium) );

	/* Main Window page */
	QVBoxLayout *layout = new QVBoxLayout(page1, 0, 6);

	m_useSystray = new QCheckBox(i18n("Doc&k BasKet in system tray"), page1);
	m_useSystray->setChecked(Settings::useSystray());
	layout->addWidget(m_useSystray);

	m_showItemsToolTip = new QCheckBox(i18n("Show ite&ms tooltips"), page1);
	m_showItemsToolTip->setChecked(Settings::showItemsToolTip());
	layout->addWidget(m_showItemsToolTip);

	m_instantToolTips = new QCheckBox(i18n("Show tooltips i&nstantaneously"), page1);
	m_instantToolTips->setChecked(Settings::instantToolTips());
	layout->addWidget(m_instantToolTips);

	m_usePassivePopup = new QCheckBox(i18n("Use baloons to re&port result of global actions"), page1);
	m_usePassivePopup->setChecked(Settings::usePassivePopup());
	layout->addWidget(m_usePassivePopup);

	m_useInlineEditors = new QCheckBox(i18n("Use &inline editors for text and rich text items"), page1);
	m_useInlineEditors->setChecked(Settings::useInlineEditors());
	layout->addWidget(m_useInlineEditors);

	QGridLayout *gl = new QGridLayout(layout, 3, 3);
	gl->addItem(new QSpacerItem(0, 0, QSizePolicy::Expanding), 0, 2);

	m_tabsOnTop = new QComboBox(page1);
	m_tabsOnTop->insertItem(i18n("On top"));
	m_tabsOnTop->insertItem(i18n("On bottom"));
	m_tabsOnTop->setCurrentItem( (int)!Settings::tabsOnTop() );
	QLabel *label1 = new QLabel(m_tabsOnTop, i18n("&Tabs bar position:"), page1);
	gl->addWidget(label1,      0, 0);
	gl->addWidget(m_tabsOnTop, 0, 1);

	m_searchOnTop = new QComboBox(page1);
	m_searchOnTop->insertItem(i18n("On top"));
	m_searchOnTop->insertItem(i18n("On bottom"));
	m_searchOnTop->setCurrentItem( (int)!Settings::searchOnTop() );
	QLabel *label9 = new QLabel(m_searchOnTop, i18n("Search &bar position:"), page1);
	gl->addWidget(label9,        1, 0);
	gl->addWidget(m_searchOnTop, 1, 1);

	m_clickConf = new QComboBox(page1);
	m_clickConf->insertItem( i18n("Single click (mouse hover to select them)")             );
	m_clickConf->insertItem( i18n("Double click (single click to select them)")            );
	m_clickConf->insertItem( i18n("Follow KDE wide settings (%1)")
		.arg(KGlobalSettings::singleClick() ? i18n("single click") : i18n("double click")) );
	m_clickConf->setCurrentItem(Settings::clickConf());
	connect( m_clickConf, SIGNAL(activated(int)), this, SLOT(clickConfChanged(int)) );
	QLabel *labelX = new QLabel(m_clickConf, i18n("&Launch items actions:"), page1);
	gl->addWidget(labelX,      2, 0);
	gl->addWidget(m_clickConf, 2, 1);

	// Item Click Copy:
	m_gbClickToCopy = new QGroupBox(4, Qt::Vertical, "****", page1); // "****": will be replaced in clickConfChanged(int)
	QRadioButton *r1 = new QRadioButton(i18n("Copy the item to clipboa&rd"), m_gbClickToCopy);
	QRadioButton *r2 = new QRadioButton(i18n("Copy the item to &selection"), m_gbClickToCopy);
	m_itemClickCopy = new QButtonGroup();
	m_itemClickCopy->insert(r1);
	m_itemClickCopy->insert(r2);
	m_itemClickCopy->setButton(Settings::clickCopyToSelection());
	m_lblClickToCopy = new QLabel("****", m_gbClickToCopy); // "****": will be replaced in clickConfChanged(int)

	KURLLabel *help = new KURLLabel(m_gbClickToCopy);
	help->setText(i18n("What is the selection?"));
	m_helpLabel = help;
	connect( help, SIGNAL(leftClickedURL()), this, SLOT(showSelectionHelp())   );

	layout->addWidget(m_gbClickToCopy);

	layout->insertStretch(-1);

	/* Items Default Values page */
	setupItemsDefaultValuesPage(page5);

	/* Links page */
	QVBoxLayout *layout3 = new QVBoxLayout(page3, 0, 6);
	QLabel *label3 = new QLabel(i18n("Customize look of file, sound, link and launcher items:"), page3);
	QTabWidget *tabs = new QTabWidget(page3);
	layout3->addWidget(label3);
	layout3->addWidget(tabs);

	m_soundLC = new LinkLookEditWidget(LinkLook::soundLook, i18n("Conference audio record"), "sound",       tabs);
	m_fileLC  = new LinkLookEditWidget(LinkLook::fileLook,  i18n("Annual report"),           "document",    tabs);
	m_localLC = new LinkLookEditWidget(LinkLook::localLook, i18n("Home folder"),             "folder_home", tabs);
	m_urlLC   = new LinkLookEditWidget(LinkLook::urlLook,        "www.kde.org",              "www",         tabs);
	m_noUrlLC = new LinkLookEditWidget(LinkLook::noUrlLook, i18n("Launch BasKet"),           "basket",      tabs);
	tabs->addTab(m_soundLC, i18n("&Sounds")       );
	tabs->addTab(m_fileLC,  i18n("&Files")        );
	tabs->addTab(m_localLC, i18n("&Local Links")  );
	tabs->addTab(m_urlLC,   i18n("&Network Links"));
	tabs->addTab(m_noUrlLC, i18n("Launc&hers")    );

	/* Applications page */
	QVBoxLayout *layout4 = new QVBoxLayout(page4, 0, 6);

	m_textUseProg  = new QCheckBox(i18n("Open &text items with a custom application:"), page4);
	m_textProg     = new RunCommandRequester(Settings::textProg(), i18n("Open text items with:"), page4);
	m_textUseProg->setChecked(Settings::isTextUseProg());
	m_textProg->setEnabled(Settings::isTextUseProg());
	QHBoxLayout *hLayT = new QHBoxLayout(0, 0, 6);
	hLayT->insertSpacing(-1, 20);
	hLayT->addWidget(m_textProg);

	m_htmlUseProg  = new QCheckBox(i18n("Open &rich text items with a custom application:"), page4);
	m_htmlProg     = new RunCommandRequester(Settings::htmlProg(), i18n("Open rich text items with:"), page4);
	m_htmlUseProg->setChecked(Settings::isHtmlUseProg());
	m_htmlProg->setEnabled(Settings::isHtmlUseProg());
	QHBoxLayout *hLayH = new QHBoxLayout(0, 0, 6);
	hLayH->insertSpacing(-1, 20);
	hLayH->addWidget(m_htmlProg);

	m_imageUseProg = new QCheckBox(i18n("Open &image items with a custom application:"), page4);
	m_imageProg    = new RunCommandRequester(Settings::imageProg(), i18n("Open image items with:"), page4);
	m_imageUseProg->setChecked(Settings::isImageUseProg());
	m_imageProg->setEnabled(Settings::isImageUseProg());
	QHBoxLayout *hLayI = new QHBoxLayout(0, 0, 6);
	hLayI->insertSpacing(-1, 20);
	hLayI->addWidget(m_imageProg);

	m_animationUseProg = new QCheckBox(i18n("Open a&nimation items with a custom application:"), page4);
	m_animationProg    = new RunCommandRequester(Settings::animationProg(), i18n("Open animation items with:"), page4);
	m_animationUseProg->setChecked(Settings::isAnimationUseProg());
	m_animationProg->setEnabled(Settings::isAnimationUseProg());
	QHBoxLayout *hLayA = new QHBoxLayout(0, 0, 6);
	hLayA->insertSpacing(-1, 20);
	hLayA->addWidget(m_animationProg);

	m_soundUseProg = new QCheckBox(i18n("Open so&und items with a custom application:"), page4);
	m_soundProg    = new RunCommandRequester(Settings::soundProg(), i18n("Open sound items with:"), page4);
	m_soundUseProg->setChecked(Settings::isSoundUseProg());
	m_soundProg->setEnabled(Settings::isSoundUseProg());
	QHBoxLayout *hLayS = new QHBoxLayout(0, 0, 6);
	hLayS->insertSpacing(-1, 20);
	hLayS->addWidget(m_soundProg);

	QString whatsthis = i18n(
		"<p>If checked, the application defined below will be used when openning that type of item.</p>"
		"<p>Otherwise, the application you've configured to in Konqueror will be used.</p>");

	QWhatsThis::add(m_textUseProg,      whatsthis);
	QWhatsThis::add(m_htmlUseProg,      whatsthis);
	QWhatsThis::add(m_imageUseProg,     whatsthis);
	QWhatsThis::add(m_animationUseProg, whatsthis);
	QWhatsThis::add(m_soundUseProg,     whatsthis);

	whatsthis = i18n(
		"<p>Define the application to use for openning that type of item instead of the "
		"application configured in Konqueror.</p>");

	QWhatsThis::add(m_textProg,      whatsthis);
	QWhatsThis::add(m_htmlProg,      whatsthis);
	QWhatsThis::add(m_imageProg,     whatsthis);
	QWhatsThis::add(m_animationProg, whatsthis);
	QWhatsThis::add(m_soundProg,     whatsthis);

	layout4->addWidget(m_textUseProg);
	layout4->addItem(hLayT);
	layout4->addWidget(m_htmlUseProg);
	layout4->addItem(hLayH);
	layout4->addWidget(m_imageUseProg);
	layout4->addItem(hLayI);
	layout4->addWidget(m_animationUseProg);
	layout4->addItem(hLayA);
	layout4->addWidget(m_soundUseProg);
	layout4->addItem(hLayS);
	layout4->insertStretch(-1);

	connect( m_textUseProg,      SIGNAL(toggled(bool)), m_textProg,      SLOT(setEnabled(bool)) );
	connect( m_htmlUseProg,      SIGNAL(toggled(bool)), m_htmlProg,      SLOT(setEnabled(bool)) );
	connect( m_imageUseProg,     SIGNAL(toggled(bool)), m_imageProg,     SLOT(setEnabled(bool)) );
	connect( m_animationUseProg, SIGNAL(toggled(bool)), m_animationProg, SLOT(setEnabled(bool)) );
	connect( m_soundUseProg,     SIGNAL(toggled(bool)), m_soundProg,     SLOT(setEnabled(bool)) );

	/* Addicitive features */
	QVBoxLayout *layout6 = new QVBoxLayout(page6, 0, 6);

	layout6->addWidget( new QLabel(i18n("This page group non-standard options that, once learned,\n"
	                                    "can be very powerful and time saving in the context of BasKet:"), page6) );

	m_onlyBasketsIcon = new QCheckBox(i18n("&Hide name of baskets with icons in the tabs bar"), page6);
	m_onlyBasketsIcon->setChecked(Settings::onlyBasketsIcon());
	layout6->addWidget(m_onlyBasketsIcon);

	m_enterValidateInlineWidget = new QWidget(page6);
	QHBoxLayout *hLayV = new QHBoxLayout(m_enterValidateInlineWidget, 0, 6);
	m_enterValidateInline = new QCheckBox(i18n("&Validate with Return in inline editors"), m_enterValidateInlineWidget);
	m_enterValidateInline->setChecked(Settings::enterValidateInline());
	KURLLabel *helpV = new KURLLabel(m_enterValidateInlineWidget);
	helpV->setText(i18n("How to insert new lines?"));
	connect( helpV, SIGNAL(leftClickedURL()), this, SLOT(showNewLineHelp()) );
	hLayV->addWidget(m_enterValidateInline);
	hLayV->addWidget(helpV);
	hLayV->insertStretch(-1);
	layout6->addWidget(m_enterValidateInlineWidget);
	m_enterValidateInlineWidget->setEnabled(m_useInlineEditors->isChecked());
	connect( m_useInlineEditors, SIGNAL(toggled(bool)), m_enterValidateInlineWidget, SLOT(setEnabled(bool)) );

	QGridLayout *ga = new QGridLayout(layout6, 3, 4);
	ga->addItem(new QSpacerItem(0, 0, QSizePolicy::Expanding), 0, 3);

	m_middleAction = new QComboBox(page6);
	m_middleAction->insertItem( i18n("Do nothing")            );
	m_middleAction->insertItem( i18n("Paste clipboard")       );
	m_middleAction->insertItem( i18n("Insert text item")      );
	m_middleAction->insertItem( i18n("Insert rich text item") );
	m_middleAction->insertItem( i18n("Insert image item")     );
	m_middleAction->insertItem( i18n("Insert link item")      );
	m_middleAction->insertItem( i18n("Insert launcher item")  );
	m_middleAction->insertItem( i18n("Insert color item")     );
	m_middleAction->setCurrentItem(Settings::middleAction());
	QLabel *labelM = new QLabel(m_middleAction, i18n("&Shift+middle-click:"), page6);
	ga->addWidget(labelM,                                         0, 0);
	ga->addWidget(m_middleAction,                                 0, 1);
	ga->addWidget(new QLabel(i18n("at cursor position"), page6),  0, 2);

	m_writingAction = new QComboBox(page6);
	m_writingAction->insertItem( i18n("Do nothing")            );
	m_writingAction->insertItem( i18n("Search")                );
	m_writingAction->insertItem( i18n("Insert text item")      );
	m_writingAction->insertItem( i18n("Insert rich text item") );
	m_writingAction->insertItem( i18n("Insert link item")      );
	m_writingAction->setCurrentItem(Settings::writingAction());
	QLabel *labelY = new QLabel(m_writingAction, i18n("&When writing in a basket:"), page6);
	ga->addWidget(labelY,          1, 0);
	ga->addWidget(m_writingAction, 1, 1);

	m_writingCommaAction = new QComboBox(page6);
	m_writingCommaAction->insertItem( i18n("Do the same")           );
	m_writingCommaAction->insertItem( i18n("Search")                );
	m_writingCommaAction->insertItem( i18n("Insert text item")      );
	m_writingCommaAction->insertItem( i18n("Insert rich text item") );
	m_writingCommaAction->insertItem( i18n("Insert link item")      );
	m_writingCommaAction->setCurrentItem(Settings::writingCommaAction());
	QLabel *labelZ = new QLabel(m_writingCommaAction, i18n("&But begin writting with a comma (,):"), page6);
	ga->addWidget(labelZ,               2, 0);
	ga->addWidget(m_writingCommaAction, 2, 1);

	QGroupBox *gbSys = new QGroupBox(3, Qt::Vertical, i18n("System Tray Icon"), page6);
	layout6->addWidget(gbSys);

	m_systray = new QWidget(gbSys);
	QVBoxLayout *sysLay = new QVBoxLayout(m_systray, 0, 6);

	m_showIconInSystray = new QCheckBox(i18n("Show c&urrent basket icon in system tray"), m_systray);
	sysLay->addWidget(m_showIconInSystray);

	QGridLayout *gs = new QGridLayout(sysLay, 2, 3);
	gs->addItem(new QSpacerItem(0, 0, QSizePolicy::Expanding), 0, 2);

	m_hideOnMouseOut = new QCheckBox(i18n("H&ide main window when mouse go out of it for"), m_systray);
	m_timeToHideOnMouseOut = new KIntNumInput(Settings::timeToHideOnMouseOut(), m_systray);
	m_timeToHideOnMouseOut->setRange(0, 600, 1, false);
	m_timeToHideOnMouseOut->setSuffix(i18n(" tenths of seconds"));
	gs->addWidget(m_hideOnMouseOut,       0, 0);
	gs->addWidget(m_timeToHideOnMouseOut, 0, 1);

	m_showOnMouseIn  = new QCheckBox(i18n("Show &main window when mouse hover the systray icon for"), m_systray);
	m_timeToShowOnMouseIn = new KIntNumInput(Settings::timeToShowOnMouseIn(), m_systray);
	m_timeToShowOnMouseIn->setRange(0, 600, 1, false);
	m_timeToShowOnMouseIn->setSuffix(i18n(" tenths of seconds"));
	gs->addWidget(m_showOnMouseIn,       1, 0);
	gs->addWidget(m_timeToShowOnMouseIn, 1, 1);

	layout6->insertStretch(-1);

	connect( m_useSystray,     SIGNAL(toggled(bool)), gbSys,                  SLOT(setEnabled(bool)) );
	connect( m_hideOnMouseOut, SIGNAL(toggled(bool)), m_timeToHideOnMouseOut, SLOT(setEnabled(bool)) );
	connect( m_showOnMouseIn,  SIGNAL(toggled(bool)), m_timeToShowOnMouseIn,  SLOT(setEnabled(bool)) );

	clickConfChanged(m_clickConf->currentItem());

	m_showIconInSystray->setChecked(    Settings::showIconInSystray()  );
	m_hideOnMouseOut->setChecked(       Settings::hideOnMouseOut()     );
	m_showOnMouseIn->setChecked(        Settings::showOnMouseIn()      );

	m_systray->setEnabled(              Settings::useSystray()         );
	m_timeToHideOnMouseOut->setEnabled( Settings::hideOnMouseOut()     );
	m_timeToShowOnMouseIn->setEnabled(  Settings::showOnMouseIn()      );
}

SettingsDialog::~SettingsDialog()
{
}

void SettingsDialog::clickConfChanged(int conf)
{
	QString gb;
	QString lbl;

	if (conf == 0 || (conf == 2 && KGlobalSettings::singleClick())) { // Single click
		gb  = i18n("When Clicking an Item to Copy It");
		lbl = i18n("If Shift is pressed during the click, the item will be copied to the other.");
	} else {
		gb  = i18n("When Double-Clicking an Item to Copy It");
		lbl = i18n("If Shift is pressed during the double-click, the item will be copied to the other.");
	}

	m_gbClickToCopy->setTitle(gb);
	m_lblClickToCopy->setText("<p>" + lbl + "</p>"); // Make the label wordwrap
}

void SettingsDialog::showSelectionHelp()
{
	QString help = "<p>" + i18n(
		"When you select a text in any application, it is copied in a special clipboard named "
		"'Selection' that you can paste in any other application by simply pressing the middle mouse button.") + "</p><p>";

	if (m_clickConf->currentItem() == 0 ||
	    (m_clickConf->currentItem() == 2 && KGlobalSettings::singleClick())) // Single click
		help += i18n("BasKet let you to copy an item to the selection by just "
		             "clicking it, allowing quick pastes with the mouse.");
	else
		help += i18n("BasKet let you to copy an item to the selection by just "
		             "double-clicking it, allowing quick pastes with the mouse.");

	help += " " + i18n("If you aren't used to the selection, you can copy the item to the normal clipboard.") + "</p>";

	QWhatsThis::display(help);
}

void SettingsDialog::showNewLineHelp()
{
	QWhatsThis::display(i18n(
		"<p>If you activate validating with the Return key, you still can insert new lines by pressing Ctrl+Return "
		"in text editors.</p>"
		"<p>Notice that new paragraphs in rich text editors are inserted with Shift+Return.</p>"));
}

void SettingsDialog::setupItemsDefaultValuesPage(QWidget *parent)
{
	QVBoxLayout *layout = new QVBoxLayout(parent, 0, 5);
	QHBoxLayout *hLay;
	QLabel      *label;

	label = new QLabel(i18n("Change properties that future inserted items will get at creation time:"), parent);
	layout->addWidget(label);

	// Text :
	label = new QLabel(i18n("<b>Text:</b>"), parent);
	layout->addWidget(label);

	hLay = new QHBoxLayout(0, 0, 5);
	hLay->addSpacing(20);
	m_font  = new QComboBox(parent);
	m_font->insertItem(i18n("Default"));
	m_font->insertItem(i18n("Sans serif"));
	m_font->insertItem(i18n("Serif"));
	m_font->insertItem(i18n("Monospace"));
	label = new QLabel(m_font, i18n("A&ppearance:"), parent);
	hLay->addWidget(label);
	hLay->addWidget(m_font);
	m_color = new KColorCombo(parent);
	hLay->addWidget(m_color);
	hLay->addStretch();
	layout->addLayout(hLay);

	// Rich text :
/*	label = new QLabel(i18n("<b>Rich text:</b>"), parent);
	layout->addWidget(label);

	hLay = new QHBoxLayout(0, 0, 5);
	hLay->addSpacing(20);
	m_showHtmlSource = new QCheckBox(i18n("&Show HTML source"), parent);
	hLay->addWidget(m_showHtmlSource);
	layout->addLayout(hLay);*/

	// Image :
	label = new QLabel(i18n("<b>Image:</b>"), parent);
	layout->addWidget(label);

	hLay = new QHBoxLayout(0, 0, 5);
	hLay->addSpacing(20);
	m_imgSizeX = new KIntNumInput(parent);
	m_imgSizeX->setMinValue(1);
	m_imgSizeX->setMaxValue(4096);
	m_imgSizeX->setReferencePoint(100);
	label = new QLabel(m_imgSizeX, i18n("Si&ze:"), parent);
	hLay->addWidget(label);
	hLay->addWidget(m_imgSizeX);
	m_imgSizeY = new KIntNumInput(parent);
	m_imgSizeY->setMinValue(1);
	m_imgSizeY->setMaxValue(4096);
	m_imgSizeY->setReferencePoint(100);
	label = new QLabel(m_imgSizeY, i18n("&by"), parent);
	hLay->addWidget(label);
	hLay->addWidget(m_imgSizeY);
	label = new QLabel(i18n("pixels"), parent);
	hLay->addWidget(label);
	m_pushVisualize = new QPushButton(i18n("&Visualize..."), parent);
	hLay->addWidget(m_pushVisualize);
	hLay->addStretch();
	layout->addLayout(hLay);

	connect( m_pushVisualize, SIGNAL(clicked()), this, SLOT(visualize()) );

	// Import an icon :
	label = new QLabel(i18n("<b>Import an icon:</b>"), parent);
	layout->addWidget(label);

	hLay = new QHBoxLayout(0, 0, 5);
	hLay->addSpacing(20);
	m_iconSize = new IconSizeCombo(false, parent);
	label = new QLabel(m_iconSize, i18n("Siz&e:"), parent);
	hLay->addWidget(label);
	hLay->addWidget(m_iconSize);
	hLay->addStretch();
	layout->addLayout(hLay);

	layout->addStretch();

	m_font->setCurrentItem(       Settings::defTextFont()       );
	m_color->setColor(            Settings::defTextColor()      );
//	m_showHtmlSource->setChecked( Settings::defHtmlShowSource() );
	m_imgSizeX->setValue(         Settings::defImageX()         );
	m_imgSizeY->setValue(         Settings::defImageY()         );
	m_iconSize->setSize(          Settings::defIconSize()       );
}

void SettingsDialog::visualize()
{
	ViewSizeDialog size(this, m_imgSizeX->value(), m_imgSizeY->value());
	size.exec();
	m_imgSizeX->setValue(size.width());
	m_imgSizeY->setValue(size.height());
}

void SettingsDialog::slotDefault()
{
	m_font->setCurrentItem(       0         );
	m_color->setColor(            Qt::black );
//	m_showHtmlSource->setChecked( false     );
	m_imgSizeX->setValue(         300       );
	m_imgSizeY->setValue(         200       );
	m_iconSize->setSize(          32        );

	KDialogBase::slotDefault();
}

void SettingsDialog::slotApply()
{
	Settings::setTabsOnTop(            ! m_tabsOnTop->currentItem()        );
	Settings::setSearchOnTop(          ! m_searchOnTop->currentItem()      );
	Settings::setOnlyBasketsIcon(      m_onlyBasketsIcon->isChecked()      );
	Settings::setShowItemsToolTip(     m_showItemsToolTip->isChecked()     );
	Settings::setInstantToolTips(      m_instantToolTips->isChecked()      );
	Settings::setUsePassivePopup(      m_usePassivePopup->isChecked()      );
	Settings::setMiddleAction(         m_middleAction->currentItem()       );
	Settings::setWritingAction(        m_writingAction->currentItem()      );
	Settings::setWritingCommaAction(   m_writingCommaAction->currentItem() );
	Settings::setClickConf(            m_clickConf->currentItem()          );
	Settings::setUseInlineEditors(     m_useInlineEditors->isChecked()     );
	Settings::setEnterValidateInline(  m_enterValidateInline->isChecked()  );
	Settings::setClickCopyToSelection( m_itemClickCopy->selectedId()       );

	Settings::setUseSystray(           m_useSystray->isChecked()           );
	Settings::setShowIconInSystray(    m_showIconInSystray->isChecked()    );
	Settings::setHideOnMouseOut(       m_hideOnMouseOut->isChecked()       );
	Settings::setTimeToHideOnMouseOut( m_timeToHideOnMouseOut->value()     );
	Settings::setShowOnMouseIn(        m_showOnMouseIn->isChecked()        );
	Settings::setTimeToShowOnMouseIn(  m_timeToShowOnMouseIn->value()      );

	Settings::setDefTextFont(          m_font->currentItem()               );
	Settings::setDefTextColor(         m_color->color()                    );
//	Settings::setDefHtmlShowSource(    m_showHtmlSource->isChecked()       );
	Settings::setDefImageX(            m_imgSizeX->value()                 );
	Settings::setDefImageY(            m_imgSizeY->value()                 );
	Settings::setDefIconSize(          m_iconSize->iconSize()              );

	Settings::setIsTextUseProg(        m_textUseProg->isChecked()          );
	Settings::setIsHtmlUseProg(        m_htmlUseProg->isChecked()          );
	Settings::setIsImageUseProg(       m_imageUseProg->isChecked()         );
	Settings::setIsAnimationUseProg(   m_animationUseProg->isChecked()     );
	Settings::setIsSoundUseProg(       m_soundUseProg->isChecked()         );
	Settings::setTextProg(             m_textProg->runCommand()            );
	Settings::setHtmlProg(             m_htmlProg->runCommand()            );
	Settings::setImageProg(            m_imageProg->runCommand()           );
	Settings::setAnimationProg(        m_animationProg->runCommand()       );
	Settings::setSoundProg(            m_soundProg->runCommand()           );

	m_soundLC->saveChanges();
	m_fileLC->saveChanges();
	m_localLC->saveChanges();
	m_urlLC->saveChanges();
	m_noUrlLC->saveChanges();
	Global::mainContainer->linkLookChanged();

	Settings::saveConfig();

	KDialogBase::slotApply();
}

void SettingsDialog::slotOk()
{
	slotApply();
	KDialogBase::slotOk();
}

#include "settings.moc"
