# Copyright (C) 1999, 2000 Jay Beale
# Licensed under the GNU General Public License

package Bastille::FTP;
use lib "/usr/lib";

use Bastille::API;
@ENV="";
$ENV{PATH}="";
$ENV{CDPATH}=".";
$ENV{BASH_ENV}="";




#######################################################################
##                                  FTP                              ##
#######################################################################

#&ConfigureProFTP;
&LimitFTPbyUserType;


sub ConfigureProFTP {
   #&ActionLog("# sub ConfigureProFTP\n");
   # Let's offer the option to install ProFTP here.  Either way, we'll
   # still tighten wu-ftpd, as so many people use it.
}


sub LimitFTPbyUserType {

    if ((&getGlobalConfig("FTP","anonftp") eq "Y") or (&getGlobalConfig("FTP","userftp") eq "Y")) {
	&ActionLog("# sub LimitFTPbyUserType\n");

	# Optionally disable user and/or anonymous ftp

	# Construct the class line, based on what is disabled...  
        # note: based on our tests, it is completely safe to have a line which lists no classes: no logins wil be allowed
	#       in that case, which is what we want...

	my $class_line="class   all   ";

	unless (&getGlobalConfig("FTP","userftp") eq "Y") {
	    $class_line .= "real,guest";
	    unless (&getGlobalConfig("FTP","anonftp") eq "Y") {
		$class_line .= ",";
	    }
	}
	unless (&getGlobalConfig("FTP","anonftp") eq "Y") {
	    $class_line .= "anonymous";
	}
	$class_line .= "   *\n";

	# put the line in place...
 
	&B_replace_line ("/etc/ftpaccess",'^\s*class',$class_line);

   }
   
}


1;
