/* archives.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__ARCHIVES_H
#define INCLUDE__LIBARCH__ARCHIVES_H


#include "libawk/relational.h"
#include "libinifile/inifile.h"
#include "libarch/archive-location.h"


extern t_uchar * arch_archive_location_file (t_uchar const * archive_name);
extern t_uchar * arch_archive_location (t_uchar const * archive_name, int soft);
extern ar_archive_location arch_archive_locations (t_uchar const *official_name);
extern ar_archive_location arch_archive_locations_ext (t_uchar const *official_name, int new_only);
extern int arch_archives_archive_has_location (t_uchar const * official_name, t_uchar const * location);
extern int arch_archives_archive_has_location_ext (t_uchar const * official_name, t_uchar const * location, int new_only);
extern t_uchar * arch_archive_registry_file (t_uchar const *official_name);
extern int  arch_archives_has_registry_entry (t_uchar const *official_name);
extern t_uchar * archive_defaults_path (void);
extern void arch_delete_archive_location (t_uchar * archive_name, int force_p);
extern void arch_archives_delete_archive_location (t_uchar const *official_name, t_uchar const *location, int force);
extern void arch_registered_registered_name_archives (rel_table *where);
extern rel_table arch_registered_archives (void);
extern void arch_archives_get_archive_ini (t_uchar const *official_name, inifile_t *inifile);
extern void arch_archives_get_archive_ini_no_default (t_uchar const * official_name, inifile_t *inifile);
extern void arch_archives_save_archive_ini_no_default (t_uchar const * official_name, inifile_t *inifile);
extern t_uchar * arch_archives_signature_signing_rule_file (t_uchar const * registered_name);
extern t_uchar * arch_archives_signature_checking_rule_file (t_uchar const * registered_name);
extern void upgrade_signing_rule (inifile_t *inifile, t_uchar const *old_default_path, int is_default);
extern void upgrade_checking_rule (inifile_t *inifile, t_uchar const *old_default_path);
extern t_uchar * arch_mirrored_at_name (t_uchar const *  const archive);
extern t_uchar * arch_mirrored_from_name (t_uchar const * const archive);
extern t_uchar * arch_mirrored_at (t_uchar const * const archive);
extern t_uchar * arch_mirrored_from (t_uchar const * const archive);
extern t_uchar * arch_fs_archive_archive_version_path (t_uchar * archive_path);
extern t_uchar * arch_fs_archive_meta_info_path (t_uchar * archive_path);
extern t_uchar * arch_fs_archive_meta_info_item_path (t_uchar * archive_path, t_uchar * meta_info_name);
extern ar_archive_location locations_from_ini_values (rel_table values);
#define ARCH_REG_FAIL_NORM             0
#define ARCH_REG_FAIL_QUIET            1
#define ARCH_REG_FAIL_NOFAIL           2


#endif  /* INCLUDE__LIBARCH__ARCHIVES_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (archives.h)
 */
