// resource.cc for bbpal
//
//  Copyright (c) 1998-1999 John Kennis, jkennis@chello.nl
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// (See the included file COPYING / GPL-2.0)
//

#define _DEFAULT_DELAY		4	// Default delay for changing image
#define _DEFAULT_NUMIMAGES	2	// Default number of images for pal

#include "resource.hh"
#include "blackboxstyle.hh"

Resource::Resource(ToolWindow *toolwindow) : 
BaseResource(toolwindow) { Load(); }

Resource::~Resource() { Clean(); }

void Resource::Clean() {}

void Resource::LoadBBToolResource(void) {
	XrmValue value;
	char *value_type;

	if (XrmGetResource(resource_db, "bbpal.autoConfig",
		"Bbpal.Autoconfig", &value_type, &value)) {
			if (! strncasecmp("true", value.addr, value.size)) {
				style.auto_config = True;
			} else
				style.auto_config = False;
	} else
		style.auto_config = False;

	Frame();
	SizeAndPosition();
	PalInfo();
}

void Resource::Frame() {
	XrmValue value;
	char *value_type;

	readTexture("bbpal.frame", "Bbpal.Frame", BB_FRAME, "Toolbar",
		"slategrey", "darkslategrey",
		"Raised Gradient Vertical Bevel1", &frame.texture);

	if (XrmGetResource(resource_db, "bbpal.bevelWidth","Bbpal.BevelWidth",
		&value_type, &value)) {
			if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
				frame.bevelWidth = 4;
			else if (frame.bevelWidth == 0)
				frame.bevelWidth = 4;
	} else if (XrmGetResource(resource_db, BB_BEVELWIDTH, 
		"BevelWidth", &value_type, &value)) {
			if (sscanf(value.addr, "%u", &frame.bevelWidth) != 1)
				frame.bevelWidth = 4;
			else if (frame.bevelWidth == 0)
				frame.bevelWidth = 4;
	} else
		frame.bevelWidth = 4;
}

void Resource::SizeAndPosition() {
	XrmValue value;
	char *value_type;
	unsigned int w,h;
	char positionstring[11];

	if (!(bbtool->position)) {
		if (!(XrmGetResource(resource_db, "bbpal.position", 
			"Bbpal.Position", &value_type, &value)))
			strncpy(positionstring, "-0-0", 5);
		else
			strncpy(positionstring, value.addr, 
				strlen(value.addr) + 1);
	} else
		strncpy(positionstring, bbtool->position, 
			strlen(bbtool->position) + 1);

	position.mask=XParseGeometry(positionstring, &position.x, 
		&position.y, &w, &h);

	if (!(position.mask & XValue))
		position.x = 0;
	if (!(position.mask & YValue))
		position.y = 0;
}

void Resource::PalInfo(void) {
	XrmValue value;
	char *value_type;

	if (XrmGetResource(resource_db, "bbpal.pal.name", 
		"Bbpal.Pal.Name", &value_type, &value)) {
			int len = strlen(value.addr);
			delete [] pal.name;
			pal.name = new char[len + 1];
			memset(pal.name, 0, len + 1);
			strncpy(pal.name, value.addr, len);
			value.addr[len] = '\0';
	} else {
		fprintf(stderr, "bbpal error: cannot load pal name.");
		pal.name = NULL;
	}

	if (XrmGetResource(resource_db, "bbpal.pal.directory",
		"Bbpal.Pal.Directory", &value_type, &value)) {
			int len = strlen(value.addr);
			delete [] pal.directory;
			pal.directory = new char[len + 1];
			memset(pal.directory, 0, len + 1);
			strncpy(pal.directory, value.addr, len);
			value.addr[len] = '\0';
	} else {
		fprintf(stderr, "bbpal error: cannot load pal directory.");
		pal.directory = NULL;
	}

	if (XrmGetResource(resource_db, "bbpal.pal.delay",
		"Bbpal.Pal.Delay", &value_type, &value)) {
		if (sscanf(value.addr, "%u", &pal.delay) <= 0)
			pal.delay = _DEFAULT_DELAY;
	} else
		pal.delay = _DEFAULT_DELAY;

	if (XrmGetResource(resource_db, "bbpal.pal.numImages",
		"Bbpal.NumImages", &value_type, &value)) {
		if (sscanf(value.addr, "%u", &pal.numImages) <= 0)
			pal.numImages = _DEFAULT_NUMIMAGES;
	} else
		pal.numImages = _DEFAULT_NUMIMAGES;
}