// resource.hh for bbsload - an tool to display new mail in X11.
//
//  this program is free software; you can redistribute it and/or modify
//  it under the terms of the gnu general public license as published by
//  the free software foundation; either version 2 of the license, or
//  (at your option) any later version.
//
//  this program is distributed in the hope that it will be useful,
//  but without any warranty; without even the implied warranty of
//  merchantability or fitness for a particular purpose.  see the
//  gnu general public license for more details.
//
//  you should have received a copy of the gnu general public license
//  along with this program; if not, write to the free software
//  foundation, inc., 675 mass ave, cambridge, ma 02139, usa.
//
// (see the included file copying / gpl-2.0)
//


#ifndef __RESOURCE_HH
#define __RESOURCE_HH

#include "bbsload.hh"
#include "Baseresource.hh"

class BaseResource;

struct FRAME {
    int width;
    int height;
    BTexture texture;
    int bevelWidth;
    XFontStruct *font;
};

struct POSITION {
    int x;
    int y;
    int mask;
};

struct LABEL {
    int width;
    int width0, width1, width2, width3;
    int height;
    BTexture texture;
    bool transparent;
    XFontStruct *font;
    BColor running_textColor;
    BColor task_textColor;
    BColor seperator_textColor;
    BColor task_boring_textColor;
    BColor load1m_textColor;
    BColor load5m_textColor;
    BColor load15m_textColor;
    BColor memUsed_textColor;
    BColor swapUsed_textColor;
    BColor totalUsed_textColor;
};

struct GAUGE {
    int width;
    BTexture active_texture;
    BTexture inactive_texture;
    BTexture background_texture;
    int left_step_width;
    int right_step_width;
    double ratio;
    int number_of_bars;
    bool background;
    float max_load;
    bool tickmarks;
    bool use_simple_color;
    bool levels_defined;
    float *level;
    BTexture *segment_texture;
    
};

struct SHOW {
    bool running_counter;
    bool task_counter;
    bool label;
    bool loadbar;
    bool load1m;
    bool load5m;
    bool load15m;
    bool usercpu;
    bool nicecpu;
    bool systemcpu;
    bool idlecpu;
    bool label_load1m;
    bool label_load5m;
    bool label_load15m;
    bool label_usercpu;
    bool label_nicecpu;
    bool label_systemcpu;
    bool label_idlecpu;
    bool totalused;
    bool swapused;
    bool memused;
    bool label_totalused;
    bool label_swapused;
    bool label_memused;
    bool vertical;
};

struct REPORT {
    unsigned int check_delay;
};

class Resource : public BaseResource
{

public:
    Resource::Resource(ToolWindow *);
    Resource::~Resource(void);

    struct FRAME frame;
    struct LABEL label;
    struct POSITION position;
    struct GAUGE gauge;
    struct SHOW show;
    struct REPORT report;
 protected:
  	virtual void  LoadBBToolResource(void);

private:
    void Frame(void);
    void SizeAndPosition(void);
    void CheckSettings(void);
    void Label(void);
    void Show(void);
    void LoadBar(void);
    bool showLabel(char *,char *,bool);
    bool showGauge(char *,char *,bool);
    void Clean(void);
};
#endif /* __RESOURCE_HH */
