/******************************************************************************/
/*                                                                            */
/* Broadcom BCM5700 Linux Network Driver, Copyright (c) 2000 Broadcom         */
/* Corporation.                                                               */
/* All rights reserved.                                                       */
/*                                                                            */
/* This program is free software; you can redistribute it and/or modify       */
/* it under the terms of the GNU General Public License as published by       */
/* the Free Software Foundation, located in the file LICENSE.                 */
/*                                                                            */
/* History:                                                                   */
/******************************************************************************/

#if INCLUDE_5701_AX_FIX

#include "mm.h"
#include "5701rls.h"

#define  T3_RX_CPU_ID    0
#define T3_TX_CPU_ID    1
#define T3_RX_CPU_SPAD_ADDR  0x30000
#define T3_RX_CPU_SPAD_SIZE  0x4000
#define T3_TX_CPU_SPAD_ADDR  0x34000
#define T3_TX_CPU_SPAD_SIZE  0x4000

/* Function protocol types */
STATIC LM_STATUS LM_ResetCpu(PLM_DEVICE_BLOCK pDevice,LM_UINT32 cpu_number);

LM_STATUS LM_LoadRlsFirmware(PLM_DEVICE_BLOCK pDevice)
{
  int i;
  LM_UINT32 address;

  if (LM_ResetCpu(pDevice,T3_RX_CPU_ID) != LM_STATUS_SUCCESS)
    {
      DbgMessage(FATAL, ("Failed Resetting Rx CPU.\n"));
      DbgBreak();
      return LM_STATUS_FAILURE;
    }

  /* First of all clear scrach pad memory */
  for (i= 0; i < T3_RX_CPU_SPAD_SIZE; i+=4)
    {
      LM_RegWrInd(pDevice,T3_RX_CPU_SPAD_ADDR+i,0);
    }

  /* Rx-Cpu */
  REG_WR(pDevice,rxCpu.reg.state, 0xffffffff);
  REG_WR(pDevice,rxCpu.reg.mode, REG_RD(pDevice,rxCpu.reg.mode)| CPU_MODE_HALT);
  /* Copy code first */
  address = T3_RX_CPU_SPAD_ADDR + (t3FwTextAddr & 0xffff);
  for (i= 0; i <= t3FwTextLen; i+=4)
    {
      LM_RegWrInd(pDevice,address+i,t3FwText[i/4]);
    }

  address = T3_RX_CPU_SPAD_ADDR + (t3FwRodataAddr & 0xffff);
  for (i= 0; i <= t3FwRodataLen; i+=4)
    {
      LM_RegWrInd(pDevice,address+i,t3FwRodata[i/4]);
    }

  address = T3_RX_CPU_SPAD_ADDR + (t3FwDataAddr & 0xffff);
  for (i= 0; i <= t3FwDataLen; i+=4)
    {
      LM_RegWrInd(pDevice,address+i,t3FwData[i/4]);
    }

  /* Tx-Cpu */
  if (LM_ResetCpu(pDevice,T3_TX_CPU_ID) != LM_STATUS_SUCCESS)
    {
      DbgMessage(FATAL, ("Failed Resetting Tx CPU.\n"));
      DbgBreak();
      return LM_STATUS_FAILURE;
    }

  /* First of all clear scrach pad memory */
  for (i= 0; i < T3_TX_CPU_SPAD_SIZE; i+=4)
    {
      LM_RegWrInd(pDevice,T3_TX_CPU_SPAD_ADDR+i,0);
    }

  REG_WR(pDevice,txCpu.reg.state, 0xffffffff);
  REG_WR(pDevice,txCpu.reg.mode,REG_RD(pDevice,txCpu.reg.mode) | 
	 CPU_MODE_HALT);
  address = T3_TX_CPU_SPAD_ADDR + (t3FwTextAddr & 0xffff);
  for (i= 0; i <= t3FwTextLen; i+=4)
    {
      LM_RegWrInd(pDevice,address+i,t3FwText[i/4]);
    }

  address = T3_TX_CPU_SPAD_ADDR + (t3FwRodataAddr & 0xffff);
  for (i= 0; i <= t3FwRodataLen; i+=4)
    {
      LM_RegWrInd(pDevice,address+i,t3FwRodata[i/4]);
    }

  address = T3_TX_CPU_SPAD_ADDR + (t3FwDataAddr & 0xffff);
  for (i= 0; i <= t3FwDataLen; i+=4)
    {
      LM_RegWrInd(pDevice,address+i,t3FwData[i/4]);
    }

  /* Start Rx CPU */
  REG_WR(pDevice,rxCpu.reg.state, 0xffffffff);
  REG_WR(pDevice,rxCpu.reg.PC,t3FwTextAddr);
  for (i = 0 ; i < 5; i++)
    {
      if (t3FwTextAddr == REG_RD(pDevice,rxCpu.reg.PC))
	break;

      REG_WR(pDevice,rxCpu.reg.state, 0xffffffff);
      REG_WR(pDevice,rxCpu.reg.mode,CPU_MODE_HALT);
      REG_WR(pDevice,rxCpu.reg.PC,t3FwTextAddr);
      MM_Wait(1000);
    }

  REG_WR(pDevice,rxCpu.reg.state, 0xffffffff);
  REG_WR(pDevice,rxCpu.reg.mode, 0);

  return LM_STATUS_SUCCESS;
}

STATIC LM_STATUS LM_ResetCpu(PLM_DEVICE_BLOCK pDevice,LM_UINT32 cpu_number)
{
  LM_UINT32 i;

  if (cpu_number == T3_RX_CPU_ID)
    {
      REG_WR(pDevice,rxCpu.reg.state, 0xffffffff);
      REG_WR(pDevice,rxCpu.reg.mode,CPU_MODE_RESET);

      for (i = 0 ; i < 10000; i++)
        {
          if (!(REG_RD(pDevice,rxCpu.reg.mode) & CPU_MODE_RESET))
            break;
        }

      REG_WR(pDevice,txCpu.reg.state, 0xffffffff);
      REG_WR(pDevice,rxCpu.reg.mode,CPU_MODE_RESET);
      MM_Wait(10);
    }
  else
    {
      REG_WR(pDevice,txCpu.reg.state, 0xffffffff);
      REG_WR(pDevice,txCpu.reg.mode,CPU_MODE_RESET);
      for (i = 0 ; i < 10000; i++)
        {
          if (!(REG_RD(pDevice,txCpu.reg.mode) & CPU_MODE_RESET))
            break;

	  REG_WR(pDevice,txCpu.reg.state, 0xffffffff);
          REG_WR(pDevice,txCpu.reg.mode,CPU_MODE_RESET);
	  MM_Wait(10);
        }
    }

  return (( i == 10000) ? LM_STATUS_FAILURE : LM_STATUS_SUCCESS);
}

#endif /* INCLUDE_5701_AX_FIX */
