
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsesong.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsesong.h>
#include <bse/bsebus.h>
#include <bse/bsepart.h>
#include <bse/bsetrack.h>
#include "bsemidireceiver.h"
#include "bseundostack.h"
#include "bseproject.h"
#include "gslcommon.h"
#include "bseengine.h"
#include <string.h>

#line 34 "bsesong.proc"

/* --- create-bus --- */
static void
create_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 35 "bsesong.proc"
 {
#line 37 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 41 "bsesong.proc"
}  }
static BseErrorType
#line 41 "bsesong.proc"
create_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 44 "bsesong.proc"
{
#line 45 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseUndoStack *ustack;
  BseItem *child = NULL;

#line 51 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 55 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      ustack = bse_item_undo_open (self, "create-bus");
      child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_BUS, NULL);
      bse_item_push_undo_proc (self, "remove-bus", child);
      bse_item_undo_close (ustack);
    }

#line 66 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return error;
}

/* --- remove-bus --- */
static void
remove_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 72 "bsesong.proc"
 {
#line 74 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 78 "bsesong.proc"
}  }
static BseErrorType
#line 78 "bsesong.proc"
remove_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 81 "bsesong.proc"
{
#line 82 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 87 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_BUS (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 91 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 97 "bsesong.proc"
      
      bse_item_set (child, "master-output", FALSE, NULL);
#line 99 "bsesong.proc"
      
#line 100 "bsesong.proc"
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);     
#line 101 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-bus", child);
#line 103 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 105 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- ensure-master-bus --- */
static void
ensure_master_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 112 "bsesong.proc"
 {
#line 114 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 118 "bsesong.proc"
}  }
static BseErrorType
#line 118 "bsesong.proc"
ensure_master_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 121 "bsesong.proc"
{
#line 122 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseSource *child;

#line 126 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 130 "bsesong.proc"
  
  child = bse_song_ensure_master (self);

#line 133 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- get-master-bus --- */
static void
get_master_bus_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 139 "bsesong.proc"
 {
#line 141 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("bus", NULL, NULL,
				 BSE_TYPE_BUS, SFI_PARAM_STANDARD);
#line 145 "bsesong.proc"
}  }
static BseErrorType
#line 145 "bsesong.proc"
get_master_bus_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 148 "bsesong.proc"
{
#line 149 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);

#line 152 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 156 "bsesong.proc"
  
  BseBus *bus = bse_song_find_master (self);

#line 159 "bsesong.proc"
  
  bse_value_set_object (out_values++, bus);
  
  return BSE_ERROR_NONE;
}

static const gchar*
orphans_track_name (void)
{
#line 168 "bsesong.proc"
  
  return _("Orphan Parts");
}

static BseTrack*
bse_song_ensure_orphans_track_noundo (BseSong *self)
{
  SfiRing *ring;
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *track = ring->data;
      gboolean muted = FALSE;
      g_object_get (track, "muted", &muted, NULL);
#line 183 "bsesong.proc"
      if (muted && g_object_get_data (track, "BseSong-orphan-track") == bse_song_ensure_orphans_track_noundo) 
        return track;
    }
  gpointer child = bse_container_new_child_bname (BSE_CONTAINER (self), BSE_TYPE_TRACK, orphans_track_name(), NULL);
#line 187 "bsesong.proc"
  g_object_set (child, "muted", TRUE, NULL); 
#line 188 "bsesong.proc"
  g_object_set_data (child, "BseSong-orphan-track", bse_song_ensure_orphans_track_noundo); 
  return child;
}

static BseTrack*
bse_song_find_first_track (BseSong *self,
                           BsePart *part)
{
  SfiRing *ring;
#line 197 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *track = ring->data;
      guint start;
      if (bse_track_find_part (track, part, &start))
        return track;
    }
  return NULL;
}

/* --- ensure-track-links --- */
static void
ensure_track_links_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 208 "bsesong.proc"
 {
#line 210 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
#line 212 "bsesong.proc"
}  }
static BseErrorType
#line 212 "bsesong.proc"
ensure_track_links_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 215 "bsesong.proc"
{
#line 216 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);

#line 219 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 223 "bsesong.proc"
  
  gboolean clear_undo = FALSE;
  SfiRing *ring;
  for (ring = self->parts; ring; ring = sfi_ring_walk (ring, self->parts))
    if (!bse_song_find_first_track (self, ring->data))
      {
        BseTrack *track = bse_song_ensure_orphans_track_noundo (self);
        bse_item_exec_void (track, "insert-part", bse_track_get_last_tick (track), ring->data);
        clear_undo = TRUE;
      }
  if (clear_undo)
    {
      BseProject *project = bse_item_get_project (BSE_ITEM (self));
      if (project)
        bse_project_clear_undo (project);
    }
  
  return BSE_ERROR_NONE;
}

/* --- create-part --- */
static void
create_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 243 "bsesong.proc"
 {
#line 245 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", NULL, NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("part", NULL, NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 249 "bsesong.proc"
}  }
static BseErrorType
#line 249 "bsesong.proc"
create_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 252 "bsesong.proc"
{
#line 253 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 258 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 262 "bsesong.proc"
  
  ustack = bse_item_undo_open (self, "create-part");
  child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_PART, NULL);
  bse_item_push_undo_proc (self, "remove-part", child);
  bse_item_undo_close (ustack);
  
#line 268 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-part --- */
static void
remove_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 274 "bsesong.proc"
 {
#line 276 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
#line 280 "bsesong.proc"
}  }
static BseErrorType
#line 280 "bsesong.proc"
remove_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 283 "bsesong.proc"
{
#line 284 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 289 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (child) || BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 293 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 299 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 301 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-part", child);
#line 303 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 305 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- create-track --- */
static void
create_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 312 "bsesong.proc"
 {
#line 314 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 318 "bsesong.proc"
}  }
static BseErrorType
#line 318 "bsesong.proc"
create_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 321 "bsesong.proc"
{
#line 322 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  BseItem *child = NULL;

#line 327 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 331 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "create-track");
      child = bse_container_new_child (BSE_CONTAINER (self), BSE_TYPE_TRACK, NULL);
      bse_item_push_undo_proc (self, "remove-track", child);
      bse_item_undo_close (ustack);
    }

#line 342 "bsesong.proc"
  
  bse_value_set_object (out_values++, child);
  
  return error;
}

/* --- remove-track --- */
static void
remove_track_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 348 "bsesong.proc"
 {
#line 350 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 354 "bsesong.proc"
}  }
static BseErrorType
#line 354 "bsesong.proc"
remove_track_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 357 "bsesong.proc"
{
#line 358 "bsesong.proc"
  
  BseSong *self  = bse_value_get_object (in_values++);
  BseItem *child = bse_value_get_object (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 363 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (child) ||
      BSE_ITEM (child)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 368 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self))
    error = BSE_ERROR_SOURCE_BUSY;
  else
    {
      BseUndoStack *ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 374 "bsesong.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 376 "bsesong.proc"
      
      bse_item_push_redo_proc (self, "remove-track", child);
#line 378 "bsesong.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 380 "bsesong.proc"
      
      bse_item_undo_close (ustack);
    }

  return error;
}

/* --- find-track-for-part --- */
static void
find_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 387 "bsesong.proc"
 {
#line 389 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 395 "bsesong.proc"
}  }
static BseErrorType
#line 395 "bsesong.proc"
find_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 398 "bsesong.proc"
{
#line 399 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);
  BseTrack *track = NULL;
  guint tick = 0;
  SfiRing *ring;

#line 406 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 411 "bsesong.proc"
  
  for (ring = self->tracks_SL; ring; ring = sfi_ring_walk (ring, self->tracks_SL))
    {
      BseTrack *test_track = ring->data;
      guint start;
      if (bse_track_find_part (test_track, part, &start) &&
	  (!track || start < tick))
	{
	  track = test_track;
	  tick = start;
	}
    }

#line 424 "bsesong.proc"
  
  bse_value_set_object (out_values++, track);
  
  return BSE_ERROR_NONE;
}

/* --- find-any-track-for-part --- */
static void
find_any_track_for_part_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 430 "bsesong.proc"
 {
#line 432 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("part", "Part", NULL,
				 BSE_TYPE_PART, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
#line 438 "bsesong.proc"
}  }
static BseErrorType
#line 438 "bsesong.proc"
find_any_track_for_part_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 441 "bsesong.proc"
{
#line 442 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  BsePart *part = bse_value_get_object (in_values++);

#line 446 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_PART (part) ||
      BSE_ITEM (part)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 451 "bsesong.proc"
  
  bse_value_set_object (out_values++, bse_song_find_first_track (self, part));
  
  return BSE_ERROR_NONE;
}

/* --- synthesize-note --- */
static void
synthesize_note_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 457 "bsesong.proc"
 {
#line 459 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL,
				 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("track", "Track", NULL,
				 BSE_TYPE_TRACK, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("duration", "Tick Duration", NULL,
			 1, 1, BSE_PART_MAX_TICK, 384, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_pspec_note_simple ("note", "Note", NULL,
				 SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_fine_tune ("fine_tune", "Fine Tune", "Fine tune in cents per semitone");
  *(in_pspecs++)    = sfi_pspec_real ("velocity", "Velocity", NULL,
			  1.0, 0, 1.0, 0.01,
			  SFI_PARAM_STANDARD ":scale");
#line 471 "bsesong.proc"
}  }
static BseErrorType
#line 471 "bsesong.proc"
synthesize_note_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 474 "bsesong.proc"
{
#line 475 "bsesong.proc"
  
  BseSong *self      = bse_value_get_object (in_values++);
  BseTrack *track    = bse_value_get_object (in_values++);
  guint    duration  = sfi_value_get_int (in_values++);
  gint     note      = sfi_value_get_note (in_values++);
  gint     fine_tune = sfi_value_get_int (in_values++);
  gfloat   velocity  = sfi_value_get_real (in_values++);
  
#line 483 "bsesong.proc"
  
  if (!BSE_IS_SONG (self) || !BSE_IS_TRACK (track) ||
      BSE_ITEM (track)->parent != BSE_ITEM (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 488 "bsesong.proc"
  
  if (BSE_SOURCE_PREPARED (self) && self->midi_receiver_SL)
    {
      gfloat freq = BSE_KAMMER_FREQUENCY *
		    BSE_SEMITONE_FACTOR (note) *
		    BSE_FINE_TUNE_FACTOR (fine_tune);
      SfiTime tstamp = gsl_tick_stamp () + bse_engine_block_size () * 2;
      BseMidiEvent *eon, *eoff;
      eon  = bse_midi_event_note_on (track->midi_channel_SL, tstamp, freq, velocity);
      eoff = bse_midi_event_note_off (track->midi_channel_SL, tstamp + duration, freq);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eon);
      bse_midi_receiver_push_event (self->midi_receiver_SL, eoff);
      bse_midi_receiver_process_events (self->midi_receiver_SL, tstamp + duration);
      bse_project_keep_activated (BSE_PROJECT (BSE_ITEM (self)->parent), tstamp + duration);
    }
  
  return BSE_ERROR_NONE;
}

/* --- get-timing --- */
static void
get_timing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 507 "bsesong.proc"
 {
#line 509 "bsesong.proc"
  *(in_pspecs++)    = bse_param_spec_object ("song", "Song", NULL, BSE_TYPE_SONG, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("tick", "Tick", "Tick to retrieve timing info about", 0, 0, G_MAXINT, 384, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("timing", "Timing", "Song Timing", BSE_TYPE_SONG_TIMING, SFI_PARAM_STANDARD);
#line 512 "bsesong.proc"
}  }
static BseErrorType
#line 512 "bsesong.proc"
get_timing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 515 "bsesong.proc"
{
#line 516 "bsesong.proc"
  
  BseSong *self = bse_value_get_object (in_values++);
  SfiInt   tick = sfi_value_get_int (in_values++);
  BseSongTiming timing = { 0, };

#line 521 "bsesong.proc"
  
  if (!BSE_IS_SONG (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 525 "bsesong.proc"
  
  bse_song_get_timing (self, tick, &timing);

#line 528 "bsesong.proc"
  
  bse_value_set_boxed (out_values++, &timing);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_create_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new mixer bus for a Song.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_bus = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSong+create-bus", 
    NULL,
    "/Methods/BseSong/General/Create Bus",
    NULL,
    __enode_create_bus__fill_strings,
  },
  0, create_bus_setup, create_bus_exec, 
};
static void
__enode_remove_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a mixer bus from a Song.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_bus = {
  { (BseExportNode*) &__enode_create_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-bus", 
    NULL,
    "/Methods/BseSong/General/Remove Bus",
    NULL,
    __enode_remove_bus__fill_strings,
  },
  0, remove_bus_setup, remove_bus_exec, 
};
static void
__enode_ensure_master_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve master output bus of a song, will create one if it doesn't exist.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ensure_master_bus = {
  { (BseExportNode*) &__enode_remove_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+ensure-master-bus", 
    NULL,
    "/Methods/BseSong/General/Ensure Master Bus",
    NULL,
    __enode_ensure_master_bus__fill_strings,
  },
  0, ensure_master_bus_setup, ensure_master_bus_exec, 
};
static void
__enode_get_master_bus__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve master output bus of a song if it exists.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_master_bus = {
  { (BseExportNode*) &__enode_ensure_master_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+get-master-bus", 
    NULL,
    "/Methods/BseSong/General/Get Master Bus",
    NULL,
    __enode_get_master_bus__fill_strings,
  },
  0, get_master_bus_setup, get_master_bus_exec, 
};
static void
__enode_ensure_track_links__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Ensure that each part in a song is inserted into at least one track.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ensure_track_links = {
  { (BseExportNode*) &__enode_get_master_bus, BSE_EXPORT_NODE_PROC,
    "BseSong+ensure-track-links", 
    NULL,
    "/Methods/BseSong/General/Ensure Track Links",
    NULL,
    __enode_ensure_track_links__fill_strings,
  },
  0, ensure_track_links_setup, ensure_track_links_exec, 
};
static void
__enode_create_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new Part in a Song.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_part = {
  { (BseExportNode*) &__enode_ensure_track_links, BSE_EXPORT_NODE_PROC,
    "BseSong+create-part", 
    NULL,
    "/Methods/BseSong/General/Create Part",
    NULL,
    __enode_create_part__fill_strings,
  },
  0, create_part_setup, create_part_exec, 
};
static void
__enode_remove_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a Part from a Song.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_part = {
  { (BseExportNode*) &__enode_create_part, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-part", 
    NULL,
    "/Methods/BseSong/General/Remove Part",
    NULL,
    __enode_remove_part__fill_strings,
  },
  0, remove_part_setup, remove_part_exec, 
};
static void
__enode_create_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Create a new Track for a Song.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_track = {
  { (BseExportNode*) &__enode_remove_part, BSE_EXPORT_NODE_PROC,
    "BseSong+create-track", 
    NULL,
    "/Methods/BseSong/General/Create Track",
    NULL,
    __enode_create_track__fill_strings,
  },
  0, create_track_setup, create_track_exec, 
};
static void
__enode_remove_track__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Delete a Track from a Song.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_remove_track = {
  { (BseExportNode*) &__enode_create_track, BSE_EXPORT_NODE_PROC,
    "BseSong+remove-track", 
    NULL,
    "/Methods/BseSong/General/Remove Track",
    NULL,
    __enode_remove_track__fill_strings,
  },
  0, remove_track_setup, remove_track_exec, 
};
static void
__enode_find_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Find a track suitable for playing notes of a given part.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_track_for_part = {
  { (BseExportNode*) &__enode_remove_track, BSE_EXPORT_NODE_PROC,
    "BseSong+find-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Track For Part",
    NULL,
    __enode_find_track_for_part__fill_strings,
  },
  0, find_track_for_part_setup, find_track_for_part_exec, 
};
static void
__enode_find_any_track_for_part__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Find the first track that contains part, suitable to check for orphan parts.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_find_any_track_for_part = {
  { (BseExportNode*) &__enode_find_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+find-any-track-for-part", 
    NULL,
    "/Methods/BseSong/General/Find Any Track For Part",
    NULL,
    __enode_find_any_track_for_part__fill_strings,
  },
  0, find_any_track_for_part_setup, find_any_track_for_part_exec, 
};
static void
__enode_synthesize_note__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Synthesize a note on a song of an active project.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_synthesize_note = {
  { (BseExportNode*) &__enode_find_any_track_for_part, BSE_EXPORT_NODE_PROC,
    "BseSong+synthesize-note", 
    NULL,
    "/Methods/BseSong/General/Synthesize Note",
    NULL,
    __enode_synthesize_note__fill_strings,
  },
  0, synthesize_note_setup, synthesize_note_exec, 
};
static void
__enode_get_timing__fill_strings (BseExportStrings *es)
{
  es->blurb = _("Retrieve song timing information at a specific tick.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_timing = {
  { (BseExportNode*) &__enode_synthesize_note, BSE_EXPORT_NODE_PROC,
    "BseSong+get-timing", 
    NULL,
    "/Methods/BseSong/General/Get Timing",
    NULL,
    __enode_get_timing__fill_strings,
  },
  0, get_timing_setup, get_timing_exec, 
};
BseExportNode* bse__builtin_init_bsesong_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsesong_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_get_timing;
}

/*
 * Generated data ends here
 */
