/* Anti-Web HTTPD */
/* Hardcore Software */
/*
This software is Copyright (C) 2001-2004 By Hardcore Software and
others. The software is distributed under the terms of the GNU General
Public License. See the file 'COPYING' for more details.
*/


#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <time.h>
#include <string.h>
#include <stdlib.h>

#include "aw3.h"




void addtoservers(int sd) {
  struct serverstruct *tp;

  tp = (struct serverstruct *) malloc(sizeof(struct serverstruct));
  if (tp == NULL) {
    fprintf(stderr, "Serious memory error...\n");
    exit(0);
  }

  tp->next = servers;
  tp->sd = sd;

  servers = tp;

  return;
}



void selectloop() {
  fd_set rfds, wfds;
  struct connstruct *tp, *to;
  struct serverstruct *sp;
  int rnum, wnum, active;
  int currtime;

  while(1) {   // MAIN SELECT LOOP
    FD_ZERO(&rfds);
    FD_ZERO(&wfds);
    rnum = wnum = -1;

    // Add the listening sockets
    sp = servers;
    while(sp != NULL) {
      FD_SET(sp->sd, &rfds);
      if (sp->sd > rnum) rnum = sp->sd;
      sp = sp->next;
    }

    // Add the established sockets
    tp = usedconns;
    currtime = time(NULL);
    while(tp != NULL) {

      if (istimedout(tp, currtime)) {
        to = tp;
        tp = tp->next;
        removeconnection(to);
        continue;
      }

      if (tp->state == STATE_WANT_TO_READ_HEAD) {
        FD_SET(tp->networkdesc, &rfds);
        if (tp->networkdesc > rnum) rnum = tp->networkdesc;
      }
      if (tp->state == STATE_WANT_TO_SEND_HEAD) {
        FD_SET(tp->networkdesc, &wfds);
        if (tp->networkdesc > wnum) wnum = tp->networkdesc;
      }
      if (tp->state == STATE_WANT_TO_READ_FILE) {
        FD_SET(tp->filedesc, &rfds);
        if (tp->filedesc > rnum) rnum = tp->filedesc;
      }
      if (tp->state == STATE_WANT_TO_SEND_FILE) {
        FD_SET(tp->networkdesc, &wfds);
        if (tp->networkdesc > wnum) wnum = tp->networkdesc;
      }
      if (tp->state == STATE_DOING_DIR) {
        FD_SET(tp->networkdesc, &wfds);
        if (tp->networkdesc > wnum) wnum = tp->networkdesc;
      }
      tp = tp->next;
    }

    //active = select(4, &rfds, &wfds, NULL, NULL);
    active = select(wnum > rnum ? wnum+1 : rnum+1,
                    rnum != -1 ? &rfds : NULL,
                    wnum != -1 ? &wfds : NULL,
                    NULL, NULL);

    // Handle the listening sockets
    sp = servers;
    while(active > 0 && sp != NULL) {
      if (FD_ISSET(sp->sd, &rfds)) {
        handlenewconnection(sp->sd);
        active--;
      }
      sp = sp->next;
    }

    // Handle the established sockets
    tp = usedconns;
    currtime = time(NULL);
    while(active > 0 && tp != NULL) {
      to = tp;
      tp = tp->next;

      if (to->state == STATE_WANT_TO_READ_HEAD)
        if (FD_ISSET(to->networkdesc, &rfds)) {
          updatetimeout(to, currtime);
          active--;
          procreadhead(to);
        } 
      if (to->state == STATE_WANT_TO_SEND_HEAD)
        if (FD_ISSET(to->networkdesc, &wfds)) {
          updatetimeout(to, currtime);
          active--;
          procsendhead(to);
        } 
      if (to->state == STATE_WANT_TO_READ_FILE)
        if (FD_ISSET(to->filedesc, &rfds)) {
          updatetimeout(to, currtime);
          active--;
          procreadfile(to);
        } 
      if (to->state == STATE_WANT_TO_SEND_FILE)
        if (FD_ISSET(to->networkdesc, &wfds)) {
          updatetimeout(to, currtime);
          active--;
          procsendfile(to);
        }
      if (to->state == STATE_DOING_DIR)
        if (FD_ISSET(to->networkdesc, &wfds)) {
          updatetimeout(to, currtime);
          active--;
          procdodir(to);
        }
    }


  }  // MAIN SELECT LOOP

}
