/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/

#ifndef INCLUDED_SCRIPTURECHECKSDISPLAYRESULTSBROWSER_H
#define INCLUDED_SCRIPTURECHECKSDISPLAYRESULTSBROWSER_H


#include "libraries.h"
#include <glib.h>
#include <gtk/gtk.h>
#include "dialogcheck.h"


class ScriptureChecksDisplayResultsBrowser
{
public:
  ScriptureChecksDisplayResultsBrowser (CheckDialogType displaywhat, const ustring& filename);
  ~ScriptureChecksDisplayResultsBrowser ();
private:
  bool displayusfm;
  bool displaycharacters;
  vector<ustring> lines;
  ustring current_value;
  ustring usfm;
  ustring count;
  ustring character;
  ustring decimal_entity;
  ustring hexadecimal_entity;
  static void start_element_handler  (GMarkupParseContext *context,
                                      const gchar         *element_name,
                                      const gchar        **attribute_names,
                                      const gchar        **attribute_values,
                                      gpointer             user_data,
                                      GError             **error);
  void start_element_handler (const gchar         *element_name);
  static void end_element_handler    (GMarkupParseContext *context,
                                      const gchar         *element_name,
                                      gpointer             user_data,
                                      GError             **error);
  void end_element_handler   (const gchar         *element_name);
  static void text_handler           (GMarkupParseContext *context,
                                      const gchar         *text,
                                      gsize                text_len,
                                      gpointer             user_data,
                                      GError             **error);
  void text_handler          (const gchar         *text);
  static void passthrough_handler    (GMarkupParseContext *context,
                                      const gchar         *passthrough_text,
                                      gsize                text_len,
                                      gpointer             user_data,
                                      GError             **error);
  static void error_handler          (GMarkupParseContext *context,
                                      GError              *error,
                                      gpointer             user_data);
};


#endif
