/*
** Copyright (C) 2003-2006 Teus Benschop.
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**  
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**  
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**  
*/


#include "dialogscreenlayout.h"
#include "help.h"


ScreenLayoutDialog::ScreenLayoutDialog (int dummy)
{
  screenlayoutdialog = gtk_dialog_new ();
  gtk_window_set_title (GTK_WINDOW (screenlayoutdialog), "Screen Layout");
  gtk_window_set_position (GTK_WINDOW (screenlayoutdialog), GTK_WIN_POS_CENTER_ON_PARENT);
  gtk_window_set_modal (GTK_WINDOW (screenlayoutdialog), TRUE);
  gtk_window_set_destroy_with_parent (GTK_WINDOW (screenlayoutdialog), TRUE);

  dialog_vbox1 = GTK_DIALOG (screenlayoutdialog)->vbox;
  gtk_widget_show (dialog_vbox1);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), vbox1, TRUE, TRUE, 0);

  GSList *radiobutton_tools_right_group = NULL;

  radiobutton_tools_right = gtk_radio_button_new_with_mnemonic (NULL, "Tools Area at the _right side");
  gtk_widget_show (radiobutton_tools_right);
  gtk_box_pack_start (GTK_BOX (vbox1), radiobutton_tools_right, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_tools_right), radiobutton_tools_right_group);
  radiobutton_tools_right_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton_tools_right));

  radiobutton_tools_left = gtk_radio_button_new_with_mnemonic (NULL, "Tools Area at the _left side");
  gtk_widget_show (radiobutton_tools_left);
  gtk_box_pack_start (GTK_BOX (vbox1), radiobutton_tools_left, FALSE, FALSE, 0);
  gtk_radio_button_set_group (GTK_RADIO_BUTTON (radiobutton_tools_left), radiobutton_tools_right_group);
  radiobutton_tools_right_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (radiobutton_tools_left));

  dialog_action_area1 = GTK_DIALOG (screenlayoutdialog)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  help_button (dialog_action_area1, NULL, NULL);

  cancelbutton1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (cancelbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (screenlayoutdialog), cancelbutton1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (cancelbutton1, GTK_CAN_DEFAULT);

  okbutton1 = gtk_button_new_from_stock ("gtk-ok");
  gtk_widget_show (okbutton1);
  gtk_dialog_add_action_widget (GTK_DIALOG (screenlayoutdialog), okbutton1, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (okbutton1, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) okbutton1, "clicked",
                    G_CALLBACK (on_okbutton1_clicked),
                    gpointer(this));

  gtk_widget_grab_default (okbutton1);

  GeneralConfiguration configuration (0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (radiobutton_tools_left), configuration.tools_area_left ());
}


ScreenLayoutDialog::~ScreenLayoutDialog ()
{
  gtk_widget_destroy (screenlayoutdialog);
}


int ScreenLayoutDialog::run()
{
  return gtk_dialog_run (GTK_DIALOG (screenlayoutdialog));
}


void ScreenLayoutDialog::on_okbutton1_clicked (GtkButton *button, gpointer user_data)
{
  ((ScreenLayoutDialog *) user_data)->on_ok ();
}

void ScreenLayoutDialog::on_ok ()
{
  GeneralConfiguration configuration (0);
  configuration.tools_area_left_set (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (radiobutton_tools_left)));
}
