;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/cee/cee-hook.el                */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Nov 17 08:49:24 1998                          */
;*    Last change :  Wed Aug  2 09:32:51 2000 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The CEE hook that sets up all the CEE configuration.             */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'cee-hook)
(require 'font-lock)
(require 'cee-indent)
(require 'cee-keymap)
(require 'cee-toolbar)
(require 'cee-flock)
(require 'ude-autoload)
(require 'ude-config)
(require 'ude-custom)
(require 'dbg-autoload)

;*---------------------------------------------------------------------*/
;*    cee-docline ...                                                  */
;*---------------------------------------------------------------------*/
(defun cee-docline ()
  (interactive)
  (setq ude-info-file-list cee-info-file-list)
  (ude-info-docline (cee-font-lock-get-info-keywords)))

;*---------------------------------------------------------------------*/
;*    cee-docline-init ...                                             */
;*    -------------------------------------------------------------    */
;*    Initialize the docline system, that is, tell Ude to use          */
;*    info with the Bigloo page.                                       */
;*---------------------------------------------------------------------*/
(defun cee-docline-init ()
  (setq ude-docline (function ude-info-docline)))
  
;*---------------------------------------------------------------------*/
;*    cee-hook ...                                                     */
;*---------------------------------------------------------------------*/
(defun cee-hook ()
  ;; we setup the project root directory
  (ude-auto-set-root-directory)
  ;; docline initialization
  (cee-docline-init)
  ;; the key binding
  (cee-keymap-init)
  ;; parenthesis blinking init
  (ude-paren-init)
  ;; profiling
  (setq ude-profile-highlight-buffer 'cee-profile-highlight-buffer)
  ;; starting font-lock
  (if ude-font-lock-p
      (font-lock-mode t))
  ;; the toolbar
  (cee-toolbar-init)
  ;; the cee hook
  (run-hooks 'cee-hook))
 
