;*=====================================================================*/
;*    serrano/prgm/project/bigloo/bmacs/ude/ude-about.el               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Dec 11 18:12:37 1998                          */
;*    Last change :  Fri Dec 11 18:27:05 1998 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The ude about implementation                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(provide 'ude-about)

;*---------------------------------------------------------------------*/
;*    ude-about-insert-xpm ...                                         */
;*---------------------------------------------------------------------*/
(defun ude-about-insert-xpm (buffer xpm)
  (set-extent-begin-glyph (make-extent (point) (point)) (make-glyph xpm)))

;*---------------------------------------------------------------------*/
;*    ude-about-make-junk-frame ...                                    */
;*---------------------------------------------------------------------*/
(defun ude-about-make-junk-frame ()
  (let ((window-min-height 1)
	(window-min-width 1))
    (save-excursion
      (set-buffer (generate-new-buffer "*junk-frame-buffer*"))
      (prog1
	  (make-frame '(minibuffer t initially-unmapped t width 1 height 1))
	(rename-buffer " *junk-frame-buffer*" t)))))

;*---------------------------------------------------------------------*/
;*    ude-about-make-frame ...                                         */
;*---------------------------------------------------------------------*/
(defun ude-about-make-frame (x y msg xpm)
  (save-excursion
    (let ((window-min-height 1)
	  (window-min-width 1)
	  (bg-color (or (x-get-resource "backgroundToolBarColor"
					"BackgroundToolBarColor"
					'string
					'global
					(selected-device)
					t)
			"grey75"))
	  (buffer (get-buffer-create " *ude-about-buffer*"))
	  (frame nil))
      (set-buffer buffer)
      (ude-about-insert-xpm (current-buffer) xpm)
      (insert "\n")
      (insert msg)
      (set-buffer-menubar nil)
      (setq frame (make-frame (list
			       '(initially-unmapped . t)
			       ;; try to evade frame decorations
			       (cons 'name "ude about")
			       '(border-width . 2)
			       (cons 'border-color bg-color)
			       (cons 'top y)
			       (cons 'left x)
			       (cons 'popup
				     (ude-about-make-junk-frame))
			       '(minibuffer . nil)
			       '(width . 50)
			       '(height . 12))))
      (set-specifier text-cursor-visible-p (cons frame nil))
      (set-face-background 'default bg-color frame)
      (set-face-background 'modeline bg-color frame)
      (set-specifier modeline-shadow-thickness (cons frame 1))
      (set-specifier has-modeline-p (cons frame nil))
      (set-face-background-pixmap 'default "" frame)
      (set-window-buffer (frame-selected-window frame) buffer)
      (set-specifier top-toolbar-height (cons frame 0))
      (set-specifier left-toolbar-width (cons frame 0))
      (set-specifier right-toolbar-width (cons frame 0))
      (set-specifier bottom-toolbar-height (cons frame 0))
      (set-specifier top-toolbar (cons frame nil))
      (set-specifier left-toolbar (cons frame nil))
      (set-specifier right-toolbar (cons frame nil))
      (set-specifier bottom-toolbar (cons frame nil))
      (set-specifier scrollbar-width (cons frame 0))
      (set-specifier scrollbar-height (cons frame 0))
      frame)))

;*---------------------------------------------------------------------*/
;*    ude-about ...                                                    */
;*---------------------------------------------------------------------*/
(defun ude-about (msg xpm)
  (let* ((echo-keystrokes 0)
	 (params          (frame-parameters))
	 (left            (cdr (assq 'left params)))
	 (top             (cdr (assq 'top params))))
    (if (and (numberp left) (numberp top))
	(let ((frame (ude-about-make-frame (+ left 20) (+ top 50) msg xpm)))
	  (make-frame-visible frame)
	  (sit-for 60)
	  (make-frame-invisible frame)
	  (delete-frame frame)
	  (kill-buffer " *ude-about-buffer*")))))
