;*=====================================================================*/
;*    serrano/prgm/project/bigloo/examples/Demangle/demangle.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Feb  1 13:18:41 2001                          */
;*    Last change :  Thu Feb  1 13:36:15 2001 (serrano)                */
;*    Copyright   :  2001 Manuel Serrano                               */
;*    -------------------------------------------------------------    */
;*    The C demangler                                                  */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module demangle
   (main main))

;*---------------------------------------------------------------------*/
;*    *demangle-grammar* ...                                           */
;*---------------------------------------------------------------------*/
(define *demangle-grammar*
   (regular-grammar ((id (: (or alpha #\_) (* (or alpha digit #\_))))
		     (rest (in "<>/:;'~`!@#$%^&*()_-+=\|]}[{\\\"")))
      ((: id "_bglt")
       ;; this is a Bigloo type
       (let ((str (the-substring 0 (-fx (the-length) 5))))
	  (if (bigloo-mangled? str)
	      (display (bigloo-demangle str))
	      (display (the-string))))
       (ignore))
      ((: id #\_ (+ (in digit)))
       ;; this is likely to be a Bigloo local vaiable
       (let ((len (the-length))
	     (str (the-string)))
	  (let loop ((i (-fx len 1)))
	     (if (char=? (string-ref str i) #\_)
		 (let ((substr (substring str 0 i)))
		    (if (bigloo-mangled? substr)
			(display (bigloo-demangle substr))
			(display (the-string))))
		 (loop (-fx i 1)))))
       (ignore))
      (id
       ;; a plain identifier
       (let ((str (the-string)))
	  (if (bigloo-mangled? str)
	      (multiple-value-bind (id module)
		 (bigloo-demangle str)
		 (display id)
		 (if (string? module)
		     (display* "@" module)))
	      (display str)))
       (ignore))
      ((+ blank)
       (display (the-string))
       (ignore))
      ((+ (or digit punct rest))
       (display (the-string))
       (ignore))
      (else
       (let ((c (the-failure)))
	  (if (eof-object? c)
	      c
	      (begin
		 (write-char c)
		 (ignore)))))))

;*---------------------------------------------------------------------*/
;*    main ...                                                         */
;*---------------------------------------------------------------------*/
(define (main argv)
   (define (doit)
      (read/rp *demangle-grammar* (current-input-port)))
   (if (pair? (cdr argv))
       (with-input-from-file (cadr argv) doit)
       (doit)))
