;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/port.scm                     */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Sun May 24 10:56:01 1992                          */
;*    Last change :  Tue Nov  6 09:50:09 2001 (serrano)                */
;*                                                                     */
;*    On test les operations simples sur les ports                     */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module input-port
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-input-port)))

;*---------------------------------------------------------------------*/
;*    test1 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test1 port)
   (labels ((get-char (n)
		      (let loop ((i 1)
				 (r (read-char port)))
			 (if (= i n)
			     r
			     (loop (+ 1 i)
				   (read-char port)))))
	    (stole-char (n)
			(let loop ((i 1)
				   (r (peek-char port)))
			   (if (= i n)
			       r
			       (loop (+ 1 i)
				     (peek-char port))))))
      (get-char 10)
      (stole-char 10)
      (get-char 30)
      (stole-char 1) 
      (get-char 33)))

;*---------------------------------------------------------------------*/
;*    test2 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test2 string len)
   (let ((port (open-input-file string len)))
      (if (not (input-port? port))
	  #f
	  (labels ((get-char (n)
			     (let loop ((i 1)
					(r (read-char port)))
				(if (= i n)
				    r
				    (loop (+ 1 i)
					  (read-char port)))))
		   (stole-char (n)
			       (let loop ((i 1)
					  (r (peek-char port)))
				  (if (= i n)
				      r
				      (loop (+ 1 i)
					    (peek-char port))))))
	     (get-char 10)
	     (stole-char 10)
	     (get-char 30)
	     (stole-char 1)
	     (let ((res (get-char 33)))
		(close-input-port port)
		res)))))

;*---------------------------------------------------------------------*/
;*    test3 ...                                                        */
;*---------------------------------------------------------------------*/
(define (test3 string)
   (let ((port (open-input-string string)))
      (let ((exp (read port)))
	 exp)))

;*---------------------------------------------------------------------*/
;*    filepos ...                                                      */
;*---------------------------------------------------------------------*/
(define (filepos)
   (let* ((s "A toto n'est pas content A")
	  (g (regular-grammar ()
		((+ (in ("az"))) 1)
		((+ (in #"\t\n '")) (ignore))
		("A" 2)))
	  (p (open-input-string s))
	  (i (input-port-position p)))
      (let loop ((exp (read/rp g p))
		 (res (list i)))
	 (if (not (eof-object? exp))
	     (let ((new-res (cons (input-port-position p) res)))
		(loop (read/rp g p) new-res))
	     (reverse! res)))))

;*---------------------------------------------------------------------*/
;*    test-append-port ...                                             */
;*---------------------------------------------------------------------*/
(define (test-append-port l)
   (let ((p (open-output-file "recette.TMP")))
      (write (car l) p)
      (close-output-port p)
      (let ((p (append-output-file "recette.TMP")))
	 (write (cdr l) p)
	 (close-output-port p)
	 (let* ((p (open-input-file "recette.TMP"))
		(a (read p))
		(d (read p)))
	    (close-input-port p)
	    (delete-file "recette.TMP")
	    (cons a d)))))

;*---------------------------------------------------------------------*/
;*    test-reopen ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-reopen s)
   (let ((p (open-input-string "toto n'est pas content")))
      (read p)
      (read p)
      (reopen-input-c-string p s)
      (let* ((r1 (read p))
	     (r2 (read p))
	     (r3 (read p)))
	 (close-input-port p)
	 (list r1 r2 r3))))

;*---------------------------------------------------------------------*/
;*    test-binary ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-binary file obj)
   (let ((p (open-output-binary-file file))
	 (cout #\<))
      (output-obj p obj)
      (output-char p cout)
      (close-binary-port p)
      (let ((p (open-input-binary-file file)))
	 (let* ((r (input-obj p))
		(cin (input-char p)))
	    (close-binary-port p)
	    (delete-file file)
	    (if (char=? cout cin)
		r
		cin)))))

;*---------------------------------------------------------------------*/
;*    test-input-port ...                                              */
;*---------------------------------------------------------------------*/
(define (test-input-port)
   (test-module "test-input-port" "port.scm")
   (test "input" (open-input-file "wrong") (input-port? #\space))
   (test "input" (call-with-input-file "misc/input.txt" test1) #\.)
   (test "input" (test2 "misc/input.txt" 10) #\.)
   (test "input-string" (test3 "(4 5 (3) #(1 2 3) \"toto\" titi)")
	 '(4 5 (3) #(1 2 3) "toto" titi))
   (let ((p (open-output-string)))
      (write #a012 p)
      (test "char" (close-output-port p) "#a012"))
   (let ((p (open-output-string)))
      (test "char" (begin
		      (with-output-to-port p
			 (lambda ()
			    (write #a012)))
		      (close-output-port p))
	    "#a012"))
   (let ((p (open-output-string)))
      (write #a179 p)
      (test "char" (close-output-port p) "#a179"))
   (let ((p (open-output-string)))
      (display '("toto" N'EST PAS CONTENT) p)
      (let ((s (get-output-string p)))
	 (close-output-port p)
	 (test "output-string" s '"(toto N'EST PAS CONTENT)")))
   (let* ((stringa (make-string 1020 #\a))
	  (stringb (make-string 1020 #\b))
	  (stringc (make-string 1020 #\c))
	  (stringd (make-string 234 #\d))
	  (string  (string-append stringa stringb stringc stringd))
	  (port    (open-output-string))
	  (res     (begin (display string port) (close-output-port port))))
      (test "long write" res string))
   (let ((p (open-output-string)))
      (close-output-port p)
      (test "close port"
	    (try (begin (write "stupid" p) #f) (lambda (a b c d) (a #t)))
	    #t))
   (test "double close" (let ((p (open-input-file "misc/input.txt")))
			   (close-input-port p)
			   (close-input-port p) 
			   #f)
	 #f)
   (test "filepos" (filepos) '(0 1 6 8 12 16 24 26))
   (let ((l '((1 2 3) . (4 5 6))))
      (test "append" (test-append-port l) l))
   (test "re-open" (test-reopen "tutu non plus") '(tutu non plus))
   (let* ((s "TOTO")
	  (t 'toto)
	  (c (cons s t))
	  (l (list c c c #\a #a127))
	  (v (vector s t c l 1.0 23)))
      (test "binary" (test-binary "misc/binary.BIN" v) v))
   (let ((p (open-input-string "a")))
      (test "char-ready(string).1" (char-ready? p) #t)
      (read p)
      (test "char-ready(string).2" (char-ready? p) #f)
      (close-input-port p)
      (test "char-ready(string).3" (char-ready? p) #f))
   (let ((p (open-input-file "misc/trap.txt")))
      (test "char-ready(file).1" (char-ready? p) #t)
      (read p)
      (test "char-ready(file).2" (char-ready? p) #t)
      (close-input-port p)
      (test "char-ready(file).3" (char-ready? p) #f))
   (let ((p (open-input-file "misc/trap.txt")))
      (let loop ((e (read p)))
	 (if (eof-object? e)
	     (begin
		(test "char-ready(file).4" (char-ready? p) #f)
		(close-input-port p)
		(test "char-ready(file).5" (char-ready? p) #f))
	     (loop (read p))))))
      
      
