/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/cdsssl.c                */
/*    -------------------------------------------------------------    */
/*    Author      :  SERRANO Manuel                                    */
/*    Creation    :  Thu Apr  3 11:37:14 1997                          */
/*    Last change :  Sun May  7 09:50:46 2000 (serrano)                */
/*    -------------------------------------------------------------    */
/*    C Dsssl support.                                                 */
/*=====================================================================*/
#include <string.h>
#include <bigloo.h>

/*---------------------------------------------------------------------*/
/*    Some prototypes                                                  */
/*---------------------------------------------------------------------*/
extern obj_t string_to_keyword();
static obj_t make_keyword();
extern obj_t make_vector();
extern long get_hash_power_number( char *, unsigned long );

/*---------------------------------------------------------------------*/
/*    Global Keyword table                                             */
/*---------------------------------------------------------------------*/
static obj_t c_keytab;

/*---------------------------------------------------------------------*/
/*    init_keyword_table ...                                           */
/*---------------------------------------------------------------------*/
void init_keyword_table()
{
   c_keytab = make_vector( KEYWORD_HASH_TABLE_SIZE, BNIL );
}
           
/*---------------------------------------------------------------------*/
/*    make_keyword ...                                                 */
/*---------------------------------------------------------------------*/
static obj_t
make_keyword( char *name )
{
   obj_t keyword;

   keyword = GC_MALLOC( KEYWORD_SIZE );
   
   keyword->symbol_t.header = MAKE_HEADER( KEYWORD_TYPE, KEYWORD_SIZE );
   keyword->symbol_t.string = string_to_bstring( name );
   keyword->symbol_t.cval   = BNIL;
   
   return BGL_HEAP_DEBUG_MARK_OBJ( BREF( keyword ) );
}
   
/*---------------------------------------------------------------------*/
/*    string_to_keyword ...                                            */
/*    char * --> obj_t                                                 */
/*---------------------------------------------------------------------*/
obj_t
string_to_keyword( char *name )
{
   long hash_number;
   obj_t bucket;

   hash_number = get_hash_power_number( name, KEYWORD_HASH_TABLE_SIZE_SHIFT );
   bucket = VECTOR_REF( c_keytab, hash_number );
   
   if( NULLP( bucket ) )
   {
      obj_t keyword = make_keyword( name );
      obj_t pair    = MAKE_PAIR( keyword, BNIL );
      
      VECTOR_SET( c_keytab, hash_number, pair );
      
      return keyword;
   }
   else
   {
      obj_t run = bucket, back = bucket;
      
      while( !NULLP( run ) &&
	     strcmp( (const char *)BSTRING_TO_STRING( KEYWORD(CAR( run )).string ),
		     (const char *)name ) )
         back = run, run = CDR( run );
      
      if( !NULLP( run ) )
         return CAR( run );
      else
      {
         obj_t keyword = make_keyword( name );
	 obj_t pair    = MAKE_PAIR( keyword, BNIL );
	 
         SET_CDR( back, pair );

         return keyword;
      }
   }
}


