;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/input.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Aug  4 15:42:25 1992                          */
;*    Last change :  Tue Nov  6 08:52:51 2001 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.10.2 Input (page 30, r4)                                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module __r4_input_6_10_2
   
   (import  __error
	    __r4_ports_6_10_1)
   
   (use     __type
	    __bigloo
	    __tvector
	    
	    __rgc
	    
	    __r4_output_6_10_3
	    __r4_equivalence_6_2
	    __r4_vectors_6_8
	    __r4_booleans_6_1
	    __r4_numbers_6_5_fixnum
	    __r4_strings_6_7
	    __r4_control_features_6_9
	    __r4_characters_6_6
	    __r4_symbols_6_4
	    __r4_pairs_and_lists_6_3
	    
	    __evenv)
   
   (extern  (macro c-eof-object?::bool (::obj) "EOF_OBJECTP")
	    (c-char-ready?::bool (::input-port) "bgl_rgc_charready"))
   
   (java    (class foreign
	       (method static c-eof-object?::bool (::obj) "EOF_OBJECTP")
	       (method static c-char-ready?::bool (::input-port) "bgl_rgc_charready")))
   
   (export  (inline read/rp    ::procedure ::input-port)
	    (inline read/lalrp ::procedure ::procedure ::input-port . obj)
	    
	    (read-char . port)
	    (peek-char . port)
	    (inline eof-object?::bool ::obj)
	    (inline char-ready?::bool . port)
	    (read-line::obj . input-port)
	    (read-of-strings::obj . input-port)
	    *about-to-read*)
   
   (pragma  (eof-object? side-effect-free nesting)
	    (char-ready? side-effect-free)))

;*---------------------------------------------------------------------*/
;*    read/rp ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (read/rp grammar port)
   (grammar port))

;*---------------------------------------------------------------------*/
;*    read/lalr ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (read/lalrp lalr rgc port . eof-fun?)
   (if (null? eof-fun?)
       (lalr rgc port eof-object?)
       (lalr rgc port (car eof-fun?))))

;*---------------------------------------------------------------------*/
;*    read-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-char . ip)
   (let ((grammar (regular-grammar ()
		     ((in all #\Newline)
		      (the-character)))))
      (read/rp grammar (if (null? ip) (current-input-port) (car ip)))))

;*---------------------------------------------------------------------*/
;*    peek-char ...                                                    */
;*---------------------------------------------------------------------*/
(define (peek-char . ip)
   (let ((grammar (regular-grammar ()
		     ((in all #\Newline)
		      (let ((c (the-character)))
			 (rgc-buffer-unget-char (the-port) (char->integer c))
			 c)))))
      (read/rp grammar (if (null? ip) (current-input-port) (car ip)))))

;*---------------------------------------------------------------------*/
;*    eof-object? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (eof-object? object)
   (c-eof-object? object))

;*---------------------------------------------------------------------*/
;*    char-ready? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (char-ready? . port)
   (c-char-ready? (if (pair? port) (car port) (current-input-port))))

;*---------------------------------------------------------------------*/
;*    *read-line-grammar* ...                                          */
;*---------------------------------------------------------------------*/
(define *read-line-grammar*
   (regular-grammar ((xall (or (out #\Newline) #a000)))
      ((: (+ xall) #\Newline)
       (the-substring 0 (-fx (the-length) 1)))
      ((+ xall)
       (the-string))
      (#\Newline
       "")
      (else
       (the-failure))))
 
;*---------------------------------------------------------------------*/
;*    read-line ...                                                    */
;*---------------------------------------------------------------------*/
(define (read-line . input-port)
   (let ((port (if (pair? input-port)
		   (car input-port)
		   (current-input-port))))
      (read/rp *read-line-grammar* port)))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define *read-of-strings-grammar*
   (regular-grammar ()
      ((+ (in #\space #\tab #\newline))
       (ignore))
      ((+ (out #\space #\tab #\newline))
       (the-string))))

;*---------------------------------------------------------------------*/
;*    read-of-strings ...                                              */
;*---------------------------------------------------------------------*/
(define (read-of-strings . input-port)
   (let ((port (if (pair? input-port)
		   (car input-port)
		   (current-input-port))))
      (read/rp *read-of-strings-grammar* port)))

;*---------------------------------------------------------------------*/
;*    *about-to-read* ...                                              */
;*---------------------------------------------------------------------*/
(define *about-to-read* #unspecified)

