/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/dlopen.java             */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Mon Dec 11 15:42:09 2000                          */
/*    Last change :  Fri Jul  6 15:13:53 2001 (serrano)                */
/*    Copyright   :  2000-01 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Dynamic class loading for the Jvm back-end.                      */
/*=====================================================================*/
package bigloo;
import java.lang.*;
import java.io.*;
import java.util.*;
import java.lang.reflect.*;

/*---------------------------------------------------------------------*/
/*    dlopen ...                                                       */
/*---------------------------------------------------------------------*/
public abstract class dlopen {
    public static String bgl_dload_error = null;

   static String suffix( byte[] filename ) {
      int len = filename.length;
      int i;

      for( i = len - 1; (i >=0) && (filename[ i ] != '.'); i-- );

      if( i >= 0 )
	 return new String( filename, 0, i );
      else
	 return new String( filename );
   }

    public static int dload( byte[] filename, byte[] init_sym ) {
	bgl_dload_error = "No error (yet)";
	try {
	    Class new_class = Class.forName( suffix( filename ) );
	    Method init = new_class.getDeclaredMethod( new String( init_sym ), 
						       null );

	    init.invoke( null, null );
	    return 0;
	} catch (Exception e) {
	    bgl_dload_error = e.toString();
	    return 1;
	}
    }

    public static byte[] dload_error() {
	return bgl_dload_error.getBytes();
    }
}

			

	
    

