;*=====================================================================*/
;*    .../prgm/project/bigloo/fthread/src2.6b/Llib/fair-reader.scm     */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Feb 11 12:00:29 2002                          */
;*    Last change :  Thu Jun 19 14:02:33 2003 (serrano)                */
;*    Copyright   :  2002-03 Manuel Serrano                            */
;*    -------------------------------------------------------------    */
;*    Fair readers, that is cooperative readers.                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __ft_reader

   (import __ft_types
	   __ft_scheduler
	   __ft_%thread
	   __ft_signal)

   (export (make-fair-reader ::input-port ::int)
	   (make-fair-match ::input-port ::pair)
	   (make-fair-memq ::input-port ::pair)))

;*---------------------------------------------------------------------*/
;*    make-fair-reader ...                                             */
;*    -------------------------------------------------------------    */
;*    This function is the non blocking input main entry point. A      */
;*    fair thread asks READER-AWAIT to be notified when N chars        */
;*    read on PORT are available. When this condition is meet, the     */
;*    signal SIGNAL is signaled.                                       */
;*---------------------------------------------------------------------*/
(define (make-fair-reader port size)
   (let ((str (c-make-string/wo-fill size)))
      (lambda ()
	 (set! str (string-shrink! str (read-fill-string! str 0 size port)))
	 (if (and (string=? str "") (rgc-buffer-eof? port))
	     beof
	     str))))

;*---------------------------------------------------------------------*/
;*    string-double ...                                                */
;*---------------------------------------------------------------------*/
(define (string-double str)
   (let* ((size (string-length str))
	  (new-size (*fx size 2))
	  (new-buffer (make-string new-size)))
      (blit-string! str 0 new-buffer 0 size)
      new-buffer))
 
;*---------------------------------------------------------------------*/
;*    make-fair-match ...                                              */
;*    -------------------------------------------------------------    */
;*    Read characters until a user pattern is found. Then returns      */
;*    a string representing the buffer.                                */
;*---------------------------------------------------------------------*/
(define (make-fair-match port match*)
   (lambda ()
      (define (match-found? match n buf)
	 (let ((len (string-length match)))
	    (if (>= n len)
		(let loop ((r1 0)
			   (r2 (-fx n len)))
		   (cond
		      ((=fx r2 n)
		       #t)
		      ((char=? (string-ref buf r2) (string-ref match r1))
		       (loop (+fx r1 1) (+fx r2 1)))
		      (else
		       #f)))
		#f)))
      (let loop ((n 0)
		 (size 256)
		 (buf (make-string 256)))
	 (if (=fx n size)
	     (loop n (*fx size 2) (string-double buf))
	     (let ((c (read-char port)))
		(if (eof-object? c)
		    (if (>fx n 0)
			(substring buf 0 n)
			c)
		    (begin
		       (string-set! buf n c)
		       (if (any? (lambda (m)
				    (match-found? m (+fx 1 n) buf))
				 match*)
			   (begin
			      (set! buf (string-shrink! buf (+fx n 1)))
			      buf)
			   (loop (+fx n 1) size buf)))))))))

;*---------------------------------------------------------------------*/
;*    make-fair-memq ...                                               */
;*    -------------------------------------------------------------    */
;*    Reads everything until we find a character in the SET.           */
;*    The returned string *contains* that character.                   */
;*---------------------------------------------------------------------*/
(define (make-fair-memq port match)
   (lambda ()
      (let loop ((n 0)
		 (size 256)
		 (buf (make-string 256)))
	 (if (=fx n size)
	     (loop n (*fx size 2) (string-double buf))
	     (let ((c (read-char port)))
		(if (eof-object? c)
		    (if (>fx n 0)
			(substring buf 0 n)
			c)
		    (begin
		       (string-set! buf n c)
		       (if (memq c match)
			   (begin
			      (set! buf (string-shrink! buf (+fx n 1)))
			      buf)
			   (loop (+fx n 1) size buf)))))))))

