;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/flonum.scm                   */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 26 11:59:37 1992                          */
;*    Last change :  Mon Apr  5 21:39:59 2004 (serrano)                */
;*                                                                     */
;*    On test un peu les flotants (il le faut bien).                   */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module flonum
   (import  (main "main.scm"))
   (include "test.sch")
   (export  (test-flonum)))

;*---------------------------------------------------------------------*/
;*    fact ...                                                         */
;*---------------------------------------------------------------------*/
(define (fact x)
   (if (< x 2)
       1
       (* (fact (- x 1)) x)))

;*---------------------------------------------------------------------*/
;*    sqrt-test ...                                                    */
;*---------------------------------------------------------------------*/
(define (sqrt-test x::double)
   (sqrt x))

;*---------------------------------------------------------------------*/
;*    test-flonum ...                                                  */
;*---------------------------------------------------------------------*/
(define (test-flonum)
   (test-module "flonum" "flonum.scm")
   (test "flonum.1" 3.141592 3.141592)
   (test "flonum.2" -3.141592 -3.141592)
   (test "flonum.3" 3.141592 3.141592)
   (test "flonum.4" -3.141592 -3.141592)
   (test "flonum.5" (/ (inexact->exact (cos 0)) 2) 0.5)
   (test "flonum.6" (/ 1 2) 0.5)
   (test "flonum.7" 23.56 (+fl 23.0 0.56))
   (test "flonum.8" (let ((p (open-input-string "3.14")))
		       (read p))
	 3.14)
   (test "flonum.9" (let ((p (open-input-string "-3.14")))
		       (read p))
	 -3.14)
   (test "flonum.10" (let ((p (open-input-string "1e2")))
			(read p))
	 1e2)
   (test "flonum.11" (let ((p (open-input-string "1e-2")))
			(read p))
	 1e-2)
   (test "flonum.12" (let ((p (open-input-string "-1e2")))
			(read p))
	 -1e2)
   (test "flonum.13" (let ((p (open-input-string "-1e-2")))
			(read p))
	 -1e-2)
   (test "cos" (sin 0) 0.0)
   (test "cos" (acos (cos 2.0)) 2.0)
   (test "round" (round 4.3) 4.0)
   (test "exact" (exact? 5) #t)
   (test "exact" (exact? 5.0) #f)
   (test "inexact" (inexact? 5) #f)
   (test "inexact" (inexact? 5.0) #t)
   (test "exact" (inexact->exact 4.3) 4)
   (test "fact" (fact 5) 120)
   (test "fact" (fact 5.0) 120.0)
   (test "floor" (floor -4.3) -5.0)
   (test "ceiling" (ceiling -4.3) -4.0)
   (test "truncate" (truncate -4.3) -4.0)
   (test "round" (round -4.3) -4.0)
   (test "floor" (floor 3.5) 3.0)
   (test "ceiling" (ceiling 3.5) 4.0)
   (test "truncate" (truncate 3.5) 3.0)
   (test "round" (round 3.5) 4.0)
   (test "sqrt" (sqrt-test 4.0) 2.0)
   (test "atan" (let ((r (atan 1.0 1.0))) (> r 0)) #t)
   (test "prec" (let ((num (+ 1e-6 1e-12)))
		   (=fl (string->number (number->string num)) num))
	 #t))

