/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/bgldynamic.java         */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Sat Oct 19 10:42:04 2002                          */
/*    Last change :  Tue Feb 18 13:34:21 2003 (serrano)                */
/*    Copyright   :  2002-03 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    Handling global dynamic environments (current_output_port et al) */
/*=====================================================================*/

/*---------------------------------------------------------------------*/
/*    The package                                                      */
/*---------------------------------------------------------------------*/
package bigloo;

import java.lang.*;
import bigloo.foreign;

/*---------------------------------------------------------------------*/
/*    bglthread                                                        */
/*---------------------------------------------------------------------*/
public class bgldynamic
{
   public static bgldynamic current_dynamic_env = new bgldynamic();

   // global environment
   public Object exitd_top;
   public Object error_handler;
   public input_port current_input_port;
   public output_port current_output_port;
   public output_port current_error_port;
   public int mvalues_number;
   public final Object[] mvalues_values= { unspecified.unspecified,
					   unspecified.unspecified,
					   unspecified.unspecified,
					   unspecified.unspecified };

   // constructor
   public bgldynamic() {
      exitd_top = new exit();
      error_handler = bigloo.nil.nil;

      mvalues_number = 1;

      current_input_port = new input_console_port( foreign.default_io_bufsiz );
      current_output_port = new output_port( System.out );
      current_error_port = new output_port( System.err );
   }

   // constructor
   public bgldynamic( final bgldynamic o ) {
      exitd_top = new exit();
      error_handler = nil.nil;

      mvalues_number = 1;

      current_input_port = o.current_input_port;
      current_output_port = o.current_output_port;
      current_error_port = o.current_error_port;
   }
}
