/*=====================================================================*/
/*    .../prgm/project/bigloo/api/fthread/src/Posix/bglfcondvar.c      */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Nov  3 07:58:16 2004                          */
/*    Last change :  Fri Apr  8 14:42:36 2005 (serrano)                */
/*    Copyright   :  2004-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Posix condition variable implementation                      */
/*=====================================================================*/
#include <pthread.h>
#include <sched.h>
#include <stdlib.h>
#include <string.h>

#define GC_PRIVATE_H
#include <gc.h>
#include <bglfthread.h>

/*---------------------------------------------------------------------*/
/*    Imports                                                          */
/*---------------------------------------------------------------------*/
BGL_RUNTIME_DECL void bgl_condvar_init_register( obj_t (*)( obj_t ) );
BGL_RUNTIME_DECL void bgl_condvar_wait_register( bool_t (*)( obj_t, obj_t ) );
BGL_RUNTIME_DECL void bgl_condvar_signal_register( bool_t (*)( obj_t ) );
BGL_RUNTIME_DECL void bgl_condvar_broadcast_register( bool_t (*)( obj_t ) );

/*---------------------------------------------------------------------*/
/*    obj_t                                                            */
/*    bglfth_condvar_init ...                                          */
/*---------------------------------------------------------------------*/
obj_t
bglfth_condvar_init( obj_t cv ) {
   bglfcondvar_t co = (bglfcondvar_t)GC_MALLOC( sizeof( struct bglfcondvar ) );

   cv->condvar_t.condvar = co;

   pthread_cond_init( &(co->pcondvar), 0L );

   return cv;
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    bglfth_condvar_wait ...                                          */
/*---------------------------------------------------------------------*/
bool_t
bglfth_condvar_wait( obj_t cv, obj_t m ) {
   return !pthread_cond_wait( BGLFTH_CONDVAR_PCONDVAR( cv ),
			      BGLFTH_MUTEX_PMUTEX( m ) );
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    bglfth_condvar_signal ...                                        */
/*---------------------------------------------------------------------*/
bool_t
bglfth_condvar_signal( obj_t cv ) {
   return !pthread_cond_signal( BGLFTH_CONDVAR_PCONDVAR( cv ) );
}

/*---------------------------------------------------------------------*/
/*    bool_t                                                           */
/*    bglfth_condvar_broadcast ...                                     */
/*---------------------------------------------------------------------*/
bool_t
bglfth_condvar_broadcast( obj_t cv ) {
   return !pthread_cond_signal( BGLFTH_CONDVAR_PCONDVAR( cv ) );
}

/*---------------------------------------------------------------------*/
/*    void                                                             */
/*    bglfth_setup_condvar ...                                         */
/*---------------------------------------------------------------------*/
void
bglfth_setup_condvar() {
   bgl_condvar_init_register( &bglfth_condvar_init );
   bgl_condvar_wait_register( &bglfth_condvar_wait );
   bgl_condvar_signal_register( &bglfth_condvar_signal );
   bgl_condvar_broadcast_register( &bglfth_condvar_broadcast );
}
