/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <config.h>

#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <wordexp.h>
#include <sys/stat.h>
#include <dirent.h>
#include <cerrno>
//portability problem?
#include <pthread.h>

#include <cstdio>


#include <FL/Fl.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_Dialog.H>
#include <FL/Fl_Check_Button.H>
//#include <FL/Fl_PNG_Image.H>

#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>
#include <finestra_pr.hpp>
#include <editor.hpp>

#include <prefs.hpp>

#include <set_conf.hpp>
#include <command_line.hpp>
#include <util.hpp>



#include <align_elements_dialog.hpp>

#include <align_elements.hpp>

extern finestra_pr* __la_finestra;

extern Preferences  __pref;

extern bool __close;




/**
 *Un plugin deve avere :
 *
 *una funzione  bool (*need_group)()  che ritorna true  se il  plugin ha
 *bisogno di conoscre quali atomi sono selezionati;
 *
 *una funzione  bool (*need_leg)()  che ritorna true  se il  plugin ha
 *bisogno di conoscere quali legami sono selezionati;
 *
 *una funzione  bool (*act)()  che computa quello  per cui il  plugin e'
 *stato scritto
 *
 */



align_elements::align_elements(immagine* image,string libpath)
  :bist_plugin(image,libpath),
   _has_to_act(true),
   _has_acted(false)
  
{
  
}


void align_elements::inizialize(){

  align_elements_dialog dialog_ch;

  while(dialog_ch.shown()){
    Fl::wait();
  }

  //std::cerr << "settato:" << dialog_ch.get_alignment_h()<< std::endl;

  bool horiz_align=dialog_ch.get_alignment_h();


  /**
   *Contiene  coppie <tipo, < gruppo, id > > selezionati, se  si e'
   *selezionato una etichetta gruppo e' uguale a NO_VALID_GROUP
   */
  
  vector< pair < int, pair<int,int> > >* elem=r_elem_selected();
  vector< pair < int, pair<int,int> > >::iterator eliniz=elem->begin();
  vector< pair < int, pair<int,int> > >::iterator elend=elem->end();

  float x_align=0;//angolo minx min_y
  float y_align=0;
  float height=0;
  float width=0;

  if(eliniz!=elend){
    switch((*eliniz).first){
    case ATOMO:
      {
	//cout << "align: selezionato atomo" << endl;
	gruppo* the_grp=_the_image->find_group_id(((*eliniz).second).first);
	x_align=the_grp->posx();
	y_align=the_grp->posy();
	height=the_grp->h();
	break;
      }
      
    case PROC_BEZIER:
    case PROC_ARC:
    case PROC_ARROW:
      {
	//cout << "align: selezionata procedura" << endl;
	gruppo* the_grp=_the_image->find_group_id(((*eliniz).second).first);
	procedura* proc=the_grp->find_proc_id(((*eliniz).second).second);
	x_align=proc->posx();
	y_align=proc->posy();
	height=proc->h();
	width=proc->w();
	break;
      }
    case ETICHETTA: 
      {
	etichetta* laet=_the_image->ritorna_etich_pointer(((*eliniz).second).second);
	//cout << "align: selezionata etichetta" << endl;
	x_align=laet->x();
	y_align=laet->y();
	height=laet->h();
	width=laet->w();
	//cout << laet.to_raw_string() << endl;
	break;
      }
    }
  

    eliniz++;

    while(eliniz!=elend){
      switch((*eliniz).first){
      case ATOMO:
	{
	  cout << "align: selezionato atomo" << endl;
	  gruppo* the_grp=_the_image->find_group_id(((*eliniz).second).first);
	  float nwy= y_align - the_grp->posy() + height/2.0 - the_grp->h()/2.0 ;
	  float nwx= x_align - the_grp->posx() + width/2.0 - the_grp->w()/2.0 ;
	  /*
	  cout << the_grp->posy() << endl;
	  cout << - y_align + height/2.0 << endl;
	  cout << y_align << endl;
	  */

	  if(horiz_align){
	    nwx=0;
	  }else{
	    nwy=0;
	  }

	  the_grp->trasla(nwx,nwy);
	  
	  break;
	}
      case PROC_BEZIER:
      case PROC_ARC:
      case PROC_ARROW:
	{
	  gruppo* the_grp=_the_image->find_group_id(((*eliniz).second).first);
	  procedura* proc=the_grp->find_proc_id(((*eliniz).second).second);	
	  float nwy= y_align - proc->posy() + height/2.0 - proc->h()/2.0;
	  float nwx= x_align - proc->posx() + width/2.0 - proc->w()/2.0 ;

	  
	  if(horiz_align){
	    nwx=0;
	  }else{
	    nwy=0;
	  }


	  proc->trasla(nwx,nwy);
	  break;
	}
      case ETICHETTA: 
	{
	  etichetta* laet=_the_image->ritorna_etich_pointer(((*eliniz).second)
							    .second);
	  float nwy= y_align - laet->y() + height/2.0 - laet->h()/2.0;
	  float nwx= x_align - laet->x() + width/2.0 - laet->w()/2.0;
	  
	  
	  if(horiz_align){
	    nwx=0;
	  }else{
	    nwy=0;
	  }

	  laet->trasla(nwx,nwy);
	  break;
	}
      }

      eliniz++;
    }

  }

  _has_to_act=false;

}


bool align_elements::need_atom(){
  return false;
}

bool align_elements::need_leg(){
  return false;
}

bool align_elements::act(int e){

  return _has_to_act;
}


align_elements::~align_elements(){
  
  cout << "align horiz distruzione!!! " << _the_image <<endl;
}

void align_elements::register_plugin(){

}

 
bool align_elements::time_to_act(){
  return _has_to_act;
}
    

string align_elements::libpath(){
  return _lib;
}



/**************fine metodi di classe**********************************/




extern "C" bist_plugin* create_plugin(immagine* imm, string libpath){
  return new align_elements(imm, libpath);
}

extern "C" void destroy_plugin(bist_plugin* j){
  cout << "distruzione plugin: " << j <<  endl;
  delete j;
  cout << "riuscita" << endl;
}


