# THIS FILE IS AUTOMATICALLY GENERATED.  EDIT THE SOURCE FILE NOT THIS ONE

"""Various descriptions of data specific to Sanyo phones"""

from prototypes import *
from prototypeslg import *

# We use LSB for all integer like fields

UINT=UINTlsb
BOOL=BOOLlsb
_NUMPBSLOTS=300
_NUMSPEEDDIALS=8
_NUMLONGNUMBERS=5
_LONGPHONENUMBERLEN=30
_NUMEVENTSLOTS=100
_NUMCALLALARMSLOTS=15
NUMCALLHISTORY=20
NUMPHONENUMBERS=7
NUMMESSAGESLOTS=128
NUMTODOSLOTS=20
HASRINGPICBUF=1

OUTGOING=0
INCOMING=1
MISSED=2

class sanyoerror(BaseProtogenClass):
    __fields=['errorcode', 'unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sanyoerror,self).__init__(**dict)
        if self.__class__ is sanyoerror:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sanyoerror,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sanyoerror,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_errorcode.writetobuffer(buf)
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_errorcode=UINT(**{'sizeinbytes': 1})
        self.__field_errorcode.readfrombuffer(buf)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_errorcode(self):
        return self.__field_errorcode.getvalue()

    def __setfield_errorcode(self, value):
        if isinstance(value,UINT):
            self.__field_errorcode=value
        else:
            self.__field_errorcode=UINT(value,**{'sizeinbytes': 1})

    def __delfield_errorcode(self): del self.__field_errorcode

    errorcode=property(__getfield_errorcode, __setfield_errorcode, __delfield_errorcode, None)

    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('errorcode', self.__field_errorcode, None)
        yield ('unknown', self.__field_unknown, None)




class firmwarerequest(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(firmwarerequest,self).__init__(**dict)
        if self.__class__ is firmwarerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(firmwarerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(firmwarerequest,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1, 'constant': 0x00}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x00})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x00})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class firmwareresponse(BaseProtogenClass):
    __fields=['command', 'unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(firmwareresponse,self).__init__(**dict)
        if self.__class__ is firmwareresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(firmwareresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(firmwareresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('unknown', self.__field_unknown, None)




class beginendupdaterequest(BaseProtogenClass):
    __fields=['command', 'beginend']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(beginendupdaterequest,self).__init__(**dict)
        if self.__class__ is beginendupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(beginendupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(beginendupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x29})
        self.__field_command.writetobuffer(buf)
        self.__field_beginend.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x29})
        self.__field_command.readfrombuffer(buf)
        self.__field_beginend=UINT(**{'sizeinbytes': 2})
        self.__field_beginend.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x29})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x29})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_beginend(self):
        return self.__field_beginend.getvalue()

    def __setfield_beginend(self, value):
        if isinstance(value,UINT):
            self.__field_beginend=value
        else:
            self.__field_beginend=UINT(value,**{'sizeinbytes': 2})

    def __delfield_beginend(self): del self.__field_beginend

    beginend=property(__getfield_beginend, __setfield_beginend, __delfield_beginend, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('beginend', self.__field_beginend, None)




class beginendupdateresponse(BaseProtogenClass):
    __fields=['command', 'beginend']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(beginendupdateresponse,self).__init__(**dict)
        if self.__class__ is beginendupdateresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(beginendupdateresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(beginendupdateresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_beginend.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_beginend=UINT(**{'sizeinbytes': 2})
        self.__field_beginend.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_beginend(self):
        return self.__field_beginend.getvalue()

    def __setfield_beginend(self, value):
        if isinstance(value,UINT):
            self.__field_beginend=value
        else:
            self.__field_beginend=UINT(value,**{'sizeinbytes': 2})

    def __delfield_beginend(self): del self.__field_beginend

    beginend=property(__getfield_beginend, __setfield_beginend, __delfield_beginend, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('beginend', self.__field_beginend, None)




class statusrequest(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(statusrequest,self).__init__(**dict)
        if self.__class__ is statusrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(statusrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(statusrequest,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1, 'constant': 0x0c}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x0c})
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x0c})
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x0c})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x0c})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class statusresponse(BaseProtogenClass):
    __fields=['readyvalue', 'command', 'dunno1', 'esn', 'flag0', 'dunno2', 'ready', 'dunno3', 'flag2', 'dunno4', 'flag3', 'unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(statusresponse,self).__init__(**dict)
        if self.__class__ is statusresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(statusresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(statusresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_readyvalue
        except:
            self.__field_readyvalue=UINT(**{'constant': 0x0})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_esn.writetobuffer(buf)
        self.__field_flag0.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self.__field_ready.writetobuffer(buf)
        self.__field_dunno3.writetobuffer(buf)
        self.__field_flag2.writetobuffer(buf)
        self.__field_dunno4.writetobuffer(buf)
        self.__field_flag3.writetobuffer(buf)
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_esn=UINT(**{'sizeinbytes': 4})
        self.__field_esn.readfrombuffer(buf)
        self.__field_flag0=UINT(**{'sizeinbytes': 1})
        self.__field_flag0.readfrombuffer(buf)
        self.__field_dunno2=UNKNOWN(**{'sizeinbytes': 14})
        self.__field_dunno2.readfrombuffer(buf)
        self.__field_ready=UINT(**{'sizeinbytes': 1})
        self.__field_ready.readfrombuffer(buf)
        self.__field_dunno3=UINT(**{'sizeinbytes': 1})
        self.__field_dunno3.readfrombuffer(buf)
        self.__field_flag2=UINT(**{'sizeinbytes': 1})
        self.__field_flag2.readfrombuffer(buf)
        self.__field_dunno4=UNKNOWN(**{'sizeinbytes': 6})
        self.__field_dunno4.readfrombuffer(buf)
        self.__field_flag3=UINT(**{'sizeinbytes': 1})
        self.__field_flag3.readfrombuffer(buf)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_readyvalue(self):
        return self.__field_readyvalue.getvalue()

    def __setfield_readyvalue(self, value):
        if isinstance(value,UINT):
            self.__field_readyvalue=value
        else:
            self.__field_readyvalue=UINT(value,**{'constant': 0x0})

    def __delfield_readyvalue(self): del self.__field_readyvalue

    readyvalue=property(__getfield_readyvalue, __setfield_readyvalue, __delfield_readyvalue, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_esn(self):
        return self.__field_esn.getvalue()

    def __setfield_esn(self, value):
        if isinstance(value,UINT):
            self.__field_esn=value
        else:
            self.__field_esn=UINT(value,**{'sizeinbytes': 4})

    def __delfield_esn(self): del self.__field_esn

    esn=property(__getfield_esn, __setfield_esn, __delfield_esn, None)

    def __getfield_flag0(self):
        return self.__field_flag0.getvalue()

    def __setfield_flag0(self, value):
        if isinstance(value,UINT):
            self.__field_flag0=value
        else:
            self.__field_flag0=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag0(self): del self.__field_flag0

    flag0=property(__getfield_flag0, __setfield_flag0, __delfield_flag0, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UNKNOWN(value,**{'sizeinbytes': 14})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_ready(self):
        return self.__field_ready.getvalue()

    def __setfield_ready(self, value):
        if isinstance(value,UINT):
            self.__field_ready=value
        else:
            self.__field_ready=UINT(value,**{'sizeinbytes': 1})

    def __delfield_ready(self): del self.__field_ready

    ready=property(__getfield_ready, __setfield_ready, __delfield_ready, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UINT):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def __getfield_flag2(self):
        return self.__field_flag2.getvalue()

    def __setfield_flag2(self, value):
        if isinstance(value,UINT):
            self.__field_flag2=value
        else:
            self.__field_flag2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag2(self): del self.__field_flag2

    flag2=property(__getfield_flag2, __setfield_flag2, __delfield_flag2, None)

    def __getfield_dunno4(self):
        return self.__field_dunno4.getvalue()

    def __setfield_dunno4(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno4=value
        else:
            self.__field_dunno4=UNKNOWN(value,**{'sizeinbytes': 6})

    def __delfield_dunno4(self): del self.__field_dunno4

    dunno4=property(__getfield_dunno4, __setfield_dunno4, __delfield_dunno4, None)

    def __getfield_flag3(self):
        return self.__field_flag3.getvalue()

    def __setfield_flag3(self, value):
        if isinstance(value,UINT):
            self.__field_flag3=value
        else:
            self.__field_flag3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag3(self): del self.__field_flag3

    flag3=property(__getfield_flag3, __setfield_flag3, __delfield_flag3, None)

    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('readyvalue', self.__field_readyvalue, None)
        yield ('command', self.__field_command, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('esn', self.__field_esn, None)
        yield ('flag0', self.__field_flag0, None)
        yield ('dunno2', self.__field_dunno2, None)
        yield ('ready', self.__field_ready, None)
        yield ('dunno3', self.__field_dunno3, None)
        yield ('flag2', self.__field_flag2, None)
        yield ('dunno4', self.__field_dunno4, None)
        yield ('flag3', self.__field_flag3, None)
        yield ('unknown', self.__field_unknown, None)




class phonenumberrequest(BaseProtogenClass):
    __fields=['command1', 'command2', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(phonenumberrequest,self).__init__(**dict)
        if self.__class__ is phonenumberrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(phonenumberrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(phonenumberrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command1
        except:
            self.__field_command1=UINT(**{'sizeinbytes': 1, 'constant': 0x26})
        self.__field_command1.writetobuffer(buf)
        try: self.__field_command2
        except:
            self.__field_command2=UINT(**{'sizeinbytes': 1, 'constant': 0xb2})
        self.__field_command2.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 131})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command1=UINT(**{'sizeinbytes': 1, 'constant': 0x26})
        self.__field_command1.readfrombuffer(buf)
        self.__field_command2=UINT(**{'sizeinbytes': 1, 'constant': 0xb2})
        self.__field_command2.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 131})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command1(self):
        try: self.__field_command1
        except:
            self.__field_command1=UINT(**{'sizeinbytes': 1, 'constant': 0x26})
        return self.__field_command1.getvalue()

    def __setfield_command1(self, value):
        if isinstance(value,UINT):
            self.__field_command1=value
        else:
            self.__field_command1=UINT(value,**{'sizeinbytes': 1, 'constant': 0x26})

    def __delfield_command1(self): del self.__field_command1

    command1=property(__getfield_command1, __setfield_command1, __delfield_command1, None)

    def __getfield_command2(self):
        try: self.__field_command2
        except:
            self.__field_command2=UINT(**{'sizeinbytes': 1, 'constant': 0xb2})
        return self.__field_command2.getvalue()

    def __setfield_command2(self, value):
        if isinstance(value,UINT):
            self.__field_command2=value
        else:
            self.__field_command2=UINT(value,**{'sizeinbytes': 1, 'constant': 0xb2})

    def __delfield_command2(self): del self.__field_command2

    command2=property(__getfield_command2, __setfield_command2, __delfield_command2, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 131})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 131})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command1', self.__field_command1, None)
        yield ('command2', self.__field_command2, None)
        yield ('pad', self.__field_pad, None)




class phonenumberresponse(BaseProtogenClass):
    __fields=['command1', 'command2', 'pad1', 'myphonenumber', 'pad2']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(phonenumberresponse,self).__init__(**dict)
        if self.__class__ is phonenumberresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(phonenumberresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(phonenumberresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command1.writetobuffer(buf)
        self.__field_command2.writetobuffer(buf)
        self.__field_pad1.writetobuffer(buf)
        self.__field_myphonenumber.writetobuffer(buf)
        self.__field_pad2.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command1=UINT(**{'sizeinbytes': 1, 'constant': 0x26})
        self.__field_command1.readfrombuffer(buf)
        self.__field_command2=UINT(**{'sizeinbytes': 1, 'constant': 0xb2})
        self.__field_command2.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_myphonenumber=USTRING(**{'sizeinbytes': 10, 'raiseonunterminatedread': False})
        self.__field_myphonenumber.readfrombuffer(buf)
        self.__field_pad2=UNKNOWN(**{'sizeinbytes': 119})
        self.__field_pad2.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command1(self):
        return self.__field_command1.getvalue()

    def __setfield_command1(self, value):
        if isinstance(value,UINT):
            self.__field_command1=value
        else:
            self.__field_command1=UINT(value,**{'sizeinbytes': 1, 'constant': 0x26})

    def __delfield_command1(self): del self.__field_command1

    command1=property(__getfield_command1, __setfield_command1, __delfield_command1, None)

    def __getfield_command2(self):
        return self.__field_command2.getvalue()

    def __setfield_command2(self, value):
        if isinstance(value,UINT):
            self.__field_command2=value
        else:
            self.__field_command2=UINT(value,**{'sizeinbytes': 1, 'constant': 0xb2})

    def __delfield_command2(self): del self.__field_command2

    command2=property(__getfield_command2, __setfield_command2, __delfield_command2, None)

    def __getfield_pad1(self):
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_myphonenumber(self):
        return self.__field_myphonenumber.getvalue()

    def __setfield_myphonenumber(self, value):
        if isinstance(value,USTRING):
            self.__field_myphonenumber=value
        else:
            self.__field_myphonenumber=USTRING(value,**{'sizeinbytes': 10, 'raiseonunterminatedread': False})

    def __delfield_myphonenumber(self): del self.__field_myphonenumber

    myphonenumber=property(__getfield_myphonenumber, __setfield_myphonenumber, __delfield_myphonenumber, None)

    def __getfield_pad2(self):
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad2=value
        else:
            self.__field_pad2=UNKNOWN(value,**{'sizeinbytes': 119})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command1', self.__field_command1, None)
        yield ('command2', self.__field_command2, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('myphonenumber', self.__field_myphonenumber, None)
        yield ('pad2', self.__field_pad2, None)




class sanyoheader(BaseProtogenClass):
    __fields=['readwrite', 'command', 'packettype']

    def __init__(self, *args, **kwargs):
        dict={}
        # User specified arguments in the packet description
        dict.update({'readwrite': 0x0d})
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sanyoheader,self).__init__(**dict)
        if self.__class__ is sanyoheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sanyoheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sanyoheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_readwrite.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        self.__field_packettype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_readwrite=UINT(**{'sizeinbytes': 1})
        self.__field_readwrite.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 1})
        self.__field_command.readfrombuffer(buf)
        self.__field_packettype=UINT(**{'sizeinbytes': 1})
        self.__field_packettype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_readwrite(self):
        return self.__field_readwrite.getvalue()

    def __setfield_readwrite(self, value):
        if isinstance(value,UINT):
            self.__field_readwrite=value
        else:
            self.__field_readwrite=UINT(value,**{'sizeinbytes': 1})

    def __delfield_readwrite(self): del self.__field_readwrite

    readwrite=property(__getfield_readwrite, __setfield_readwrite, __delfield_readwrite, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_packettype(self):
        return self.__field_packettype.getvalue()

    def __setfield_packettype(self, value):
        if isinstance(value,UINT):
            self.__field_packettype=value
        else:
            self.__field_packettype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_packettype(self): del self.__field_packettype

    packettype=property(__getfield_packettype, __setfield_packettype, __delfield_packettype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('readwrite', self.__field_readwrite, None)
        yield ('command', self.__field_command, None)
        yield ('packettype', self.__field_packettype, None)




class esnrequest(BaseProtogenClass):
    __fields=['command']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(esnrequest,self).__init__(**dict)
        if self.__class__ is esnrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(esnrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(esnrequest,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1, 'constant': 0x01}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_command=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x01})
        self.__field_command.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x01})
        self.__field_command.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        try: self.__field_command
        except:
            self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x01})
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x01})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)




class esnresponse(BaseProtogenClass):
    __fields=['command', 'esn']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(esnresponse,self).__init__(**dict)
        if self.__class__ is esnresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(esnresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(esnresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_command.writetobuffer(buf)
        self.__field_esn.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_command=UINT(**{'sizeinbytes': 1, 'constant': 0x01})
        self.__field_command.readfrombuffer(buf)
        self.__field_esn=UINT(**{'sizeinbytes': 4})
        self.__field_esn.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 1, 'constant': 0x01})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_esn(self):
        return self.__field_esn.getvalue()

    def __setfield_esn(self, value):
        if isinstance(value,UINT):
            self.__field_esn=value
        else:
            self.__field_esn=UINT(value,**{'sizeinbytes': 4})

    def __delfield_esn(self): del self.__field_esn

    esn=property(__getfield_esn, __setfield_esn, __delfield_esn, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('command', self.__field_command, None)
        yield ('esn', self.__field_esn, None)




class ownerinforequest(BaseProtogenClass):
    __fields=['header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ownerinforequest,self).__init__(**dict)
        if self.__class__ is ownerinforequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ownerinforequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ownerinforequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x3b})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 502})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x3b})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 502})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x3b})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,		'command': 0x3b})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 502})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 502})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class ownerentry(BaseProtogenClass):
    __fields=['ownername', 'birthyear', 'birthmonth', 'birthday', 'bloodtype', 'address', 'pad', 'homeemail', 'workemail', 'homephone', 'workphone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ownerentry,self).__init__(**dict)
        if self.__class__ is ownerentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ownerentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ownerentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_ownername.writetobuffer(buf)
        self.__field_birthyear.writetobuffer(buf)
        self.__field_birthmonth.writetobuffer(buf)
        self.__field_birthday.writetobuffer(buf)
        self.__field_bloodtype.writetobuffer(buf)
        self.__field_address.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 14})
        self.__field_pad.writetobuffer(buf)
        self.__field_homeemail.writetobuffer(buf)
        self.__field_workemail.writetobuffer(buf)
        self.__field_homephone.writetobuffer(buf)
        self.__field_workphone.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_ownername=USTRING(**{'sizeinbytes': 16, 'raiseonunterminatedread': False})
        self.__field_ownername.readfrombuffer(buf)
        self.__field_birthyear=UINT(**{'sizeinbytes': 2})
        self.__field_birthyear.readfrombuffer(buf)
        self.__field_birthmonth=UINT(**{'sizeinbytes': 1})
        self.__field_birthmonth.readfrombuffer(buf)
        self.__field_birthday=UINT(**{'sizeinbytes': 1})
        self.__field_birthday.readfrombuffer(buf)
        self.__field_bloodtype=UINT(**{'sizeinbytes': 1})
        self.__field_bloodtype.readfrombuffer(buf)
        self.__field_address=USTRING(**{'sizeinbytes': 96, 'raiseonunterminatedread': False})
        self.__field_address.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 14})
        self.__field_pad.readfrombuffer(buf)
        self.__field_homeemail=USTRING(**{'sizeinbytes': 48, 'raiseonunterminatedread': False})
        self.__field_homeemail.readfrombuffer(buf)
        self.__field_workemail=USTRING(**{'sizeinbytes': 48, 'raiseonunterminatedread': False})
        self.__field_workemail.readfrombuffer(buf)
        self.__field_homephone=USTRING(**{'sizeinbytes': 48, 'raiseonunterminatedread': False})
        self.__field_homephone.readfrombuffer(buf)
        self.__field_workphone=USTRING(**{'sizeinbytes': 48, 'raiseonunterminatedread': False})
        self.__field_workphone.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_ownername(self):
        return self.__field_ownername.getvalue()

    def __setfield_ownername(self, value):
        if isinstance(value,USTRING):
            self.__field_ownername=value
        else:
            self.__field_ownername=USTRING(value,**{'sizeinbytes': 16, 'raiseonunterminatedread': False})

    def __delfield_ownername(self): del self.__field_ownername

    ownername=property(__getfield_ownername, __setfield_ownername, __delfield_ownername, None)

    def __getfield_birthyear(self):
        return self.__field_birthyear.getvalue()

    def __setfield_birthyear(self, value):
        if isinstance(value,UINT):
            self.__field_birthyear=value
        else:
            self.__field_birthyear=UINT(value,**{'sizeinbytes': 2})

    def __delfield_birthyear(self): del self.__field_birthyear

    birthyear=property(__getfield_birthyear, __setfield_birthyear, __delfield_birthyear, None)

    def __getfield_birthmonth(self):
        return self.__field_birthmonth.getvalue()

    def __setfield_birthmonth(self, value):
        if isinstance(value,UINT):
            self.__field_birthmonth=value
        else:
            self.__field_birthmonth=UINT(value,**{'sizeinbytes': 1})

    def __delfield_birthmonth(self): del self.__field_birthmonth

    birthmonth=property(__getfield_birthmonth, __setfield_birthmonth, __delfield_birthmonth, None)

    def __getfield_birthday(self):
        return self.__field_birthday.getvalue()

    def __setfield_birthday(self, value):
        if isinstance(value,UINT):
            self.__field_birthday=value
        else:
            self.__field_birthday=UINT(value,**{'sizeinbytes': 1})

    def __delfield_birthday(self): del self.__field_birthday

    birthday=property(__getfield_birthday, __setfield_birthday, __delfield_birthday, None)

    def __getfield_bloodtype(self):
        return self.__field_bloodtype.getvalue()

    def __setfield_bloodtype(self, value):
        if isinstance(value,UINT):
            self.__field_bloodtype=value
        else:
            self.__field_bloodtype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_bloodtype(self): del self.__field_bloodtype

    bloodtype=property(__getfield_bloodtype, __setfield_bloodtype, __delfield_bloodtype, "0: ?, 1: A, 2: B, 3: O, 4: AB")

    def __getfield_address(self):
        return self.__field_address.getvalue()

    def __setfield_address(self, value):
        if isinstance(value,USTRING):
            self.__field_address=value
        else:
            self.__field_address=USTRING(value,**{'sizeinbytes': 96, 'raiseonunterminatedread': False})

    def __delfield_address(self): del self.__field_address

    address=property(__getfield_address, __setfield_address, __delfield_address, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 14})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 14})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def __getfield_homeemail(self):
        return self.__field_homeemail.getvalue()

    def __setfield_homeemail(self, value):
        if isinstance(value,USTRING):
            self.__field_homeemail=value
        else:
            self.__field_homeemail=USTRING(value,**{'sizeinbytes': 48, 'raiseonunterminatedread': False})

    def __delfield_homeemail(self): del self.__field_homeemail

    homeemail=property(__getfield_homeemail, __setfield_homeemail, __delfield_homeemail, None)

    def __getfield_workemail(self):
        return self.__field_workemail.getvalue()

    def __setfield_workemail(self, value):
        if isinstance(value,USTRING):
            self.__field_workemail=value
        else:
            self.__field_workemail=USTRING(value,**{'sizeinbytes': 48, 'raiseonunterminatedread': False})

    def __delfield_workemail(self): del self.__field_workemail

    workemail=property(__getfield_workemail, __setfield_workemail, __delfield_workemail, None)

    def __getfield_homephone(self):
        return self.__field_homephone.getvalue()

    def __setfield_homephone(self, value):
        if isinstance(value,USTRING):
            self.__field_homephone=value
        else:
            self.__field_homephone=USTRING(value,**{'sizeinbytes': 48, 'raiseonunterminatedread': False})

    def __delfield_homephone(self): del self.__field_homephone

    homephone=property(__getfield_homephone, __setfield_homephone, __delfield_homephone, None)

    def __getfield_workphone(self):
        return self.__field_workphone.getvalue()

    def __setfield_workphone(self, value):
        if isinstance(value,USTRING):
            self.__field_workphone=value
        else:
            self.__field_workphone=USTRING(value,**{'sizeinbytes': 48, 'raiseonunterminatedread': False})

    def __delfield_workphone(self): del self.__field_workphone

    workphone=property(__getfield_workphone, __setfield_workphone, __delfield_workphone, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('ownername', self.__field_ownername, None)
        yield ('birthyear', self.__field_birthyear, None)
        yield ('birthmonth', self.__field_birthmonth, None)
        yield ('birthday', self.__field_birthday, None)
        yield ('bloodtype', self.__field_bloodtype, "0: ?, 1: A, 2: B, 3: O, 4: AB")
        yield ('address', self.__field_address, None)
        yield ('pad', self.__field_pad, None)
        yield ('homeemail', self.__field_homeemail, None)
        yield ('workemail', self.__field_workemail, None)
        yield ('homephone', self.__field_homephone, None)
        yield ('workphone', self.__field_workphone, None)




class ownerinforesponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ownerinforesponse,self).__init__(**dict)
        if self.__class__ is ownerinforesponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ownerinforesponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ownerinforesponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=ownerentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 178})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,ownerentry):
            self.__field_entry=value
        else:
            self.__field_entry=ownerentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 178})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class eventrequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventrequest,self).__init__(**dict)
        if self.__class__ is eventrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x23})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x23})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x23})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,		'command': 0x23})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class evententry(BaseProtogenClass):
    __fields=['slot', 'flag', 'eventname', 'pad1', 'eventname_len', 'start', 'end', 'location', 'pad2', 'location_len', 'ringtone', 'alarmdiff', 'period', 'dom', 'alarm', 'serial']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(evententry,self).__init__(**dict)
        if self.__class__ is evententry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(evententry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(evententry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        self.__field_eventname.writetobuffer(buf)
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad1.writetobuffer(buf)
        self.__field_eventname_len.writetobuffer(buf)
        self.__field_start.writetobuffer(buf)
        self.__field_end.writetobuffer(buf)
        self.__field_location.writetobuffer(buf)
        try: self.__field_pad2
        except:
            self.__field_pad2=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad2.writetobuffer(buf)
        self.__field_location_len.writetobuffer(buf)
        self.__field_ringtone.writetobuffer(buf)
        self.__field_alarmdiff.writetobuffer(buf)
        self.__field_period.writetobuffer(buf)
        self.__field_dom.writetobuffer(buf)
        self.__field_alarm.writetobuffer(buf)
        try: self.__field_serial
        except:
            self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_serial.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_eventname=USTRING(**{'sizeinbytes': 14, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_eventname.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_eventname_len=UINT(**{'sizeinbytes': 1})
        self.__field_eventname_len.readfrombuffer(buf)
        self.__field_start=UINT(**{'sizeinbytes': 4})
        self.__field_start.readfrombuffer(buf)
        self.__field_end=UINT(**{'sizeinbytes': 4})
        self.__field_end.readfrombuffer(buf)
        self.__field_location=USTRING(**{'sizeinbytes': 14, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_location.readfrombuffer(buf)
        self.__field_pad2=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad2.readfrombuffer(buf)
        self.__field_location_len=UINT(**{'sizeinbytes': 1})
        self.__field_location_len.readfrombuffer(buf)
        self.__field_ringtone=UINT(**{'sizeinbytes': 1})
        self.__field_ringtone.readfrombuffer(buf)
        self.__field_alarmdiff=UINT(**{'sizeinbytes': 4})
        self.__field_alarmdiff.readfrombuffer(buf)
        self.__field_period=UINT(**{'sizeinbytes': 1})
        self.__field_period.readfrombuffer(buf)
        self.__field_dom=UINT(**{'sizeinbytes': 1})
        self.__field_dom.readfrombuffer(buf)
        self.__field_alarm=UINT(**{'sizeinbytes': 4})
        self.__field_alarm.readfrombuffer(buf)
        self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_serial.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, "0: Not used, 1: Scheduled, 2: Already Happened")

    def __getfield_eventname(self):
        return self.__field_eventname.getvalue()

    def __setfield_eventname(self, value):
        if isinstance(value,USTRING):
            self.__field_eventname=value
        else:
            self.__field_eventname=USTRING(value,**{'sizeinbytes': 14, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_eventname(self): del self.__field_eventname

    eventname=property(__getfield_eventname, __setfield_eventname, __delfield_eventname, None)

    def __getfield_pad1(self):
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 7})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_eventname_len(self):
        return self.__field_eventname_len.getvalue()

    def __setfield_eventname_len(self, value):
        if isinstance(value,UINT):
            self.__field_eventname_len=value
        else:
            self.__field_eventname_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_eventname_len(self): del self.__field_eventname_len

    eventname_len=property(__getfield_eventname_len, __setfield_eventname_len, __delfield_eventname_len, None)

    def __getfield_start(self):
        return self.__field_start.getvalue()

    def __setfield_start(self, value):
        if isinstance(value,UINT):
            self.__field_start=value
        else:
            self.__field_start=UINT(value,**{'sizeinbytes': 4})

    def __delfield_start(self): del self.__field_start

    start=property(__getfield_start, __setfield_start, __delfield_start, "# seconds since Jan 1, 1980 approximately")

    def __getfield_end(self):
        return self.__field_end.getvalue()

    def __setfield_end(self, value):
        if isinstance(value,UINT):
            self.__field_end=value
        else:
            self.__field_end=UINT(value,**{'sizeinbytes': 4})

    def __delfield_end(self): del self.__field_end

    end=property(__getfield_end, __setfield_end, __delfield_end, None)

    def __getfield_location(self):
        return self.__field_location.getvalue()

    def __setfield_location(self, value):
        if isinstance(value,USTRING):
            self.__field_location=value
        else:
            self.__field_location=USTRING(value,**{'sizeinbytes': 14, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_location(self): del self.__field_location

    location=property(__getfield_location, __setfield_location, __delfield_location, None)

    def __getfield_pad2(self):
        try: self.__field_pad2
        except:
            self.__field_pad2=UNKNOWN(**{'sizeinbytes': 7})
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad2=value
        else:
            self.__field_pad2=UNKNOWN(value,**{'sizeinbytes': 7})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def __getfield_location_len(self):
        return self.__field_location_len.getvalue()

    def __setfield_location_len(self, value):
        if isinstance(value,UINT):
            self.__field_location_len=value
        else:
            self.__field_location_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_location_len(self): del self.__field_location_len

    location_len=property(__getfield_location_len, __setfield_location_len, __delfield_location_len, None)

    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 1})

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, "0: Beep, 1: Voice, 2: Silent")

    def __getfield_alarmdiff(self):
        return self.__field_alarmdiff.getvalue()

    def __setfield_alarmdiff(self, value):
        if isinstance(value,UINT):
            self.__field_alarmdiff=value
        else:
            self.__field_alarmdiff=UINT(value,**{'sizeinbytes': 4})

    def __delfield_alarmdiff(self): del self.__field_alarmdiff

    alarmdiff=property(__getfield_alarmdiff, __setfield_alarmdiff, __delfield_alarmdiff, "Displayed alarm time")

    def __getfield_period(self):
        return self.__field_period.getvalue()

    def __setfield_period(self, value):
        if isinstance(value,UINT):
            self.__field_period=value
        else:
            self.__field_period=UINT(value,**{'sizeinbytes': 1})

    def __delfield_period(self): del self.__field_period

    period=property(__getfield_period, __setfield_period, __delfield_period, "No, Daily, Weekly, Monthly, Yearly")

    def __getfield_dom(self):
        return self.__field_dom.getvalue()

    def __setfield_dom(self, value):
        if isinstance(value,UINT):
            self.__field_dom=value
        else:
            self.__field_dom=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dom(self): del self.__field_dom

    dom=property(__getfield_dom, __setfield_dom, __delfield_dom, "Day of month for the event")

    def __getfield_alarm(self):
        return self.__field_alarm.getvalue()

    def __setfield_alarm(self, value):
        if isinstance(value,UINT):
            self.__field_alarm=value
        else:
            self.__field_alarm=UINT(value,**{'sizeinbytes': 4})

    def __delfield_alarm(self): del self.__field_alarm

    alarm=property(__getfield_alarm, __setfield_alarm, __delfield_alarm, None)

    def __getfield_serial(self):
        try: self.__field_serial
        except:
            self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_serial.getvalue()

    def __setfield_serial(self, value):
        if isinstance(value,UINT):
            self.__field_serial=value
        else:
            self.__field_serial=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_serial(self): del self.__field_serial

    serial=property(__getfield_serial, __setfield_serial, __delfield_serial, "Some kind of serial number")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('flag', self.__field_flag, "0: Not used, 1: Scheduled, 2: Already Happened")
        yield ('eventname', self.__field_eventname, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('eventname_len', self.__field_eventname_len, None)
        yield ('start', self.__field_start, "# seconds since Jan 1, 1980 approximately")
        yield ('end', self.__field_end, None)
        yield ('location', self.__field_location, None)
        yield ('pad2', self.__field_pad2, None)
        yield ('location_len', self.__field_location_len, None)
        yield ('ringtone', self.__field_ringtone, "0: Beep, 1: Voice, 2: Silent")
        yield ('alarmdiff', self.__field_alarmdiff, "Displayed alarm time")
        yield ('period', self.__field_period, "No, Daily, Weekly, Monthly, Yearly")
        yield ('dom', self.__field_dom, "Day of month for the event")
        yield ('alarm', self.__field_alarm, None)
        yield ('serial', self.__field_serial, "Some kind of serial number")




class eventresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventresponse,self).__init__(**dict)
        if self.__class__ is eventresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=evententry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 436})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,evententry):
            self.__field_entry=value
        else:
            self.__field_entry=evententry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 436})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class eventupdaterequest(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(eventupdaterequest,self).__init__(**dict)
        if self.__class__ is eventupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(eventupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(eventupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'readwrite': 0x0e,                   'packettype': 0x0c, 'command':0x23})
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 436})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'readwrite': 0x0e,                   'packettype': 0x0c, 'command':0x23})
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=evententry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 436})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'readwrite': 0x0e,                   'packettype': 0x0c, 'command':0x23})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'readwrite': 0x0e,                   'packettype': 0x0c, 'command':0x23})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,evententry):
            self.__field_entry=value
        else:
            self.__field_entry=evententry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 436})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 436})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class callalarmrequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callalarmrequest,self).__init__(**dict)
        if self.__class__ is callalarmrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callalarmrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callalarmrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x24})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x24})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x24})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,		'command': 0x24})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class callalarmentry(BaseProtogenClass):
    __fields=['ringtone', 'slot', 'flag', 'dunno1', 'phonenum', 'phonenum_len', 'date', 'period', 'dom', 'datedup', 'name', 'pad1', 'name_len', 'phonenumbertype', 'phonenumberslot', 'serial']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callalarmentry,self).__init__(**dict)
        if self.__class__ is callalarmentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callalarmentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callalarmentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_ringtone
        except:
            self.__field_ringtone=UINT(**{'constant': 0})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        try: self.__field_dunno1
        except:
            self.__field_dunno1=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_dunno1.writetobuffer(buf)
        self.__field_phonenum.writetobuffer(buf)
        self.__field_phonenum_len.writetobuffer(buf)
        self.__field_date.writetobuffer(buf)
        self.__field_period.writetobuffer(buf)
        self.__field_dom.writetobuffer(buf)
        self.__field_datedup.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad1.writetobuffer(buf)
        self.__field_name_len.writetobuffer(buf)
        self.__field_phonenumbertype.writetobuffer(buf)
        self.__field_phonenumberslot.writetobuffer(buf)
        try: self.__field_serial
        except:
            self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_serial.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_dunno1=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_phonenum=USTRING(**{'sizeinbytes': 49, 'raiseonunterminatedread': False})
        self.__field_phonenum.readfrombuffer(buf)
        self.__field_phonenum_len=UINT(**{'sizeinbytes': 1})
        self.__field_phonenum_len.readfrombuffer(buf)
        self.__field_date=UINT(**{'sizeinbytes': 4})
        self.__field_date.readfrombuffer(buf)
        self.__field_period=UINT(**{'sizeinbytes': 1})
        self.__field_period.readfrombuffer(buf)
        self.__field_dom=UINT(**{'sizeinbytes': 1})
        self.__field_dom.readfrombuffer(buf)
        self.__field_datedup=UINT(**{'sizeinbytes': 4})
        self.__field_datedup.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_name.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_name_len=UINT(**{'sizeinbytes': 1})
        self.__field_name_len.readfrombuffer(buf)
        self.__field_phonenumbertype=UINT(**{'sizeinbytes': 1})
        self.__field_phonenumbertype.readfrombuffer(buf)
        self.__field_phonenumberslot=UINT(**{'sizeinbytes': 2})
        self.__field_phonenumberslot.readfrombuffer(buf)
        self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_serial.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'constant': 0})

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, "0: Not used, 1: Scheduled, 2: Already Happened")

    def __getfield_dunno1(self):
        try: self.__field_dunno1
        except:
            self.__field_dunno1=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UINT):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, "Related to Snooze?")

    def __getfield_phonenum(self):
        return self.__field_phonenum.getvalue()

    def __setfield_phonenum(self, value):
        if isinstance(value,USTRING):
            self.__field_phonenum=value
        else:
            self.__field_phonenum=USTRING(value,**{'sizeinbytes': 49, 'raiseonunterminatedread': False})

    def __delfield_phonenum(self): del self.__field_phonenum

    phonenum=property(__getfield_phonenum, __setfield_phonenum, __delfield_phonenum, None)

    def __getfield_phonenum_len(self):
        return self.__field_phonenum_len.getvalue()

    def __setfield_phonenum_len(self, value):
        if isinstance(value,UINT):
            self.__field_phonenum_len=value
        else:
            self.__field_phonenum_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenum_len(self): del self.__field_phonenum_len

    phonenum_len=property(__getfield_phonenum_len, __setfield_phonenum_len, __delfield_phonenum_len, None)

    def __getfield_date(self):
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,UINT):
            self.__field_date=value
        else:
            self.__field_date=UINT(value,**{'sizeinbytes': 4})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, "# seconds since Jan 1, 1980 approximately")

    def __getfield_period(self):
        return self.__field_period.getvalue()

    def __setfield_period(self, value):
        if isinstance(value,UINT):
            self.__field_period=value
        else:
            self.__field_period=UINT(value,**{'sizeinbytes': 1})

    def __delfield_period(self): del self.__field_period

    period=property(__getfield_period, __setfield_period, __delfield_period, "No, Daily, Weekly, Monthly, Yearly")

    def __getfield_dom(self):
        return self.__field_dom.getvalue()

    def __setfield_dom(self, value):
        if isinstance(value,UINT):
            self.__field_dom=value
        else:
            self.__field_dom=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dom(self): del self.__field_dom

    dom=property(__getfield_dom, __setfield_dom, __delfield_dom, "Day of month for the event")

    def __getfield_datedup(self):
        return self.__field_datedup.getvalue()

    def __setfield_datedup(self, value):
        if isinstance(value,UINT):
            self.__field_datedup=value
        else:
            self.__field_datedup=UINT(value,**{'sizeinbytes': 4})

    def __delfield_datedup(self): del self.__field_datedup

    datedup=property(__getfield_datedup, __setfield_datedup, __delfield_datedup, "Copy of the date.  Always the same???")

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_pad1(self):
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_name_len(self):
        return self.__field_name_len.getvalue()

    def __setfield_name_len(self, value):
        if isinstance(value,UINT):
            self.__field_name_len=value
        else:
            self.__field_name_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_name_len(self): del self.__field_name_len

    name_len=property(__getfield_name_len, __setfield_name_len, __delfield_name_len, None)

    def __getfield_phonenumbertype(self):
        return self.__field_phonenumbertype.getvalue()

    def __setfield_phonenumbertype(self, value):
        if isinstance(value,UINT):
            self.__field_phonenumbertype=value
        else:
            self.__field_phonenumbertype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenumbertype(self): del self.__field_phonenumbertype

    phonenumbertype=property(__getfield_phonenumbertype, __setfield_phonenumbertype, __delfield_phonenumbertype, "1: Home, 2: Work, ...")

    def __getfield_phonenumberslot(self):
        return self.__field_phonenumberslot.getvalue()

    def __setfield_phonenumberslot(self, value):
        if isinstance(value,UINT):
            self.__field_phonenumberslot=value
        else:
            self.__field_phonenumberslot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_phonenumberslot(self): del self.__field_phonenumberslot

    phonenumberslot=property(__getfield_phonenumberslot, __setfield_phonenumberslot, __delfield_phonenumberslot, None)

    def __getfield_serial(self):
        try: self.__field_serial
        except:
            self.__field_serial=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_serial.getvalue()

    def __setfield_serial(self, value):
        if isinstance(value,UINT):
            self.__field_serial=value
        else:
            self.__field_serial=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_serial(self): del self.__field_serial

    serial=property(__getfield_serial, __setfield_serial, __delfield_serial, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('ringtone', self.__field_ringtone, None)
        yield ('slot', self.__field_slot, None)
        yield ('flag', self.__field_flag, "0: Not used, 1: Scheduled, 2: Already Happened")
        yield ('dunno1', self.__field_dunno1, "Related to Snooze?")
        yield ('phonenum', self.__field_phonenum, None)
        yield ('phonenum_len', self.__field_phonenum_len, None)
        yield ('date', self.__field_date, "# seconds since Jan 1, 1980 approximately")
        yield ('period', self.__field_period, "No, Daily, Weekly, Monthly, Yearly")
        yield ('dom', self.__field_dom, "Day of month for the event")
        yield ('datedup', self.__field_datedup, "Copy of the date.  Always the same???")
        yield ('name', self.__field_name, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('name_len', self.__field_name_len, None)
        yield ('phonenumbertype', self.__field_phonenumbertype, "1: Home, 2: Work, ...")
        yield ('phonenumberslot', self.__field_phonenumberslot, None)
        yield ('serial', self.__field_serial, None)




class callalarmresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callalarmresponse,self).__init__(**dict)
        if self.__class__ is callalarmresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callalarmresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callalarmresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=callalarmentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 417})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,callalarmentry):
            self.__field_entry=value
        else:
            self.__field_entry=callalarmentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 417})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class callalarmupdaterequest(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(callalarmupdaterequest,self).__init__(**dict)
        if self.__class__ is callalarmupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(callalarmupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(callalarmupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'readwrite': 0x0e,                   'packettype': 0x0c, 'command':0x24})
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 417})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'readwrite': 0x0e,                   'packettype': 0x0c, 'command':0x24})
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=callalarmentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 417})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'readwrite': 0x0e,                   'packettype': 0x0c, 'command':0x24})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'readwrite': 0x0e,                   'packettype': 0x0c, 'command':0x24})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,callalarmentry):
            self.__field_entry=value
        else:
            self.__field_entry=callalarmentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 417})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 417})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class todorequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(todorequest,self).__init__(**dict)
        if self.__class__ is todorequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(todorequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(todorequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x25})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x25})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,		'command': 0x25})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,		'command': 0x25})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class todoentry(BaseProtogenClass):
    __fields=['slot', 'flag', 'todo', 'pad1', 'todo_len', 'priority', 'dunno', 'order']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(todoentry,self).__init__(**dict)
        if self.__class__ is todoentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(todoentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(todoentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        self.__field_todo.writetobuffer(buf)
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad1.writetobuffer(buf)
        self.__field_todo_len.writetobuffer(buf)
        self.__field_priority.writetobuffer(buf)
        try: self.__field_dunno
        except:
            self.__field_dunno=UINT(**{'sizeinbytes': 1})
        self.__field_dunno.writetobuffer(buf)
        self.__field_order.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_todo=USTRING(**{'sizeinbytes': 14, 'raiseonunterminatedread': False})
        self.__field_todo.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_todo_len=UINT(**{'sizeinbytes': 1})
        self.__field_todo_len.readfrombuffer(buf)
        self.__field_priority=UINT(**{'sizeinbytes': 1})
        self.__field_priority.readfrombuffer(buf)
        self.__field_dunno=UINT(**{'sizeinbytes': 1})
        self.__field_dunno.readfrombuffer(buf)
        self.__field_order=UINT(**{'sizeinbytes': 1})
        self.__field_order.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, "0: Not used, 1: Used")

    def __getfield_todo(self):
        return self.__field_todo.getvalue()

    def __setfield_todo(self, value):
        if isinstance(value,USTRING):
            self.__field_todo=value
        else:
            self.__field_todo=USTRING(value,**{'sizeinbytes': 14, 'raiseonunterminatedread': False})

    def __delfield_todo(self): del self.__field_todo

    todo=property(__getfield_todo, __setfield_todo, __delfield_todo, None)

    def __getfield_pad1(self):
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 7})
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 7})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_todo_len(self):
        return self.__field_todo_len.getvalue()

    def __setfield_todo_len(self, value):
        if isinstance(value,UINT):
            self.__field_todo_len=value
        else:
            self.__field_todo_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_todo_len(self): del self.__field_todo_len

    todo_len=property(__getfield_todo_len, __setfield_todo_len, __delfield_todo_len, None)

    def __getfield_priority(self):
        return self.__field_priority.getvalue()

    def __setfield_priority(self, value):
        if isinstance(value,UINT):
            self.__field_priority=value
        else:
            self.__field_priority=UINT(value,**{'sizeinbytes': 1})

    def __delfield_priority(self): del self.__field_priority

    priority=property(__getfield_priority, __setfield_priority, __delfield_priority, "0: Normal, 1: Urgent, 2: Done")

    def __getfield_dunno(self):
        try: self.__field_dunno
        except:
            self.__field_dunno=UINT(**{'sizeinbytes': 1})
        return self.__field_dunno.getvalue()

    def __setfield_dunno(self, value):
        if isinstance(value,UINT):
            self.__field_dunno=value
        else:
            self.__field_dunno=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno(self): del self.__field_dunno

    dunno=property(__getfield_dunno, __setfield_dunno, __delfield_dunno, "Maybe always zero")

    def __getfield_order(self):
        return self.__field_order.getvalue()

    def __setfield_order(self, value):
        if isinstance(value,UINT):
            self.__field_order=value
        else:
            self.__field_order=UINT(value,**{'sizeinbytes': 1})

    def __delfield_order(self): del self.__field_order

    order=property(__getfield_order, __setfield_order, __delfield_order, "Gets sorted on screen in this order")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('flag', self.__field_flag, "0: Not used, 1: Used")
        yield ('todo', self.__field_todo, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('todo_len', self.__field_todo_len, None)
        yield ('priority', self.__field_priority, "0: Normal, 1: Urgent, 2: Done")
        yield ('dunno', self.__field_dunno, "Maybe always zero")
        yield ('order', self.__field_order, "Gets sorted on screen in this order")




class todoresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(todoresponse,self).__init__(**dict)
        if self.__class__ is todoresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(todoresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(todoresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=todoentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 472})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,todoentry):
            self.__field_entry=value
        else:
            self.__field_entry=todoentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 472})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class holidaybitsrequest(BaseProtogenClass):
    __fields=['unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(holidaybitsrequest,self).__init__(**dict)
        if self.__class__ is holidaybitsrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(holidaybitsrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(holidaybitsrequest,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_unknown=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unknown', self.__field_unknown, None)




class holidaybitsresponse(BaseProtogenClass):
    __fields=['unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(holidaybitsresponse,self).__init__(**dict)
        if self.__class__ is holidaybitsresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(holidaybitsresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(holidaybitsresponse,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_unknown=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unknown', self.__field_unknown, None)




class weeklyholidaybitsrequest(BaseProtogenClass):
    __fields=['unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(weeklyholidaybitsrequest,self).__init__(**dict)
        if self.__class__ is weeklyholidaybitsrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(weeklyholidaybitsrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(weeklyholidaybitsrequest,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_unknown=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unknown', self.__field_unknown, None)




class weeklyholidaybitsresponse(BaseProtogenClass):
    __fields=['unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(weeklyholidaybitsresponse,self).__init__(**dict)
        if self.__class__ is weeklyholidaybitsresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(weeklyholidaybitsresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(weeklyholidaybitsresponse,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_unknown=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unknown', self.__field_unknown, None)




class foldernamerequest(BaseProtogenClass):
    __fields=['header', 'index', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(foldernamerequest,self).__init__(**dict)
        if self.__class__ is foldernamerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(foldernamerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(foldernamerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0b,                   'command': 0xef})
        self.__field_header.writetobuffer(buf)
        self.__field_index.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0b,                   'command': 0xef})
        self.__field_header.readfrombuffer(buf)
        self.__field_index=UINT(**{'sizeinbytes': 1})
        self.__field_index.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0b,                   'command': 0xef})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0b,                   'command': 0xef})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 1})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('index', self.__field_index, None)
        yield ('pad', self.__field_pad, None)




class foldernameentry(BaseProtogenClass):
    __fields=['index', 'flag', 'autofile', 'notify', 'icon', 'name', 'pad', 'keyword']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(foldernameentry,self).__init__(**dict)
        if self.__class__ is foldernameentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(foldernameentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(foldernameentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_index.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        self.__field_autofile.writetobuffer(buf)
        self.__field_notify.writetobuffer(buf)
        self.__field_icon.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad.writetobuffer(buf)
        self.__field_keyword.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_index=UINT(**{'sizeinbytes': 1})
        self.__field_index.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_autofile=UINT(**{'sizeinbytes': 1})
        self.__field_autofile.readfrombuffer(buf)
        self.__field_notify=UINT(**{'sizeinbytes': 1})
        self.__field_notify.readfrombuffer(buf)
        self.__field_icon=UINT(**{'sizeinbytes': 1})
        self.__field_icon.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 13, 'raiseonunterminatedread': False})
        self.__field_name.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 3})
        self.__field_pad.readfrombuffer(buf)
        self.__field_keyword=USTRING(**{'sizeinbytes': 14, 'raiseonunterminatedread': False})
        self.__field_keyword.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_index(self):
        return self.__field_index.getvalue()

    def __setfield_index(self, value):
        if isinstance(value,UINT):
            self.__field_index=value
        else:
            self.__field_index=UINT(value,**{'sizeinbytes': 1})

    def __delfield_index(self): del self.__field_index

    index=property(__getfield_index, __setfield_index, __delfield_index, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, "0 if empty, 1 in use")

    def __getfield_autofile(self):
        return self.__field_autofile.getvalue()

    def __setfield_autofile(self, value):
        if isinstance(value,UINT):
            self.__field_autofile=value
        else:
            self.__field_autofile=UINT(value,**{'sizeinbytes': 1})

    def __delfield_autofile(self): del self.__field_autofile

    autofile=property(__getfield_autofile, __setfield_autofile, __delfield_autofile, "If 1, autofile messages with keyword")

    def __getfield_notify(self):
        return self.__field_notify.getvalue()

    def __setfield_notify(self, value):
        if isinstance(value,UINT):
            self.__field_notify=value
        else:
            self.__field_notify=UINT(value,**{'sizeinbytes': 1})

    def __delfield_notify(self): del self.__field_notify

    notify=property(__getfield_notify, __setfield_notify, __delfield_notify, None)

    def __getfield_icon(self):
        return self.__field_icon.getvalue()

    def __setfield_icon(self, value):
        if isinstance(value,UINT):
            self.__field_icon=value
        else:
            self.__field_icon=UINT(value,**{'sizeinbytes': 1})

    def __delfield_icon(self): del self.__field_icon

    icon=property(__getfield_icon, __setfield_icon, __delfield_icon, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 13, 'raiseonunterminatedread': False})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, "Name of the folder")

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 3})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 3})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def __getfield_keyword(self):
        return self.__field_keyword.getvalue()

    def __setfield_keyword(self, value):
        if isinstance(value,USTRING):
            self.__field_keyword=value
        else:
            self.__field_keyword=USTRING(value,**{'sizeinbytes': 14, 'raiseonunterminatedread': False})

    def __delfield_keyword(self): del self.__field_keyword

    keyword=property(__getfield_keyword, __setfield_keyword, __delfield_keyword, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('index', self.__field_index, None)
        yield ('flag', self.__field_flag, "0 if empty, 1 in use")
        yield ('autofile', self.__field_autofile, "If 1, autofile messages with keyword")
        yield ('notify', self.__field_notify, None)
        yield ('icon', self.__field_icon, None)
        yield ('name', self.__field_name, "Name of the folder")
        yield ('pad', self.__field_pad, None)
        yield ('keyword', self.__field_keyword, None)




class foldernameresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(foldernameresponse,self).__init__(**dict)
        if self.__class__ is foldernameresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(foldernameresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(foldernameresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=foldernameentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 467})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,foldernameentry):
            self.__field_entry=value
        else:
            self.__field_entry=foldernameentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 467})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class messagerequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(messagerequest,self).__init__(**dict)
        if self.__class__ is messagerequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(messagerequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(messagerequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0xe1})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0xe1})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0xe1})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,                   'command': 0xe1})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class messageentry(BaseProtogenClass):
    __fields=['slot', 'messagetype', 'dunno1', 'dunno2', 'dunno3', 'dunno4', 'dunno5', 'dunno6', 'dunno7', 'dunno8', 'dunno9', 'dunno10', 'dunno11', 'message_len', 'message', 'pad1', 'year', 'month', 'day', 'hour', 'minute', 'second', 'phonenum_len', 'phonenum', 'dunno12', 'pad2', 'dunno13', 'folder']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(messageentry,self).__init__(**dict)
        if self.__class__ is messageentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(messageentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(messageentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_messagetype.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self.__field_dunno3.writetobuffer(buf)
        self.__field_dunno4.writetobuffer(buf)
        self.__field_dunno5.writetobuffer(buf)
        self.__field_dunno6.writetobuffer(buf)
        self.__field_dunno7.writetobuffer(buf)
        self.__field_dunno8.writetobuffer(buf)
        self.__field_dunno9.writetobuffer(buf)
        self.__field_dunno10.writetobuffer(buf)
        self.__field_dunno11.writetobuffer(buf)
        self.__field_message_len.writetobuffer(buf)
        self.__field_message.writetobuffer(buf)
        self.__field_pad1.writetobuffer(buf)
        self.__field_year.writetobuffer(buf)
        self.__field_month.writetobuffer(buf)
        self.__field_day.writetobuffer(buf)
        self.__field_hour.writetobuffer(buf)
        self.__field_minute.writetobuffer(buf)
        self.__field_second.writetobuffer(buf)
        self.__field_phonenum_len.writetobuffer(buf)
        self.__field_phonenum.writetobuffer(buf)
        self.__field_dunno12.writetobuffer(buf)
        self.__field_pad2.writetobuffer(buf)
        self.__field_dunno13.writetobuffer(buf)
        self.__field_folder.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_messagetype=UINT(**{'sizeinbytes': 1})
        self.__field_messagetype.readfrombuffer(buf)
        self.__field_dunno1=UINT(**{'sizeinbytes': 1})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_dunno2=UINT(**{'sizeinbytes': 1})
        self.__field_dunno2.readfrombuffer(buf)
        self.__field_dunno3=UINT(**{'sizeinbytes': 1})
        self.__field_dunno3.readfrombuffer(buf)
        self.__field_dunno4=UINT(**{'sizeinbytes': 1})
        self.__field_dunno4.readfrombuffer(buf)
        self.__field_dunno5=UINT(**{'sizeinbytes': 1})
        self.__field_dunno5.readfrombuffer(buf)
        self.__field_dunno6=UINT(**{'sizeinbytes': 1})
        self.__field_dunno6.readfrombuffer(buf)
        self.__field_dunno7=UINT(**{'sizeinbytes': 1})
        self.__field_dunno7.readfrombuffer(buf)
        self.__field_dunno8=UINT(**{'sizeinbytes': 1})
        self.__field_dunno8.readfrombuffer(buf)
        self.__field_dunno9=UINT(**{'sizeinbytes': 1})
        self.__field_dunno9.readfrombuffer(buf)
        self.__field_dunno10=UINT(**{'sizeinbytes': 1})
        self.__field_dunno10.readfrombuffer(buf)
        self.__field_dunno11=UINT(**{'sizeinbytes': 1})
        self.__field_dunno11.readfrombuffer(buf)
        self.__field_message_len=UINT(**{'sizeinbytes': 1})
        self.__field_message_len.readfrombuffer(buf)
        self.__field_message=USTRING(**{'sizeinbytes': 255})
        self.__field_message.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_year=UINT(**{'sizeinbytes': 1})
        self.__field_year.readfrombuffer(buf)
        self.__field_month=UINT(**{'sizeinbytes': 1})
        self.__field_month.readfrombuffer(buf)
        self.__field_day=UINT(**{'sizeinbytes': 1})
        self.__field_day.readfrombuffer(buf)
        self.__field_hour=UINT(**{'sizeinbytes': 1})
        self.__field_hour.readfrombuffer(buf)
        self.__field_minute=UINT(**{'sizeinbytes': 1})
        self.__field_minute.readfrombuffer(buf)
        self.__field_second=UINT(**{'sizeinbytes': 1})
        self.__field_second.readfrombuffer(buf)
        self.__field_phonenum_len=UINT(**{'sizeinbytes': 1})
        self.__field_phonenum_len.readfrombuffer(buf)
        self.__field_phonenum=USTRING(**{'sizeinbytes': 33})
        self.__field_phonenum.readfrombuffer(buf)
        self.__field_dunno12=UINT(**{'sizeinbytes': 1})
        self.__field_dunno12.readfrombuffer(buf)
        self.__field_pad2=UNKNOWN(**{'sizeinbytes': 38})
        self.__field_pad2.readfrombuffer(buf)
        self.__field_dunno13=UINT(**{'sizeinbytes': 1})
        self.__field_dunno13.readfrombuffer(buf)
        self.__field_folder=UINT(**{'sizeinbytes': 1})
        self.__field_folder.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_messagetype(self):
        return self.__field_messagetype.getvalue()

    def __setfield_messagetype(self, value):
        if isinstance(value,UINT):
            self.__field_messagetype=value
        else:
            self.__field_messagetype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_messagetype(self): del self.__field_messagetype

    messagetype=property(__getfield_messagetype, __setfield_messagetype, __delfield_messagetype, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UINT):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UINT):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UINT):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def __getfield_dunno4(self):
        return self.__field_dunno4.getvalue()

    def __setfield_dunno4(self, value):
        if isinstance(value,UINT):
            self.__field_dunno4=value
        else:
            self.__field_dunno4=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno4(self): del self.__field_dunno4

    dunno4=property(__getfield_dunno4, __setfield_dunno4, __delfield_dunno4, None)

    def __getfield_dunno5(self):
        return self.__field_dunno5.getvalue()

    def __setfield_dunno5(self, value):
        if isinstance(value,UINT):
            self.__field_dunno5=value
        else:
            self.__field_dunno5=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno5(self): del self.__field_dunno5

    dunno5=property(__getfield_dunno5, __setfield_dunno5, __delfield_dunno5, None)

    def __getfield_dunno6(self):
        return self.__field_dunno6.getvalue()

    def __setfield_dunno6(self, value):
        if isinstance(value,UINT):
            self.__field_dunno6=value
        else:
            self.__field_dunno6=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno6(self): del self.__field_dunno6

    dunno6=property(__getfield_dunno6, __setfield_dunno6, __delfield_dunno6, None)

    def __getfield_dunno7(self):
        return self.__field_dunno7.getvalue()

    def __setfield_dunno7(self, value):
        if isinstance(value,UINT):
            self.__field_dunno7=value
        else:
            self.__field_dunno7=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno7(self): del self.__field_dunno7

    dunno7=property(__getfield_dunno7, __setfield_dunno7, __delfield_dunno7, None)

    def __getfield_dunno8(self):
        return self.__field_dunno8.getvalue()

    def __setfield_dunno8(self, value):
        if isinstance(value,UINT):
            self.__field_dunno8=value
        else:
            self.__field_dunno8=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno8(self): del self.__field_dunno8

    dunno8=property(__getfield_dunno8, __setfield_dunno8, __delfield_dunno8, None)

    def __getfield_dunno9(self):
        return self.__field_dunno9.getvalue()

    def __setfield_dunno9(self, value):
        if isinstance(value,UINT):
            self.__field_dunno9=value
        else:
            self.__field_dunno9=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno9(self): del self.__field_dunno9

    dunno9=property(__getfield_dunno9, __setfield_dunno9, __delfield_dunno9, None)

    def __getfield_dunno10(self):
        return self.__field_dunno10.getvalue()

    def __setfield_dunno10(self, value):
        if isinstance(value,UINT):
            self.__field_dunno10=value
        else:
            self.__field_dunno10=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno10(self): del self.__field_dunno10

    dunno10=property(__getfield_dunno10, __setfield_dunno10, __delfield_dunno10, None)

    def __getfield_dunno11(self):
        return self.__field_dunno11.getvalue()

    def __setfield_dunno11(self, value):
        if isinstance(value,UINT):
            self.__field_dunno11=value
        else:
            self.__field_dunno11=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno11(self): del self.__field_dunno11

    dunno11=property(__getfield_dunno11, __setfield_dunno11, __delfield_dunno11, None)

    def __getfield_message_len(self):
        return self.__field_message_len.getvalue()

    def __setfield_message_len(self, value):
        if isinstance(value,UINT):
            self.__field_message_len=value
        else:
            self.__field_message_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_message_len(self): del self.__field_message_len

    message_len=property(__getfield_message_len, __setfield_message_len, __delfield_message_len, None)

    def __getfield_message(self):
        return self.__field_message.getvalue()

    def __setfield_message(self, value):
        if isinstance(value,USTRING):
            self.__field_message=value
        else:
            self.__field_message=USTRING(value,**{'sizeinbytes': 255})

    def __delfield_message(self): del self.__field_message

    message=property(__getfield_message, __setfield_message, __delfield_message, "Text of the notification")

    def __getfield_pad1(self):
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_year(self):
        return self.__field_year.getvalue()

    def __setfield_year(self, value):
        if isinstance(value,UINT):
            self.__field_year=value
        else:
            self.__field_year=UINT(value,**{'sizeinbytes': 1})

    def __delfield_year(self): del self.__field_year

    year=property(__getfield_year, __setfield_year, __delfield_year, None)

    def __getfield_month(self):
        return self.__field_month.getvalue()

    def __setfield_month(self, value):
        if isinstance(value,UINT):
            self.__field_month=value
        else:
            self.__field_month=UINT(value,**{'sizeinbytes': 1})

    def __delfield_month(self): del self.__field_month

    month=property(__getfield_month, __setfield_month, __delfield_month, None)

    def __getfield_day(self):
        return self.__field_day.getvalue()

    def __setfield_day(self, value):
        if isinstance(value,UINT):
            self.__field_day=value
        else:
            self.__field_day=UINT(value,**{'sizeinbytes': 1})

    def __delfield_day(self): del self.__field_day

    day=property(__getfield_day, __setfield_day, __delfield_day, None)

    def __getfield_hour(self):
        return self.__field_hour.getvalue()

    def __setfield_hour(self, value):
        if isinstance(value,UINT):
            self.__field_hour=value
        else:
            self.__field_hour=UINT(value,**{'sizeinbytes': 1})

    def __delfield_hour(self): del self.__field_hour

    hour=property(__getfield_hour, __setfield_hour, __delfield_hour, None)

    def __getfield_minute(self):
        return self.__field_minute.getvalue()

    def __setfield_minute(self, value):
        if isinstance(value,UINT):
            self.__field_minute=value
        else:
            self.__field_minute=UINT(value,**{'sizeinbytes': 1})

    def __delfield_minute(self): del self.__field_minute

    minute=property(__getfield_minute, __setfield_minute, __delfield_minute, None)

    def __getfield_second(self):
        return self.__field_second.getvalue()

    def __setfield_second(self, value):
        if isinstance(value,UINT):
            self.__field_second=value
        else:
            self.__field_second=UINT(value,**{'sizeinbytes': 1})

    def __delfield_second(self): del self.__field_second

    second=property(__getfield_second, __setfield_second, __delfield_second, None)

    def __getfield_phonenum_len(self):
        return self.__field_phonenum_len.getvalue()

    def __setfield_phonenum_len(self, value):
        if isinstance(value,UINT):
            self.__field_phonenum_len=value
        else:
            self.__field_phonenum_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenum_len(self): del self.__field_phonenum_len

    phonenum_len=property(__getfield_phonenum_len, __setfield_phonenum_len, __delfield_phonenum_len, None)

    def __getfield_phonenum(self):
        return self.__field_phonenum.getvalue()

    def __setfield_phonenum(self, value):
        if isinstance(value,USTRING):
            self.__field_phonenum=value
        else:
            self.__field_phonenum=USTRING(value,**{'sizeinbytes': 33})

    def __delfield_phonenum(self): del self.__field_phonenum

    phonenum=property(__getfield_phonenum, __setfield_phonenum, __delfield_phonenum, None)

    def __getfield_dunno12(self):
        return self.__field_dunno12.getvalue()

    def __setfield_dunno12(self, value):
        if isinstance(value,UINT):
            self.__field_dunno12=value
        else:
            self.__field_dunno12=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno12(self): del self.__field_dunno12

    dunno12=property(__getfield_dunno12, __setfield_dunno12, __delfield_dunno12, None)

    def __getfield_pad2(self):
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad2=value
        else:
            self.__field_pad2=UNKNOWN(value,**{'sizeinbytes': 38})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def __getfield_dunno13(self):
        return self.__field_dunno13.getvalue()

    def __setfield_dunno13(self, value):
        if isinstance(value,UINT):
            self.__field_dunno13=value
        else:
            self.__field_dunno13=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno13(self): del self.__field_dunno13

    dunno13=property(__getfield_dunno13, __setfield_dunno13, __delfield_dunno13, None)

    def __getfield_folder(self):
        return self.__field_folder.getvalue()

    def __setfield_folder(self, value):
        if isinstance(value,UINT):
            self.__field_folder=value
        else:
            self.__field_folder=UINT(value,**{'sizeinbytes': 1})

    def __delfield_folder(self): del self.__field_folder

    folder=property(__getfield_folder, __setfield_folder, __delfield_folder, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('messagetype', self.__field_messagetype, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('dunno2', self.__field_dunno2, None)
        yield ('dunno3', self.__field_dunno3, None)
        yield ('dunno4', self.__field_dunno4, None)
        yield ('dunno5', self.__field_dunno5, None)
        yield ('dunno6', self.__field_dunno6, None)
        yield ('dunno7', self.__field_dunno7, None)
        yield ('dunno8', self.__field_dunno8, None)
        yield ('dunno9', self.__field_dunno9, None)
        yield ('dunno10', self.__field_dunno10, None)
        yield ('dunno11', self.__field_dunno11, None)
        yield ('message_len', self.__field_message_len, None)
        yield ('message', self.__field_message, "Text of the notification")
        yield ('pad1', self.__field_pad1, None)
        yield ('year', self.__field_year, None)
        yield ('month', self.__field_month, None)
        yield ('day', self.__field_day, None)
        yield ('hour', self.__field_hour, None)
        yield ('minute', self.__field_minute, None)
        yield ('second', self.__field_second, None)
        yield ('phonenum_len', self.__field_phonenum_len, None)
        yield ('phonenum', self.__field_phonenum, None)
        yield ('dunno12', self.__field_dunno12, None)
        yield ('pad2', self.__field_pad2, None)
        yield ('dunno13', self.__field_dunno13, None)
        yield ('folder', self.__field_folder, None)




class messageresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(messageresponse,self).__init__(**dict)
        if self.__class__ is messageresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(messageresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(messageresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=messageentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 151})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,messageentry):
            self.__field_entry=value
        else:
            self.__field_entry=messageentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 151})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class historyrequest(BaseProtogenClass):
    __fields=['type', 'header', 'header', 'header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historyrequest,self).__init__(**dict)
        if self.__class__ is historyrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historyrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historyrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_type
        except:
            self.__field_type=UINT()


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if self.type==OUTGOING:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3d})
            self.__field_header.writetobuffer(buf)
        if self.type==INCOMING:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3e})
            self.__field_header.writetobuffer(buf)
        if self.type==MISSED:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3f})
            self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        if self.type==OUTGOING:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3d})
            self.__field_header.readfrombuffer(buf)
        if self.type==INCOMING:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3e})
            self.__field_header.readfrombuffer(buf)
        if self.type==MISSED:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3f})
            self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_type(self):
        return self.__field_type.getvalue()

    def __setfield_type(self, value):
        if isinstance(value,UINT):
            self.__field_type=value
        else:
            self.__field_type=UINT(value,)

    def __delfield_type(self): del self.__field_type

    type=property(__getfield_type, __setfield_type, __delfield_type, "0: Outgoing, 1: Incoming, 2: Missed")

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3d})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x3d})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3e})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x3e})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x3f})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x3f})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('type', self.__field_type, "0: Outgoing, 1: Incoming, 2: Missed")
        if self.type==OUTGOING:
            yield ('header', self.__field_header, None)
        if self.type==INCOMING:
            yield ('header', self.__field_header, None)
        if self.type==MISSED:
            yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class historymiscrequest(BaseProtogenClass):
    __fields=['type', 'header', 'header', 'header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historymiscrequest,self).__init__(**dict)
        if self.__class__ is historymiscrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historymiscrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historymiscrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_type
        except:
            self.__field_type=UINT()


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if self.type==OUTGOING:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x60})
            self.__field_header.writetobuffer(buf)
        if self.type==INCOMING:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x61})
            self.__field_header.writetobuffer(buf)
        if self.type==MISSED:
            try: self.__field_header
            except:
                self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x62})
            self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        if self.type==OUTGOING:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x60})
            self.__field_header.readfrombuffer(buf)
        if self.type==INCOMING:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x61})
            self.__field_header.readfrombuffer(buf)
        if self.type==MISSED:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x62})
            self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_type(self):
        return self.__field_type.getvalue()

    def __setfield_type(self, value):
        if isinstance(value,UINT):
            self.__field_type=value
        else:
            self.__field_type=UINT(value,)

    def __delfield_type(self): del self.__field_type

    type=property(__getfield_type, __setfield_type, __delfield_type, "0: Outgoing, 1: Incoming, 2: Missed")

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x60})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x60})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x61})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x61})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'command': 0x62})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'command': 0x62})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('type', self.__field_type, "0: Outgoing, 1: Incoming, 2: Missed")
        if self.type==OUTGOING:
            yield ('header', self.__field_header, None)
        if self.type==INCOMING:
            yield ('header', self.__field_header, None)
        if self.type==MISSED:
            yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class historyentry(BaseProtogenClass):
    __fields=['slot', 'dunno1', 'date', 'phonenumlen', 'phonenum', 'name', 'dunno2', 'dunno3']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historyentry,self).__init__(**dict)
        if self.__class__ is historyentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historyentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historyentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_date.writetobuffer(buf)
        self.__field_phonenumlen.writetobuffer(buf)
        self.__field_phonenum.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self.__field_dunno3.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 2})
        self.__field_slot.readfrombuffer(buf)
        self.__field_dunno1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_date=GPSDATE(**{'sizeinbytes': 4})
        self.__field_date.readfrombuffer(buf)
        self.__field_phonenumlen=UINT(**{'sizeinbytes': 1})
        self.__field_phonenumlen.readfrombuffer(buf)
        self.__field_phonenum=USTRING(**{'sizeinbytes': 48, 'raiseonunterminatedread': False})
        self.__field_phonenum.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_name.readfrombuffer(buf)
        self.__field_dunno2=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_dunno2.readfrombuffer(buf)
        self.__field_dunno3=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_dunno3.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_date(self):
        return self.__field_date.getvalue()

    def __setfield_date(self, value):
        if isinstance(value,GPSDATE):
            self.__field_date=value
        else:
            self.__field_date=GPSDATE(value,**{'sizeinbytes': 4})

    def __delfield_date(self): del self.__field_date

    date=property(__getfield_date, __setfield_date, __delfield_date, None)

    def __getfield_phonenumlen(self):
        return self.__field_phonenumlen.getvalue()

    def __setfield_phonenumlen(self, value):
        if isinstance(value,UINT):
            self.__field_phonenumlen=value
        else:
            self.__field_phonenumlen=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenumlen(self): del self.__field_phonenumlen

    phonenumlen=property(__getfield_phonenumlen, __setfield_phonenumlen, __delfield_phonenumlen, None)

    def __getfield_phonenum(self):
        return self.__field_phonenum.getvalue()

    def __setfield_phonenum(self, value):
        if isinstance(value,USTRING):
            self.__field_phonenum=value
        else:
            self.__field_phonenum=USTRING(value,**{'sizeinbytes': 48, 'raiseonunterminatedread': False})

    def __delfield_phonenum(self): del self.__field_phonenum

    phonenum=property(__getfield_phonenum, __setfield_phonenum, __delfield_phonenum, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('date', self.__field_date, None)
        yield ('phonenumlen', self.__field_phonenumlen, None)
        yield ('phonenum', self.__field_phonenum, None)
        yield ('name', self.__field_name, None)
        yield ('dunno2', self.__field_dunno2, None)
        yield ('dunno3', self.__field_dunno3, None)




class historyresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historyresponse,self).__init__(**dict)
        if self.__class__ is historyresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historyresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historyresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=historyentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 428})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,historyentry):
            self.__field_entry=value
        else:
            self.__field_entry=historyentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 428})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class historymiscentry(BaseProtogenClass):
    __fields=['slot', 'pbslotandtype', 'dunno1', 'dunno2', 'dunno3', 'dunno4']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historymiscentry,self).__init__(**dict)
        if self.__class__ is historymiscentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historymiscentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historymiscentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_pbslotandtype.writetobuffer(buf)
        self.__field_dunno1.writetobuffer(buf)
        self.__field_dunno2.writetobuffer(buf)
        self.__field_dunno3.writetobuffer(buf)
        self.__field_dunno4.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 2})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pbslotandtype=UINT(**{'sizeinbytes': 2})
        self.__field_pbslotandtype.readfrombuffer(buf)
        self.__field_dunno1=UINT(**{'sizeinbytes': 2})
        self.__field_dunno1.readfrombuffer(buf)
        self.__field_dunno2=UINT(**{'sizeinbytes': 1})
        self.__field_dunno2.readfrombuffer(buf)
        self.__field_dunno3=UINT(**{'sizeinbytes': 1})
        self.__field_dunno3.readfrombuffer(buf)
        self.__field_dunno4=UINT(**{'sizeinbytes': 1})
        self.__field_dunno4.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pbslotandtype(self):
        return self.__field_pbslotandtype.getvalue()

    def __setfield_pbslotandtype(self, value):
        if isinstance(value,UINT):
            self.__field_pbslotandtype=value
        else:
            self.__field_pbslotandtype=UINT(value,**{'sizeinbytes': 2})

    def __delfield_pbslotandtype(self): del self.__field_pbslotandtype

    pbslotandtype=property(__getfield_pbslotandtype, __setfield_pbslotandtype, __delfield_pbslotandtype, None)

    def __getfield_dunno1(self):
        return self.__field_dunno1.getvalue()

    def __setfield_dunno1(self, value):
        if isinstance(value,UINT):
            self.__field_dunno1=value
        else:
            self.__field_dunno1=UINT(value,**{'sizeinbytes': 2})

    def __delfield_dunno1(self): del self.__field_dunno1

    dunno1=property(__getfield_dunno1, __setfield_dunno1, __delfield_dunno1, None)

    def __getfield_dunno2(self):
        return self.__field_dunno2.getvalue()

    def __setfield_dunno2(self, value):
        if isinstance(value,UINT):
            self.__field_dunno2=value
        else:
            self.__field_dunno2=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno2(self): del self.__field_dunno2

    dunno2=property(__getfield_dunno2, __setfield_dunno2, __delfield_dunno2, None)

    def __getfield_dunno3(self):
        return self.__field_dunno3.getvalue()

    def __setfield_dunno3(self, value):
        if isinstance(value,UINT):
            self.__field_dunno3=value
        else:
            self.__field_dunno3=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno3(self): del self.__field_dunno3

    dunno3=property(__getfield_dunno3, __setfield_dunno3, __delfield_dunno3, None)

    def __getfield_dunno4(self):
        return self.__field_dunno4.getvalue()

    def __setfield_dunno4(self, value):
        if isinstance(value,UINT):
            self.__field_dunno4=value
        else:
            self.__field_dunno4=UINT(value,**{'sizeinbytes': 1})

    def __delfield_dunno4(self): del self.__field_dunno4

    dunno4=property(__getfield_dunno4, __setfield_dunno4, __delfield_dunno4, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('pbslotandtype', self.__field_pbslotandtype, None)
        yield ('dunno1', self.__field_dunno1, None)
        yield ('dunno2', self.__field_dunno2, None)
        yield ('dunno3', self.__field_dunno3, None)
        yield ('dunno4', self.__field_dunno4, None)




class historymiscresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(historymiscresponse,self).__init__(**dict)
        if self.__class__ is historymiscresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(historymiscresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(historymiscresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=historymiscentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 493})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,historymiscentry):
            self.__field_entry=value
        else:
            self.__field_entry=historymiscentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 493})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class bufferpartrequest(BaseProtogenClass):
    __fields=['bufpartsize', 'header', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(bufferpartrequest,self).__init__(**dict)
        if self.__class__ is bufferpartrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(bufferpartrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(bufferpartrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_bufpartsize
        except:
            self.__field_bufpartsize=UINT(**{'constant': 500})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0f})
        self.__field_header.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 502})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0f})
        self.__field_header.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 502})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_bufpartsize(self):
        return self.__field_bufpartsize.getvalue()

    def __setfield_bufpartsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufpartsize=value
        else:
            self.__field_bufpartsize=UINT(value,**{'constant': 500})

    def __delfield_bufpartsize(self): del self.__field_bufpartsize

    bufpartsize=property(__getfield_bufpartsize, __setfield_bufpartsize, __delfield_bufpartsize, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0f})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0f})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 502})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 502})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('bufpartsize', self.__field_bufpartsize, None)
        yield ('header', self.__field_header, None)
        yield ('pad', self.__field_pad, None)




class bufferpartresponse(BaseProtogenClass):
    __fields=['bufpartsize', 'header', 'data', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(bufferpartresponse,self).__init__(**dict)
        if self.__class__ is bufferpartresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(bufferpartresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(bufferpartresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_bufpartsize
        except:
            self.__field_bufpartsize=UINT(**{'constant': 500})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.bufpartsize})
        self.__field_data.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_bufpartsize(self):
        return self.__field_bufpartsize.getvalue()

    def __setfield_bufpartsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufpartsize=value
        else:
            self.__field_bufpartsize=UINT(value,**{'constant': 500})

    def __delfield_bufpartsize(self): del self.__field_bufpartsize

    bufpartsize=property(__getfield_bufpartsize, __setfield_bufpartsize, __delfield_bufpartsize, None)

    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.bufpartsize})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('bufpartsize', self.__field_bufpartsize, None)
        yield ('header', self.__field_header, None)
        yield ('data', self.__field_data, None)
        yield ('pad', self.__field_pad, None)




class bufferpartupdaterequest(BaseProtogenClass):
    __fields=['bufpartsize', 'header', 'data', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(bufferpartupdaterequest,self).__init__(**dict)
        if self.__class__ is bufferpartupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(bufferpartupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(bufferpartupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_bufpartsize
        except:
            self.__field_bufpartsize=UINT(**{'constant': 500})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'readwrite': 0x0e, 'packettype': 0x0f})
        self.__field_header.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'readwrite': 0x0e, 'packettype': 0x0f})
        self.__field_header.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': self.bufpartsize})
        self.__field_data.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_bufpartsize(self):
        return self.__field_bufpartsize.getvalue()

    def __setfield_bufpartsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufpartsize=value
        else:
            self.__field_bufpartsize=UINT(value,**{'constant': 500})

    def __delfield_bufpartsize(self): del self.__field_bufpartsize

    bufpartsize=property(__getfield_bufpartsize, __setfield_bufpartsize, __delfield_bufpartsize, None)

    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'readwrite': 0x0e, 'packettype': 0x0f})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'readwrite': 0x0e, 'packettype': 0x0f})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': self.bufpartsize})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('bufpartsize', self.__field_bufpartsize, None)
        yield ('header', self.__field_header, None)
        yield ('data', self.__field_data, None)
        yield ('pad', self.__field_pad, None)




class phonebookslotrequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(phonebookslotrequest,self).__init__(**dict)
        if self.__class__ is phonebookslotrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(phonebookslotrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(phonebookslotrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0x28})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 500})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0x28})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 2})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 500})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c,                   'command': 0x28})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c,                   'command': 0x28})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 500})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 500})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class phonenumber(BaseProtogenClass):
    __fields=['number_len', 'number']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(phonenumber,self).__init__(**dict)
        if self.__class__ is phonenumber:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(phonenumber,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(phonenumber,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_number_len
        except:
            self.__field_number_len=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_number_len.writetobuffer(buf)
        try: self.__field_number
        except:
            self.__field_number=USTRING(**{'sizeinbytes': 49, 'default': ""})
        self.__field_number.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_number_len=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_number_len.readfrombuffer(buf)
        self.__field_number=USTRING(**{'sizeinbytes': 49, 'default': ""})
        self.__field_number.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_number_len(self):
        try: self.__field_number_len
        except:
            self.__field_number_len=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_number_len.getvalue()

    def __setfield_number_len(self, value):
        if isinstance(value,UINT):
            self.__field_number_len=value
        else:
            self.__field_number_len=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_number_len(self): del self.__field_number_len

    number_len=property(__getfield_number_len, __setfield_number_len, __delfield_number_len, None)

    def __getfield_number(self):
        try: self.__field_number
        except:
            self.__field_number=USTRING(**{'sizeinbytes': 49, 'default': ""})
        return self.__field_number.getvalue()

    def __setfield_number(self, value):
        if isinstance(value,USTRING):
            self.__field_number=value
        else:
            self.__field_number=USTRING(value,**{'sizeinbytes': 49, 'default': ""})

    def __delfield_number(self): del self.__field_number

    number=property(__getfield_number, __setfield_number, __delfield_number, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('number_len', self.__field_number_len, None)
        yield ('number', self.__field_number, None)




class phonebookentry(BaseProtogenClass):
    __fields=['slot', 'slotdup', 'name', 'numbers', 'email_len', 'email', 'url_len', 'url', 'secret', 'name_len']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(phonebookentry,self).__init__(**dict)
        if self.__class__ is phonebookentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(phonebookentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(phonebookentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_slotdup.writetobuffer(buf)
        self.__field_name.writetobuffer(buf)
        try: self.__field_numbers
        except:
            self.__field_numbers=LIST(**{'length': 7, 'createdefault': True, 'elementclass': phonenumber})
        self.__field_numbers.writetobuffer(buf)
        try: self.__field_email_len
        except:
            self.__field_email_len=UINT(**{'sizeinbytes': 1})
        self.__field_email_len.writetobuffer(buf)
        try: self.__field_email
        except:
            self.__field_email=USTRING(**{'sizeinbytes': 49, 'default': ""})
        self.__field_email.writetobuffer(buf)
        try: self.__field_url_len
        except:
            self.__field_url_len=UINT(**{'sizeinbytes': 1})
        self.__field_url_len.writetobuffer(buf)
        try: self.__field_url
        except:
            self.__field_url=USTRING(**{'sizeinbytes': 49, 'default': ""})
        self.__field_url.writetobuffer(buf)
        try: self.__field_secret
        except:
            self.__field_secret=BOOL(**{'sizeinbytes': 1})
        self.__field_secret.writetobuffer(buf)
        self.__field_name_len.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 2})
        self.__field_slot.readfrombuffer(buf)
        self.__field_slotdup=UINT(**{'sizeinbytes': 2})
        self.__field_slotdup.readfrombuffer(buf)
        self.__field_name=USTRING(**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})
        self.__field_name.readfrombuffer(buf)
        self.__field_numbers=LIST(**{'length': 7, 'createdefault': True, 'elementclass': phonenumber})
        self.__field_numbers.readfrombuffer(buf)
        self.__field_email_len=UINT(**{'sizeinbytes': 1})
        self.__field_email_len.readfrombuffer(buf)
        self.__field_email=USTRING(**{'sizeinbytes': 49, 'default': ""})
        self.__field_email.readfrombuffer(buf)
        self.__field_url_len=UINT(**{'sizeinbytes': 1})
        self.__field_url_len.readfrombuffer(buf)
        self.__field_url=USTRING(**{'sizeinbytes': 49, 'default': ""})
        self.__field_url.readfrombuffer(buf)
        self.__field_secret=BOOL(**{'sizeinbytes': 1})
        self.__field_secret.readfrombuffer(buf)
        self.__field_name_len=UINT(**{'sizeinbytes': 1})
        self.__field_name_len.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_slotdup(self):
        return self.__field_slotdup.getvalue()

    def __setfield_slotdup(self, value):
        if isinstance(value,UINT):
            self.__field_slotdup=value
        else:
            self.__field_slotdup=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slotdup(self): del self.__field_slotdup

    slotdup=property(__getfield_slotdup, __setfield_slotdup, __delfield_slotdup, None)

    def __getfield_name(self):
        return self.__field_name.getvalue()

    def __setfield_name(self, value):
        if isinstance(value,USTRING):
            self.__field_name=value
        else:
            self.__field_name=USTRING(value,**{'sizeinbytes': 16, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'terminator': None})

    def __delfield_name(self): del self.__field_name

    name=property(__getfield_name, __setfield_name, __delfield_name, None)

    def __getfield_numbers(self):
        try: self.__field_numbers
        except:
            self.__field_numbers=LIST(**{'length': 7, 'createdefault': True, 'elementclass': phonenumber})
        return self.__field_numbers.getvalue()

    def __setfield_numbers(self, value):
        if isinstance(value,LIST):
            self.__field_numbers=value
        else:
            self.__field_numbers=LIST(value,**{'length': 7, 'createdefault': True, 'elementclass': phonenumber})

    def __delfield_numbers(self): del self.__field_numbers

    numbers=property(__getfield_numbers, __setfield_numbers, __delfield_numbers, None)

    def __getfield_email_len(self):
        try: self.__field_email_len
        except:
            self.__field_email_len=UINT(**{'sizeinbytes': 1})
        return self.__field_email_len.getvalue()

    def __setfield_email_len(self, value):
        if isinstance(value,UINT):
            self.__field_email_len=value
        else:
            self.__field_email_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_email_len(self): del self.__field_email_len

    email_len=property(__getfield_email_len, __setfield_email_len, __delfield_email_len, None)

    def __getfield_email(self):
        try: self.__field_email
        except:
            self.__field_email=USTRING(**{'sizeinbytes': 49, 'default': ""})
        return self.__field_email.getvalue()

    def __setfield_email(self, value):
        if isinstance(value,USTRING):
            self.__field_email=value
        else:
            self.__field_email=USTRING(value,**{'sizeinbytes': 49, 'default': ""})

    def __delfield_email(self): del self.__field_email

    email=property(__getfield_email, __setfield_email, __delfield_email, None)

    def __getfield_url_len(self):
        try: self.__field_url_len
        except:
            self.__field_url_len=UINT(**{'sizeinbytes': 1})
        return self.__field_url_len.getvalue()

    def __setfield_url_len(self, value):
        if isinstance(value,UINT):
            self.__field_url_len=value
        else:
            self.__field_url_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_url_len(self): del self.__field_url_len

    url_len=property(__getfield_url_len, __setfield_url_len, __delfield_url_len, None)

    def __getfield_url(self):
        try: self.__field_url
        except:
            self.__field_url=USTRING(**{'sizeinbytes': 49, 'default': ""})
        return self.__field_url.getvalue()

    def __setfield_url(self, value):
        if isinstance(value,USTRING):
            self.__field_url=value
        else:
            self.__field_url=USTRING(value,**{'sizeinbytes': 49, 'default': ""})

    def __delfield_url(self): del self.__field_url

    url=property(__getfield_url, __setfield_url, __delfield_url, None)

    def __getfield_secret(self):
        try: self.__field_secret
        except:
            self.__field_secret=BOOL(**{'sizeinbytes': 1})
        return self.__field_secret.getvalue()

    def __setfield_secret(self, value):
        if isinstance(value,BOOL):
            self.__field_secret=value
        else:
            self.__field_secret=BOOL(value,**{'sizeinbytes': 1})

    def __delfield_secret(self): del self.__field_secret

    secret=property(__getfield_secret, __setfield_secret, __delfield_secret, None)

    def __getfield_name_len(self):
        return self.__field_name_len.getvalue()

    def __setfield_name_len(self, value):
        if isinstance(value,UINT):
            self.__field_name_len=value
        else:
            self.__field_name_len=UINT(value,**{'sizeinbytes': 1})

    def __delfield_name_len(self): del self.__field_name_len

    name_len=property(__getfield_name_len, __setfield_name_len, __delfield_name_len, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('slotdup', self.__field_slotdup, None)
        yield ('name', self.__field_name, None)
        yield ('numbers', self.__field_numbers, None)
        yield ('email_len', self.__field_email_len, None)
        yield ('email', self.__field_email, None)
        yield ('url_len', self.__field_url_len, None)
        yield ('url', self.__field_url, None)
        yield ('secret', self.__field_secret, None)
        yield ('name_len', self.__field_name_len, None)




class phonebookslotresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(phonebookslotresponse,self).__init__(**dict)
        if self.__class__ is phonebookslotresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(phonebookslotresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(phonebookslotresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=phonebookentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 30})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,phonebookentry):
            self.__field_entry=value
        else:
            self.__field_entry=phonebookentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 30})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class phonebookslotupdaterequest(BaseProtogenClass):
    __fields=['header', 'entry', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(phonebookslotupdaterequest,self).__init__(**dict)
        if self.__class__ is phonebookslotupdaterequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(phonebookslotupdaterequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(phonebookslotupdaterequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'readwrite': 0x0e,                   'command': 0x28})
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 30})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0c, 'readwrite': 0x0e,                   'command': 0x28})
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=phonebookentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 30})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0c, 'readwrite': 0x0e,                   'command': 0x28})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0c, 'readwrite': 0x0e,                   'command': 0x28})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,phonebookentry):
            self.__field_entry=value
        else:
            self.__field_entry=phonebookentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 30})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 30})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad', self.__field_pad, None)




class voicedialrequest(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(voicedialrequest,self).__init__(**dict)
        if self.__class__ is voicedialrequest:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(voicedialrequest,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(voicedialrequest,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0b,                   'command': 0xed})
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader(**{'packettype': 0x0b,                   'command': 0xed})
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader(**{'packettype': 0x0b,                   'command': 0xed})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,**{'packettype': 0x0b,                   'command': 0xed})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 501})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 501})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class voicedialentry(BaseProtogenClass):
    __fields=['slot', 'flag', 'pad1', 'phonenumberslot', 'phonenumbertype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(voicedialentry,self).__init__(**dict)
        if self.__class__ is voicedialentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(voicedialentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(voicedialentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_slot.writetobuffer(buf)
        self.__field_flag.writetobuffer(buf)
        self.__field_pad1.writetobuffer(buf)
        self.__field_phonenumberslot.writetobuffer(buf)
        self.__field_phonenumbertype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_slot=UINT(**{'sizeinbytes': 1})
        self.__field_slot.readfrombuffer(buf)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_phonenumberslot=UINT(**{'sizeinbytes': 2})
        self.__field_phonenumberslot.readfrombuffer(buf)
        self.__field_phonenumbertype=UINT(**{'sizeinbytes': 1})
        self.__field_phonenumbertype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 1})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, "1 if voice dial slot in use")

    def __getfield_pad1(self):
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_phonenumberslot(self):
        return self.__field_phonenumberslot.getvalue()

    def __setfield_phonenumberslot(self, value):
        if isinstance(value,UINT):
            self.__field_phonenumberslot=value
        else:
            self.__field_phonenumberslot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_phonenumberslot(self): del self.__field_phonenumberslot

    phonenumberslot=property(__getfield_phonenumberslot, __setfield_phonenumberslot, __delfield_phonenumberslot, None)

    def __getfield_phonenumbertype(self):
        return self.__field_phonenumbertype.getvalue()

    def __setfield_phonenumbertype(self, value):
        if isinstance(value,UINT):
            self.__field_phonenumbertype=value
        else:
            self.__field_phonenumbertype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_phonenumbertype(self): del self.__field_phonenumbertype

    phonenumbertype=property(__getfield_phonenumbertype, __setfield_phonenumbertype, __delfield_phonenumbertype, "1: Home, 2: Work, ...")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('slot', self.__field_slot, None)
        yield ('flag', self.__field_flag, "1 if voice dial slot in use")
        yield ('pad1', self.__field_pad1, None)
        yield ('phonenumberslot', self.__field_phonenumberslot, None)
        yield ('phonenumbertype', self.__field_phonenumbertype, "1: Home, 2: Work, ...")




class voicedialresponse(BaseProtogenClass):
    __fields=['header', 'entry', 'pad2']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(voicedialresponse,self).__init__(**dict)
        if self.__class__ is voicedialresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(voicedialresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(voicedialresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_entry.writetobuffer(buf)
        self.__field_pad2.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_entry=voicedialentry()
        self.__field_entry.readfrombuffer(buf)
        self.__field_pad2=UNKNOWN(**{'sizeinbytes': 495})
        self.__field_pad2.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_entry(self):
        return self.__field_entry.getvalue()

    def __setfield_entry(self, value):
        if isinstance(value,voicedialentry):
            self.__field_entry=value
        else:
            self.__field_entry=voicedialentry(value,)

    def __delfield_entry(self): del self.__field_entry

    entry=property(__getfield_entry, __setfield_entry, __delfield_entry, None)

    def __getfield_pad2(self):
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad2=value
        else:
            self.__field_pad2=UNKNOWN(value,**{'sizeinbytes': 495})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('entry', self.__field_entry, None)
        yield ('pad2', self.__field_pad2, None)




class t9request(BaseProtogenClass):
    __fields=['unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(t9request,self).__init__(**dict)
        if self.__class__ is t9request:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(t9request,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(t9request,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_unknown=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unknown', self.__field_unknown, None)




class t9response(BaseProtogenClass):
    __fields=['unknown']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(t9response,self).__init__(**dict)
        if self.__class__ is t9response:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(t9response,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(t9response,kwargs)
        if len(args):
            dict2={}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_unknown=UNKNOWN(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_unknown.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_unknown=UNKNOWN()
        self.__field_unknown.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_unknown(self):
        return self.__field_unknown.getvalue()

    def __setfield_unknown(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_unknown=value
        else:
            self.__field_unknown=UNKNOWN(value,)

    def __delfield_unknown(self): del self.__field_unknown

    unknown=property(__getfield_unknown, __setfield_unknown, __delfield_unknown, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('unknown', self.__field_unknown, None)




class calleridentry(BaseProtogenClass):
    __fields=['pbslotandtype', 'actualnumberlen', 'numberfragment']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(calleridentry,self).__init__(**dict)
        if self.__class__ is calleridentry:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(calleridentry,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(calleridentry,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_pbslotandtype
        except:
            self.__field_pbslotandtype=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslotandtype.writetobuffer(buf)
        try: self.__field_actualnumberlen
        except:
            self.__field_actualnumberlen=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_actualnumberlen.writetobuffer(buf)
        try: self.__field_numberfragment
        except:
            self.__field_numberfragment=USTRING(**{'sizeinbytes': 10, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': "", 'terminator': None})
        self.__field_numberfragment.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslotandtype=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslotandtype.readfrombuffer(buf)
        self.__field_actualnumberlen=UINT(**{'sizeinbytes': 1, 'default': 0})
        self.__field_actualnumberlen.readfrombuffer(buf)
        self.__field_numberfragment=USTRING(**{'sizeinbytes': 10, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': "", 'terminator': None})
        self.__field_numberfragment.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslotandtype(self):
        try: self.__field_pbslotandtype
        except:
            self.__field_pbslotandtype=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        return self.__field_pbslotandtype.getvalue()

    def __setfield_pbslotandtype(self, value):
        if isinstance(value,UINT):
            self.__field_pbslotandtype=value
        else:
            self.__field_pbslotandtype=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslotandtype(self): del self.__field_pbslotandtype

    pbslotandtype=property(__getfield_pbslotandtype, __setfield_pbslotandtype, __delfield_pbslotandtype, "Low 12 bits, slotnum, top 4 bits, type")

    def __getfield_actualnumberlen(self):
        try: self.__field_actualnumberlen
        except:
            self.__field_actualnumberlen=UINT(**{'sizeinbytes': 1, 'default': 0})
        return self.__field_actualnumberlen.getvalue()

    def __setfield_actualnumberlen(self, value):
        if isinstance(value,UINT):
            self.__field_actualnumberlen=value
        else:
            self.__field_actualnumberlen=UINT(value,**{'sizeinbytes': 1, 'default': 0})

    def __delfield_actualnumberlen(self): del self.__field_actualnumberlen

    actualnumberlen=property(__getfield_actualnumberlen, __setfield_actualnumberlen, __delfield_actualnumberlen, "Length of the actual phone number")

    def __getfield_numberfragment(self):
        try: self.__field_numberfragment
        except:
            self.__field_numberfragment=USTRING(**{'sizeinbytes': 10, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': "", 'terminator': None})
        return self.__field_numberfragment.getvalue()

    def __setfield_numberfragment(self, value):
        if isinstance(value,USTRING):
            self.__field_numberfragment=value
        else:
            self.__field_numberfragment=USTRING(value,**{'sizeinbytes': 10, 'raiseonunterminatedread': False, 'raiseontruncate': False, 'default': "", 'terminator': None})

    def __delfield_numberfragment(self): del self.__field_numberfragment

    numberfragment=property(__getfield_numberfragment, __setfield_numberfragment, __delfield_numberfragment, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslotandtype', self.__field_pbslotandtype, "Low 12 bits, slotnum, top 4 bits, type")
        yield ('actualnumberlen', self.__field_actualnumberlen, "Length of the actual phone number")
        yield ('numberfragment', self.__field_numberfragment, None)




class calleridbuffer(BaseProtogenClass):
    "Index so that phone can show a name instead of number"
    __fields=['maxentries', 'startcommand', 'bufsize', 'comment', 'numentries', 'items', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(calleridbuffer,self).__init__(**dict)
        if self.__class__ is calleridbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(calleridbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(calleridbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_maxentries
        except:
            self.__field_maxentries=UINT(**{'constant': 500})
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0x50})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 7000})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "callerid"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_numentries.writetobuffer(buf)
        try: self.__field_items
        except:
            self.__field_items=LIST(**{'length': self.maxentries, 'elementclass': calleridentry, 'createdefault': True})
        self.__field_items.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 498})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_numentries=UINT(**{'sizeinbytes': 2})
        self.__field_numentries.readfrombuffer(buf)
        self.__field_items=LIST(**{'length': self.maxentries, 'elementclass': calleridentry, 'createdefault': True})
        self.__field_items.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 498})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_maxentries(self):
        return self.__field_maxentries.getvalue()

    def __setfield_maxentries(self, value):
        if isinstance(value,UINT):
            self.__field_maxentries=value
        else:
            self.__field_maxentries=UINT(value,**{'constant': 500})

    def __delfield_maxentries(self): del self.__field_maxentries

    maxentries=property(__getfield_maxentries, __setfield_maxentries, __delfield_maxentries, None)

    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0x50})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 7000})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "callerid"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "callerid"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_numentries(self):
        return self.__field_numentries.getvalue()

    def __setfield_numentries(self, value):
        if isinstance(value,UINT):
            self.__field_numentries=value
        else:
            self.__field_numentries=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numentries(self): del self.__field_numentries

    numentries=property(__getfield_numentries, __setfield_numentries, __delfield_numentries, "Number phone numbers")

    def __getfield_items(self):
        try: self.__field_items
        except:
            self.__field_items=LIST(**{'length': self.maxentries, 'elementclass': calleridentry, 'createdefault': True})
        return self.__field_items.getvalue()

    def __setfield_items(self, value):
        if isinstance(value,LIST):
            self.__field_items=value
        else:
            self.__field_items=LIST(value,**{'length': self.maxentries, 'elementclass': calleridentry, 'createdefault': True})

    def __delfield_items(self): del self.__field_items

    items=property(__getfield_items, __setfield_items, __delfield_items, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 498})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 498})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('maxentries', self.__field_maxentries, None)
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('numentries', self.__field_numentries, "Number phone numbers")
        yield ('items', self.__field_items, None)
        yield ('pad', self.__field_pad, None)




class ringerpicbuffer(BaseProtogenClass):
    "Index of ringer and picture assignments"
    __fields=['numpbslots', 'startcommand', 'bufsize', 'comment', 'ringtones', 'wallpapers', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(ringerpicbuffer,self).__init__(**dict)
        if self.__class__ is ringerpicbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(ringerpicbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(ringerpicbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_numpbslots
        except:
            self.__field_numpbslots=UINT(**{'constant': _NUMPBSLOTS})
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0x46})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 1000})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "ringer/picture assignments"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_ringtones
        except:
            self.__field_ringtones=LIST(**{'elementclass': _gen_p_sanyo_461, 'length': _NUMPBSLOTS})
        self.__field_ringtones.writetobuffer(buf)
        try: self.__field_wallpapers
        except:
            self.__field_wallpapers=LIST(**{'elementclass': _gen_p_sanyo_463, 'length': _NUMPBSLOTS})
        self.__field_wallpapers.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 400})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_ringtones=LIST(**{'elementclass': _gen_p_sanyo_461, 'length': _NUMPBSLOTS})
        self.__field_ringtones.readfrombuffer(buf)
        self.__field_wallpapers=LIST(**{'elementclass': _gen_p_sanyo_463, 'length': _NUMPBSLOTS})
        self.__field_wallpapers.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 400})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numpbslots(self):
        return self.__field_numpbslots.getvalue()

    def __setfield_numpbslots(self, value):
        if isinstance(value,UINT):
            self.__field_numpbslots=value
        else:
            self.__field_numpbslots=UINT(value,**{'constant': _NUMPBSLOTS})

    def __delfield_numpbslots(self): del self.__field_numpbslots

    numpbslots=property(__getfield_numpbslots, __setfield_numpbslots, __delfield_numpbslots, "Number of phone book slots")

    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0x46})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 1000})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "ringer/picture assignments"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "ringer/picture assignments"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_ringtones(self):
        try: self.__field_ringtones
        except:
            self.__field_ringtones=LIST(**{'elementclass': _gen_p_sanyo_461, 'length': _NUMPBSLOTS})
        return self.__field_ringtones.getvalue()

    def __setfield_ringtones(self, value):
        if isinstance(value,LIST):
            self.__field_ringtones=value
        else:
            self.__field_ringtones=LIST(value,**{'elementclass': _gen_p_sanyo_461, 'length': _NUMPBSLOTS})

    def __delfield_ringtones(self): del self.__field_ringtones

    ringtones=property(__getfield_ringtones, __setfield_ringtones, __delfield_ringtones, None)

    def __getfield_wallpapers(self):
        try: self.__field_wallpapers
        except:
            self.__field_wallpapers=LIST(**{'elementclass': _gen_p_sanyo_463, 'length': _NUMPBSLOTS})
        return self.__field_wallpapers.getvalue()

    def __setfield_wallpapers(self, value):
        if isinstance(value,LIST):
            self.__field_wallpapers=value
        else:
            self.__field_wallpapers=LIST(value,**{'elementclass': _gen_p_sanyo_463, 'length': _NUMPBSLOTS})

    def __delfield_wallpapers(self): del self.__field_wallpapers

    wallpapers=property(__getfield_wallpapers, __setfield_wallpapers, __delfield_wallpapers, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 400})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 400})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numpbslots', self.__field_numpbslots, "Number of phone book slots")
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('ringtones', self.__field_ringtones, None)
        yield ('wallpapers', self.__field_wallpapers, None)
        yield ('pad', self.__field_pad, None)




class _gen_p_sanyo_461(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['ringtone']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_461,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_461:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_461,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_461,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_ringtone=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_ringtone.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_ringtone=UINT(**{'sizeinbytes': 1})
        self.__field_ringtone.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_ringtone(self):
        return self.__field_ringtone.getvalue()

    def __setfield_ringtone(self, value):
        if isinstance(value,UINT):
            self.__field_ringtone=value
        else:
            self.__field_ringtone=UINT(value,**{'sizeinbytes': 1})

    def __delfield_ringtone(self): del self.__field_ringtone

    ringtone=property(__getfield_ringtone, __setfield_ringtone, __delfield_ringtone, "ringtone index")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('ringtone', self.__field_ringtone, "ringtone index")




class _gen_p_sanyo_463(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['wallpaper']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_463,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_463:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_463,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_463,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_wallpaper=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_wallpaper.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_wallpaper=UINT(**{'sizeinbytes': 1})
        self.__field_wallpaper.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_wallpaper(self):
        return self.__field_wallpaper.getvalue()

    def __setfield_wallpaper(self, value):
        if isinstance(value,UINT):
            self.__field_wallpaper=value
        else:
            self.__field_wallpaper=UINT(value,**{'sizeinbytes': 1})

    def __delfield_wallpaper(self): del self.__field_wallpaper

    wallpaper=property(__getfield_wallpaper, __setfield_wallpaper, __delfield_wallpaper, "wallpaper index")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('wallpaper', self.__field_wallpaper, "wallpaper index")




class wallpaperbuffer(BaseProtogenClass):
    "Addition buffer of wallpaper assignment info"
    __fields=['numpbslots', 'startcommand', 'bufsize', 'comment', 'wallpapers']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(wallpaperbuffer,self).__init__(**dict)
        if self.__class__ is wallpaperbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(wallpaperbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(wallpaperbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_numpbslots
        except:
            self.__field_numpbslots=UINT(**{'constant': _NUMPBSLOTS})
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0x69})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 1500})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "wallpaper assignment info"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_wallpapers
        except:
            self.__field_wallpapers=LIST(**{'length': _NUMPBSLOTS, 'elementclass': wallpaperinfo})
        self.__field_wallpapers.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_wallpapers=LIST(**{'length': _NUMPBSLOTS, 'elementclass': wallpaperinfo})
        self.__field_wallpapers.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_numpbslots(self):
        return self.__field_numpbslots.getvalue()

    def __setfield_numpbslots(self, value):
        if isinstance(value,UINT):
            self.__field_numpbslots=value
        else:
            self.__field_numpbslots=UINT(value,**{'constant': _NUMPBSLOTS})

    def __delfield_numpbslots(self): del self.__field_numpbslots

    numpbslots=property(__getfield_numpbslots, __setfield_numpbslots, __delfield_numpbslots, "Number of phone book slots")

    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0x69})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 1500})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "wallpaper assignment info"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "wallpaper assignment info"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_wallpapers(self):
        try: self.__field_wallpapers
        except:
            self.__field_wallpapers=LIST(**{'length': _NUMPBSLOTS, 'elementclass': wallpaperinfo})
        return self.__field_wallpapers.getvalue()

    def __setfield_wallpapers(self, value):
        if isinstance(value,LIST):
            self.__field_wallpapers=value
        else:
            self.__field_wallpapers=LIST(value,**{'length': _NUMPBSLOTS, 'elementclass': wallpaperinfo})

    def __delfield_wallpapers(self): del self.__field_wallpapers

    wallpapers=property(__getfield_wallpapers, __setfield_wallpapers, __delfield_wallpapers, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('numpbslots', self.__field_numpbslots, "Number of phone book slots")
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('wallpapers', self.__field_wallpapers, None)




class wallpaperinfo(BaseProtogenClass):
    "5 byte structure with info about wallpaper assignments"
    __fields=['flag', 'word1', 'word2']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(wallpaperinfo,self).__init__(**dict)
        if self.__class__ is wallpaperinfo:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(wallpaperinfo,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(wallpaperinfo,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_flag.writetobuffer(buf)
        self.__field_word1.writetobuffer(buf)
        self.__field_word2.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_flag=UINT(**{'sizeinbytes': 1})
        self.__field_flag.readfrombuffer(buf)
        self.__field_word1=UINT(**{'sizeinbytes': 2})
        self.__field_word1.readfrombuffer(buf)
        self.__field_word2=UINT(**{'sizeinbytes': 2})
        self.__field_word2.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_flag(self):
        return self.__field_flag.getvalue()

    def __setfield_flag(self, value):
        if isinstance(value,UINT):
            self.__field_flag=value
        else:
            self.__field_flag=UINT(value,**{'sizeinbytes': 1})

    def __delfield_flag(self): del self.__field_flag

    flag=property(__getfield_flag, __setfield_flag, __delfield_flag, None)

    def __getfield_word1(self):
        return self.__field_word1.getvalue()

    def __setfield_word1(self, value):
        if isinstance(value,UINT):
            self.__field_word1=value
        else:
            self.__field_word1=UINT(value,**{'sizeinbytes': 2})

    def __delfield_word1(self): del self.__field_word1

    word1=property(__getfield_word1, __setfield_word1, __delfield_word1, None)

    def __getfield_word2(self):
        return self.__field_word2.getvalue()

    def __setfield_word2(self, value):
        if isinstance(value,UINT):
            self.__field_word2=value
        else:
            self.__field_word2=UINT(value,**{'sizeinbytes': 2})

    def __delfield_word2(self): del self.__field_word2

    word2=property(__getfield_word2, __setfield_word2, __delfield_word2, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('flag', self.__field_flag, None)
        yield ('word1', self.__field_word1, None)
        yield ('word2', self.__field_word2, None)




class pbsortbuffer(BaseProtogenClass):
    "Various arrays for sorting the phone book, speed dial, determining which"
    __fields=['startcommand', 'bufsize', 'comment', 'usedflags', 'slotsused', 'slotsused2', 'numemail', 'numurl', 'firsttypes', 'sortorder', 'pbfirstletters', 'sortorder2', 'speeddialindex', 'longnumbersindex', 'emails', 'emailfirstletters', 'urls', 'urlfirstletters', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(pbsortbuffer,self).__init__(**dict)
        if self.__class__ is pbsortbuffer:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(pbsortbuffer,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(pbsortbuffer,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed
        try: self.__field_startcommand
        except:
            self.__field_startcommand=UINT(**{'constant': 0x3c})
        try: self.__field_bufsize
        except:
            self.__field_bufsize=UINT(**{'constant': 4000})
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "sort buffer"})


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_usedflags
        except:
            self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo_490, 'length': _NUMPBSLOTS, 'createdefault': True})
        self.__field_usedflags.writetobuffer(buf)
        self.__field_slotsused.writetobuffer(buf)
        self.__field_slotsused2.writetobuffer(buf)
        self.__field_numemail.writetobuffer(buf)
        self.__field_numurl.writetobuffer(buf)
        try: self.__field_firsttypes
        except:
            self.__field_firsttypes=LIST(**{'elementclass': _gen_p_sanyo_496, 'length': _NUMPBSLOTS})
        self.__field_firsttypes.writetobuffer(buf)
        try: self.__field_sortorder
        except:
            self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo_498, 'length': _NUMPBSLOTS})
        self.__field_sortorder.writetobuffer(buf)
        self.__field_pbfirstletters.writetobuffer(buf)
        try: self.__field_sortorder2
        except:
            self.__field_sortorder2=LIST(**{'elementclass': _gen_p_sanyo_501, 'length': _NUMPBSLOTS})
        self.__field_sortorder2.writetobuffer(buf)
        try: self.__field_speeddialindex
        except:
            self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo_503, 'length': _NUMSPEEDDIALS})
        self.__field_speeddialindex.writetobuffer(buf)
        try: self.__field_longnumbersindex
        except:
            self.__field_longnumbersindex=LIST(**{'elementclass': _gen_p_sanyo_505, 'length': _NUMLONGNUMBERS})
        self.__field_longnumbersindex.writetobuffer(buf)
        try: self.__field_emails
        except:
            self.__field_emails=LIST(**{'elementclass': _gen_p_sanyo_507, 'length': _NUMPBSLOTS})
        self.__field_emails.writetobuffer(buf)
        self.__field_emailfirstletters.writetobuffer(buf)
        try: self.__field_urls
        except:
            self.__field_urls=LIST(**{'elementclass': _gen_p_sanyo_510, 'length': _NUMPBSLOTS})
        self.__field_urls.writetobuffer(buf)
        self.__field_urlfirstletters.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 66})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo_490, 'length': _NUMPBSLOTS, 'createdefault': True})
        self.__field_usedflags.readfrombuffer(buf)
        self.__field_slotsused=UINT(**{'sizeinbytes': 2})
        self.__field_slotsused.readfrombuffer(buf)
        self.__field_slotsused2=UINT(**{'sizeinbytes': 2})
        self.__field_slotsused2.readfrombuffer(buf)
        self.__field_numemail=UINT(**{'sizeinbytes': 2})
        self.__field_numemail.readfrombuffer(buf)
        self.__field_numurl=UINT(**{'sizeinbytes': 2})
        self.__field_numurl.readfrombuffer(buf)
        self.__field_firsttypes=LIST(**{'elementclass': _gen_p_sanyo_496, 'length': _NUMPBSLOTS})
        self.__field_firsttypes.readfrombuffer(buf)
        self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo_498, 'length': _NUMPBSLOTS})
        self.__field_sortorder.readfrombuffer(buf)
        self.__field_pbfirstletters=USTRING(**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})
        self.__field_pbfirstletters.readfrombuffer(buf)
        self.__field_sortorder2=LIST(**{'elementclass': _gen_p_sanyo_501, 'length': _NUMPBSLOTS})
        self.__field_sortorder2.readfrombuffer(buf)
        self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo_503, 'length': _NUMSPEEDDIALS})
        self.__field_speeddialindex.readfrombuffer(buf)
        self.__field_longnumbersindex=LIST(**{'elementclass': _gen_p_sanyo_505, 'length': _NUMLONGNUMBERS})
        self.__field_longnumbersindex.readfrombuffer(buf)
        self.__field_emails=LIST(**{'elementclass': _gen_p_sanyo_507, 'length': _NUMPBSLOTS})
        self.__field_emails.readfrombuffer(buf)
        self.__field_emailfirstletters=USTRING(**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})
        self.__field_emailfirstletters.readfrombuffer(buf)
        self.__field_urls=LIST(**{'elementclass': _gen_p_sanyo_510, 'length': _NUMPBSLOTS})
        self.__field_urls.readfrombuffer(buf)
        self.__field_urlfirstletters=USTRING(**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})
        self.__field_urlfirstletters.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 66})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_startcommand(self):
        return self.__field_startcommand.getvalue()

    def __setfield_startcommand(self, value):
        if isinstance(value,UINT):
            self.__field_startcommand=value
        else:
            self.__field_startcommand=UINT(value,**{'constant': 0x3c})

    def __delfield_startcommand(self): del self.__field_startcommand

    startcommand=property(__getfield_startcommand, __setfield_startcommand, __delfield_startcommand, "Starting command for R/W buf parts")

    def __getfield_bufsize(self):
        return self.__field_bufsize.getvalue()

    def __setfield_bufsize(self, value):
        if isinstance(value,UINT):
            self.__field_bufsize=value
        else:
            self.__field_bufsize=UINT(value,**{'constant': 4000})

    def __delfield_bufsize(self): del self.__field_bufsize

    bufsize=property(__getfield_bufsize, __setfield_bufsize, __delfield_bufsize, None)

    def __getfield_comment(self):
        try: self.__field_comment
        except:
            self.__field_comment=USTRING(**{'default': "sort buffer"})
        return self.__field_comment.getvalue()

    def __setfield_comment(self, value):
        if isinstance(value,USTRING):
            self.__field_comment=value
        else:
            self.__field_comment=USTRING(value,**{'default': "sort buffer"})

    def __delfield_comment(self): del self.__field_comment

    comment=property(__getfield_comment, __setfield_comment, __delfield_comment, None)

    def __getfield_usedflags(self):
        try: self.__field_usedflags
        except:
            self.__field_usedflags=LIST(**{'elementclass': _gen_p_sanyo_490, 'length': _NUMPBSLOTS, 'createdefault': True})
        return self.__field_usedflags.getvalue()

    def __setfield_usedflags(self, value):
        if isinstance(value,LIST):
            self.__field_usedflags=value
        else:
            self.__field_usedflags=LIST(value,**{'elementclass': _gen_p_sanyo_490, 'length': _NUMPBSLOTS, 'createdefault': True})

    def __delfield_usedflags(self): del self.__field_usedflags

    usedflags=property(__getfield_usedflags, __setfield_usedflags, __delfield_usedflags, None)

    def __getfield_slotsused(self):
        return self.__field_slotsused.getvalue()

    def __setfield_slotsused(self, value):
        if isinstance(value,UINT):
            self.__field_slotsused=value
        else:
            self.__field_slotsused=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slotsused(self): del self.__field_slotsused

    slotsused=property(__getfield_slotsused, __setfield_slotsused, __delfield_slotsused, None)

    def __getfield_slotsused2(self):
        return self.__field_slotsused2.getvalue()

    def __setfield_slotsused2(self, value):
        if isinstance(value,UINT):
            self.__field_slotsused2=value
        else:
            self.__field_slotsused2=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slotsused2(self): del self.__field_slotsused2

    slotsused2=property(__getfield_slotsused2, __setfield_slotsused2, __delfield_slotsused2, "# slots containing a phone number")

    def __getfield_numemail(self):
        return self.__field_numemail.getvalue()

    def __setfield_numemail(self, value):
        if isinstance(value,UINT):
            self.__field_numemail=value
        else:
            self.__field_numemail=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numemail(self): del self.__field_numemail

    numemail=property(__getfield_numemail, __setfield_numemail, __delfield_numemail, "Num of slots with email")

    def __getfield_numurl(self):
        return self.__field_numurl.getvalue()

    def __setfield_numurl(self, value):
        if isinstance(value,UINT):
            self.__field_numurl=value
        else:
            self.__field_numurl=UINT(value,**{'sizeinbytes': 2})

    def __delfield_numurl(self): del self.__field_numurl

    numurl=property(__getfield_numurl, __setfield_numurl, __delfield_numurl, "Num of slots with URL")

    def __getfield_firsttypes(self):
        try: self.__field_firsttypes
        except:
            self.__field_firsttypes=LIST(**{'elementclass': _gen_p_sanyo_496, 'length': _NUMPBSLOTS})
        return self.__field_firsttypes.getvalue()

    def __setfield_firsttypes(self, value):
        if isinstance(value,LIST):
            self.__field_firsttypes=value
        else:
            self.__field_firsttypes=LIST(value,**{'elementclass': _gen_p_sanyo_496, 'length': _NUMPBSLOTS})

    def __delfield_firsttypes(self): del self.__field_firsttypes

    firsttypes=property(__getfield_firsttypes, __setfield_firsttypes, __delfield_firsttypes, None)

    def __getfield_sortorder(self):
        try: self.__field_sortorder
        except:
            self.__field_sortorder=LIST(**{'elementclass': _gen_p_sanyo_498, 'length': _NUMPBSLOTS})
        return self.__field_sortorder.getvalue()

    def __setfield_sortorder(self, value):
        if isinstance(value,LIST):
            self.__field_sortorder=value
        else:
            self.__field_sortorder=LIST(value,**{'elementclass': _gen_p_sanyo_498, 'length': _NUMPBSLOTS})

    def __delfield_sortorder(self): del self.__field_sortorder

    sortorder=property(__getfield_sortorder, __setfield_sortorder, __delfield_sortorder, None)

    def __getfield_pbfirstletters(self):
        return self.__field_pbfirstletters.getvalue()

    def __setfield_pbfirstletters(self, value):
        if isinstance(value,USTRING):
            self.__field_pbfirstletters=value
        else:
            self.__field_pbfirstletters=USTRING(value,**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})

    def __delfield_pbfirstletters(self): del self.__field_pbfirstletters

    pbfirstletters=property(__getfield_pbfirstletters, __setfield_pbfirstletters, __delfield_pbfirstletters, None)

    def __getfield_sortorder2(self):
        try: self.__field_sortorder2
        except:
            self.__field_sortorder2=LIST(**{'elementclass': _gen_p_sanyo_501, 'length': _NUMPBSLOTS})
        return self.__field_sortorder2.getvalue()

    def __setfield_sortorder2(self, value):
        if isinstance(value,LIST):
            self.__field_sortorder2=value
        else:
            self.__field_sortorder2=LIST(value,**{'elementclass': _gen_p_sanyo_501, 'length': _NUMPBSLOTS})

    def __delfield_sortorder2(self): del self.__field_sortorder2

    sortorder2=property(__getfield_sortorder2, __setfield_sortorder2, __delfield_sortorder2, "Sort order for entries with phone numbers")

    def __getfield_speeddialindex(self):
        try: self.__field_speeddialindex
        except:
            self.__field_speeddialindex=LIST(**{'elementclass': _gen_p_sanyo_503, 'length': _NUMSPEEDDIALS})
        return self.__field_speeddialindex.getvalue()

    def __setfield_speeddialindex(self, value):
        if isinstance(value,LIST):
            self.__field_speeddialindex=value
        else:
            self.__field_speeddialindex=LIST(value,**{'elementclass': _gen_p_sanyo_503, 'length': _NUMSPEEDDIALS})

    def __delfield_speeddialindex(self): del self.__field_speeddialindex

    speeddialindex=property(__getfield_speeddialindex, __setfield_speeddialindex, __delfield_speeddialindex, None)

    def __getfield_longnumbersindex(self):
        try: self.__field_longnumbersindex
        except:
            self.__field_longnumbersindex=LIST(**{'elementclass': _gen_p_sanyo_505, 'length': _NUMLONGNUMBERS})
        return self.__field_longnumbersindex.getvalue()

    def __setfield_longnumbersindex(self, value):
        if isinstance(value,LIST):
            self.__field_longnumbersindex=value
        else:
            self.__field_longnumbersindex=LIST(value,**{'elementclass': _gen_p_sanyo_505, 'length': _NUMLONGNUMBERS})

    def __delfield_longnumbersindex(self): del self.__field_longnumbersindex

    longnumbersindex=property(__getfield_longnumbersindex, __setfield_longnumbersindex, __delfield_longnumbersindex, None)

    def __getfield_emails(self):
        try: self.__field_emails
        except:
            self.__field_emails=LIST(**{'elementclass': _gen_p_sanyo_507, 'length': _NUMPBSLOTS})
        return self.__field_emails.getvalue()

    def __setfield_emails(self, value):
        if isinstance(value,LIST):
            self.__field_emails=value
        else:
            self.__field_emails=LIST(value,**{'elementclass': _gen_p_sanyo_507, 'length': _NUMPBSLOTS})

    def __delfield_emails(self): del self.__field_emails

    emails=property(__getfield_emails, __setfield_emails, __delfield_emails, "Sorted list of slots with Email")

    def __getfield_emailfirstletters(self):
        return self.__field_emailfirstletters.getvalue()

    def __setfield_emailfirstletters(self, value):
        if isinstance(value,USTRING):
            self.__field_emailfirstletters=value
        else:
            self.__field_emailfirstletters=USTRING(value,**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})

    def __delfield_emailfirstletters(self): del self.__field_emailfirstletters

    emailfirstletters=property(__getfield_emailfirstletters, __setfield_emailfirstletters, __delfield_emailfirstletters, "First letters in sort order")

    def __getfield_urls(self):
        try: self.__field_urls
        except:
            self.__field_urls=LIST(**{'elementclass': _gen_p_sanyo_510, 'length': _NUMPBSLOTS})
        return self.__field_urls.getvalue()

    def __setfield_urls(self, value):
        if isinstance(value,LIST):
            self.__field_urls=value
        else:
            self.__field_urls=LIST(value,**{'elementclass': _gen_p_sanyo_510, 'length': _NUMPBSLOTS})

    def __delfield_urls(self): del self.__field_urls

    urls=property(__getfield_urls, __setfield_urls, __delfield_urls, "Sorted list of slots with a URL")

    def __getfield_urlfirstletters(self):
        return self.__field_urlfirstletters.getvalue()

    def __setfield_urlfirstletters(self, value):
        if isinstance(value,USTRING):
            self.__field_urlfirstletters=value
        else:
            self.__field_urlfirstletters=USTRING(value,**{'terminator': None, 'sizeinbytes': _NUMPBSLOTS})

    def __delfield_urlfirstletters(self): del self.__field_urlfirstletters

    urlfirstletters=property(__getfield_urlfirstletters, __setfield_urlfirstletters, __delfield_urlfirstletters, "First letters in sort order")

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 66})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 66})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('startcommand', self.__field_startcommand, "Starting command for R/W buf parts")
        yield ('bufsize', self.__field_bufsize, None)
        yield ('comment', self.__field_comment, None)
        yield ('usedflags', self.__field_usedflags, None)
        yield ('slotsused', self.__field_slotsused, None)
        yield ('slotsused2', self.__field_slotsused2, "# slots containing a phone number")
        yield ('numemail', self.__field_numemail, "Num of slots with email")
        yield ('numurl', self.__field_numurl, "Num of slots with URL")
        yield ('firsttypes', self.__field_firsttypes, None)
        yield ('sortorder', self.__field_sortorder, None)
        yield ('pbfirstletters', self.__field_pbfirstletters, None)
        yield ('sortorder2', self.__field_sortorder2, "Sort order for entries with phone numbers")
        yield ('speeddialindex', self.__field_speeddialindex, None)
        yield ('longnumbersindex', self.__field_longnumbersindex, None)
        yield ('emails', self.__field_emails, "Sorted list of slots with Email")
        yield ('emailfirstletters', self.__field_emailfirstletters, "First letters in sort order")
        yield ('urls', self.__field_urls, "Sorted list of slots with a URL")
        yield ('urlfirstletters', self.__field_urlfirstletters, "First letters in sort order")
        yield ('pad', self.__field_pad, None)




class _gen_p_sanyo_490(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['used']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_490,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_490:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_490,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_490,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_used=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_used.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_used=UINT(**{'sizeinbytes': 1})
        self.__field_used.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_used(self):
        return self.__field_used.getvalue()

    def __setfield_used(self, value):
        if isinstance(value,UINT):
            self.__field_used=value
        else:
            self.__field_used=UINT(value,**{'sizeinbytes': 1})

    def __delfield_used(self): del self.__field_used

    used=property(__getfield_used, __setfield_used, __delfield_used, "1 if slot in use")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('used', self.__field_used, "1 if slot in use")




class _gen_p_sanyo_496(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['firsttype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_496,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_496:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_496,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_496,kwargs)
        if len(args):
            dict2={'sizeinbytes': 1}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_firsttype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_firsttype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_firsttype=UINT(**{'sizeinbytes': 1})
        self.__field_firsttype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_firsttype(self):
        return self.__field_firsttype.getvalue()

    def __setfield_firsttype(self, value):
        if isinstance(value,UINT):
            self.__field_firsttype=value
        else:
            self.__field_firsttype=UINT(value,**{'sizeinbytes': 1})

    def __delfield_firsttype(self): del self.__field_firsttype

    firsttype=property(__getfield_firsttype, __setfield_firsttype, __delfield_firsttype, "First phone number type in each slot")

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('firsttype', self.__field_firsttype, "First phone number type in each slot")




class _gen_p_sanyo_498(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_498,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_498:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_498,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_498,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class _gen_p_sanyo_501(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_501,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_501:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_501,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_501,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class _gen_p_sanyo_503(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslotandtype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_503,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_503:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_503,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_503,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslotandtype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslotandtype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslotandtype=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslotandtype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslotandtype(self):
        return self.__field_pbslotandtype.getvalue()

    def __setfield_pbslotandtype(self, value):
        if isinstance(value,UINT):
            self.__field_pbslotandtype=value
        else:
            self.__field_pbslotandtype=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslotandtype(self): del self.__field_pbslotandtype

    pbslotandtype=property(__getfield_pbslotandtype, __setfield_pbslotandtype, __delfield_pbslotandtype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslotandtype', self.__field_pbslotandtype, None)




class _gen_p_sanyo_505(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslotandtype']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_505,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_505:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_505,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_505,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslotandtype=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslotandtype.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslotandtype=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslotandtype.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslotandtype(self):
        return self.__field_pbslotandtype.getvalue()

    def __setfield_pbslotandtype(self, value):
        if isinstance(value,UINT):
            self.__field_pbslotandtype=value
        else:
            self.__field_pbslotandtype=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslotandtype(self): del self.__field_pbslotandtype

    pbslotandtype=property(__getfield_pbslotandtype, __setfield_pbslotandtype, __delfield_pbslotandtype, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslotandtype', self.__field_pbslotandtype, None)




class _gen_p_sanyo_507(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_507,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_507:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_507,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_507,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class _gen_p_sanyo_510(BaseProtogenClass):
    'Anonymous inner class'
    __fields=['pbslot']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(_gen_p_sanyo_510,self).__init__(**dict)
        if self.__class__ is _gen_p_sanyo_510:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(_gen_p_sanyo_510,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(_gen_p_sanyo_510,kwargs)
        if len(args):
            dict2={'sizeinbytes': 2, 'default': 0xffff}
            dict2.update(kwargs)
            kwargs=dict2
            self.__field_pbslot=UINT(*args,**dict2)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_pbslot.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_pbslot=UINT(**{'sizeinbytes': 2, 'default': 0xffff})
        self.__field_pbslot.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_pbslot(self):
        return self.__field_pbslot.getvalue()

    def __setfield_pbslot(self, value):
        if isinstance(value,UINT):
            self.__field_pbslot=value
        else:
            self.__field_pbslot=UINT(value,**{'sizeinbytes': 2, 'default': 0xffff})

    def __delfield_pbslot(self): del self.__field_pbslot

    pbslot=property(__getfield_pbslot, __setfield_pbslot, __delfield_pbslot, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('pbslot', self.__field_pbslot, None)




class sanyomediaheader(BaseProtogenClass):
    __fields=['fa', 'faset', 'command', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sanyomediaheader,self).__init__(**dict)
        if self.__class__ is sanyomediaheader:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sanyomediaheader,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sanyomediaheader,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_fa
        except:
            self.__field_fa=UINT(**{'sizeinbytes': 2, 'constant': 0xfa})
        self.__field_fa.writetobuffer(buf)
        try: self.__field_faset
        except:
            self.__field_faset=UINT(**{'sizeinbytes': 1, 'default': 0x05})
        self.__field_faset.writetobuffer(buf)
        self.__field_command.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_fa=UINT(**{'sizeinbytes': 2, 'constant': 0xfa})
        self.__field_fa.readfrombuffer(buf)
        self.__field_faset=UINT(**{'sizeinbytes': 1, 'default': 0x05})
        self.__field_faset.readfrombuffer(buf)
        self.__field_command=UINT(**{'sizeinbytes': 2})
        self.__field_command.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_fa(self):
        try: self.__field_fa
        except:
            self.__field_fa=UINT(**{'sizeinbytes': 2, 'constant': 0xfa})
        return self.__field_fa.getvalue()

    def __setfield_fa(self, value):
        if isinstance(value,UINT):
            self.__field_fa=value
        else:
            self.__field_fa=UINT(value,**{'sizeinbytes': 2, 'constant': 0xfa})

    def __delfield_fa(self): del self.__field_fa

    fa=property(__getfield_fa, __setfield_fa, __delfield_fa, None)

    def __getfield_faset(self):
        try: self.__field_faset
        except:
            self.__field_faset=UINT(**{'sizeinbytes': 1, 'default': 0x05})
        return self.__field_faset.getvalue()

    def __setfield_faset(self, value):
        if isinstance(value,UINT):
            self.__field_faset=value
        else:
            self.__field_faset=UINT(value,**{'sizeinbytes': 1, 'default': 0x05})

    def __delfield_faset(self): del self.__field_faset

    faset=property(__getfield_faset, __setfield_faset, __delfield_faset, None)

    def __getfield_command(self):
        return self.__field_command.getvalue()

    def __setfield_command(self, value):
        if isinstance(value,UINT):
            self.__field_command=value
        else:
            self.__field_command=UINT(value,**{'sizeinbytes': 2})

    def __delfield_command(self): del self.__field_command

    command=property(__getfield_command, __setfield_command, __delfield_command, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 2})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 2})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('fa', self.__field_fa, None)
        yield ('faset', self.__field_faset, None)
        yield ('command', self.__field_command, None)
        yield ('pad', self.__field_pad, None)




class sanyosendfilename(BaseProtogenClass):
    __fields=['header', 'payloadsize', 'filename']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sanyosendfilename,self).__init__(**dict)
        if self.__class__ is sanyosendfilename:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sanyosendfilename,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sanyosendfilename,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader(**{'command': 0xffa1})
        self.__field_header.writetobuffer(buf)
        try: self.__field_payloadsize
        except:
            self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        self.__field_payloadsize.writetobuffer(buf)
        try: self.__field_filename
        except:
            self.__field_filename=USTRING(**{'sizeinbytes': 32, 'default': ""})
        self.__field_filename.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyomediaheader(**{'command': 0xffa1})
        self.__field_header.readfrombuffer(buf)
        self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        self.__field_payloadsize.readfrombuffer(buf)
        self.__field_filename=USTRING(**{'sizeinbytes': 32, 'default': ""})
        self.__field_filename.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader(**{'command': 0xffa1})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyomediaheader):
            self.__field_header=value
        else:
            self.__field_header=sanyomediaheader(value,**{'command': 0xffa1})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_payloadsize(self):
        try: self.__field_payloadsize
        except:
            self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        return self.__field_payloadsize.getvalue()

    def __setfield_payloadsize(self, value):
        if isinstance(value,UINT):
            self.__field_payloadsize=value
        else:
            self.__field_payloadsize=UINT(value,**{'sizeinbytes': 1, 'constant': 0x20})

    def __delfield_payloadsize(self): del self.__field_payloadsize

    payloadsize=property(__getfield_payloadsize, __setfield_payloadsize, __delfield_payloadsize, None)

    def __getfield_filename(self):
        try: self.__field_filename
        except:
            self.__field_filename=USTRING(**{'sizeinbytes': 32, 'default': ""})
        return self.__field_filename.getvalue()

    def __setfield_filename(self, value):
        if isinstance(value,USTRING):
            self.__field_filename=value
        else:
            self.__field_filename=USTRING(value,**{'sizeinbytes': 32, 'default': ""})

    def __delfield_filename(self): del self.__field_filename

    filename=property(__getfield_filename, __setfield_filename, __delfield_filename, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('payloadsize', self.__field_payloadsize, None)
        yield ('filename', self.__field_filename, None)




class sanyosendfilesize(BaseProtogenClass):
    __fields=['header', 'payloadsize', 'pad1', 'filesize', 'pad2']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sanyosendfilesize,self).__init__(**dict)
        if self.__class__ is sanyosendfilesize:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sanyosendfilesize,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sanyosendfilesize,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader(**{'command': 0xffc1})
        self.__field_header.writetobuffer(buf)
        try: self.__field_payloadsize
        except:
            self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        self.__field_payloadsize.writetobuffer(buf)
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad1.writetobuffer(buf)
        self.__field_filesize.writetobuffer(buf)
        try: self.__field_pad2
        except:
            self.__field_pad2=UNKNOWN(**{'sizeinbytes': 29})
        self.__field_pad2.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyomediaheader(**{'command': 0xffc1})
        self.__field_header.readfrombuffer(buf)
        self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        self.__field_payloadsize.readfrombuffer(buf)
        self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        self.__field_pad1.readfrombuffer(buf)
        self.__field_filesize=UINT(**{'sizeinbytes': 2})
        self.__field_filesize.readfrombuffer(buf)
        self.__field_pad2=UNKNOWN(**{'sizeinbytes': 29})
        self.__field_pad2.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader(**{'command': 0xffc1})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyomediaheader):
            self.__field_header=value
        else:
            self.__field_header=sanyomediaheader(value,**{'command': 0xffc1})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_payloadsize(self):
        try: self.__field_payloadsize
        except:
            self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        return self.__field_payloadsize.getvalue()

    def __setfield_payloadsize(self, value):
        if isinstance(value,UINT):
            self.__field_payloadsize=value
        else:
            self.__field_payloadsize=UINT(value,**{'sizeinbytes': 1, 'constant': 0x20})

    def __delfield_payloadsize(self): del self.__field_payloadsize

    payloadsize=property(__getfield_payloadsize, __setfield_payloadsize, __delfield_payloadsize, None)

    def __getfield_pad1(self):
        try: self.__field_pad1
        except:
            self.__field_pad1=UNKNOWN(**{'sizeinbytes': 1})
        return self.__field_pad1.getvalue()

    def __setfield_pad1(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad1=value
        else:
            self.__field_pad1=UNKNOWN(value,**{'sizeinbytes': 1})

    def __delfield_pad1(self): del self.__field_pad1

    pad1=property(__getfield_pad1, __setfield_pad1, __delfield_pad1, None)

    def __getfield_filesize(self):
        return self.__field_filesize.getvalue()

    def __setfield_filesize(self, value):
        if isinstance(value,UINT):
            self.__field_filesize=value
        else:
            self.__field_filesize=UINT(value,**{'sizeinbytes': 2})

    def __delfield_filesize(self): del self.__field_filesize

    filesize=property(__getfield_filesize, __setfield_filesize, __delfield_filesize, None)

    def __getfield_pad2(self):
        try: self.__field_pad2
        except:
            self.__field_pad2=UNKNOWN(**{'sizeinbytes': 29})
        return self.__field_pad2.getvalue()

    def __setfield_pad2(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad2=value
        else:
            self.__field_pad2=UNKNOWN(value,**{'sizeinbytes': 29})

    def __delfield_pad2(self): del self.__field_pad2

    pad2=property(__getfield_pad2, __setfield_pad2, __delfield_pad2, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('payloadsize', self.__field_payloadsize, None)
        yield ('pad1', self.__field_pad1, None)
        yield ('filesize', self.__field_filesize, None)
        yield ('pad2', self.__field_pad2, None)




class sanyosendfilefragment(BaseProtogenClass):
    __fields=['header', 'payloadsize', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sanyosendfilefragment,self).__init__(**dict)
        if self.__class__ is sanyosendfilefragment:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sanyosendfilefragment,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sanyosendfilefragment,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader()
        self.__field_header.writetobuffer(buf)
        try: self.__field_payloadsize
        except:
            self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        self.__field_payloadsize.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyomediaheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        self.__field_payloadsize.readfrombuffer(buf)
        self.__field_data=DATA(**{'sizeinbytes': 32})
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader()
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyomediaheader):
            self.__field_header=value
        else:
            self.__field_header=sanyomediaheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_payloadsize(self):
        try: self.__field_payloadsize
        except:
            self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        return self.__field_payloadsize.getvalue()

    def __setfield_payloadsize(self, value):
        if isinstance(value,UINT):
            self.__field_payloadsize=value
        else:
            self.__field_payloadsize=UINT(value,**{'sizeinbytes': 1, 'constant': 0x20})

    def __delfield_payloadsize(self): del self.__field_payloadsize

    payloadsize=property(__getfield_payloadsize, __setfield_payloadsize, __delfield_payloadsize, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,DATA):
            self.__field_data=value
        else:
            self.__field_data=DATA(value,**{'sizeinbytes': 32})

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('payloadsize', self.__field_payloadsize, None)
        yield ('data', self.__field_data, None)




class sanyosendfileterminator(BaseProtogenClass):
    __fields=['header', 'payloadsize', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sanyosendfileterminator,self).__init__(**dict)
        if self.__class__ is sanyosendfileterminator:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sanyosendfileterminator,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sanyosendfileterminator,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader(**{'command': 0xffe1})
        self.__field_header.writetobuffer(buf)
        try: self.__field_payloadsize
        except:
            self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        self.__field_payloadsize.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 32})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyomediaheader(**{'command': 0xffe1})
        self.__field_header.readfrombuffer(buf)
        self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        self.__field_payloadsize.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 32})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader(**{'command': 0xffe1})
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyomediaheader):
            self.__field_header=value
        else:
            self.__field_header=sanyomediaheader(value,**{'command': 0xffe1})

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_payloadsize(self):
        try: self.__field_payloadsize
        except:
            self.__field_payloadsize=UINT(**{'sizeinbytes': 1, 'constant': 0x20})
        return self.__field_payloadsize.getvalue()

    def __setfield_payloadsize(self, value):
        if isinstance(value,UINT):
            self.__field_payloadsize=value
        else:
            self.__field_payloadsize=UINT(value,**{'sizeinbytes': 1, 'constant': 0x20})

    def __delfield_payloadsize(self): del self.__field_payloadsize

    payloadsize=property(__getfield_payloadsize, __setfield_payloadsize, __delfield_payloadsize, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 32})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 32})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('payloadsize', self.__field_payloadsize, None)
        yield ('pad', self.__field_pad, None)




class sanyosendfileresponse(BaseProtogenClass):
    __fields=['header', 'payloadsize', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(sanyosendfileresponse,self).__init__(**dict)
        if self.__class__ is sanyosendfileresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(sanyosendfileresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(sanyosendfileresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader()
        self.__field_header.writetobuffer(buf)
        self.__field_payloadsize.writetobuffer(buf)
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyomediaheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_payloadsize=UINT(**{'sizeinbytes': 1})
        self.__field_payloadsize.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 32})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyomediaheader()
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyomediaheader):
            self.__field_header=value
        else:
            self.__field_header=sanyomediaheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_payloadsize(self):
        return self.__field_payloadsize.getvalue()

    def __setfield_payloadsize(self, value):
        if isinstance(value,UINT):
            self.__field_payloadsize=value
        else:
            self.__field_payloadsize=UINT(value,**{'sizeinbytes': 1})

    def __delfield_payloadsize(self): del self.__field_payloadsize

    payloadsize=property(__getfield_payloadsize, __setfield_payloadsize, __delfield_payloadsize, None)

    def __getfield_pad(self):
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 32})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('payloadsize', self.__field_payloadsize, None)
        yield ('pad', self.__field_pad, None)




class study(BaseProtogenClass):
    __fields=['header', 'slot', 'pad']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(study,self).__init__(**dict)
        if self.__class__ is study:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(study,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(study,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        try: self.__field_header
        except:
            self.__field_header=sanyoheader()
        self.__field_header.writetobuffer(buf)
        self.__field_slot.writetobuffer(buf)
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 500})
        self.__field_pad.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_slot=UINT(**{'sizeinbytes': 2})
        self.__field_slot.readfrombuffer(buf)
        self.__field_pad=UNKNOWN(**{'sizeinbytes': 500})
        self.__field_pad.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        try: self.__field_header
        except:
            self.__field_header=sanyoheader()
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_slot(self):
        return self.__field_slot.getvalue()

    def __setfield_slot(self, value):
        if isinstance(value,UINT):
            self.__field_slot=value
        else:
            self.__field_slot=UINT(value,**{'sizeinbytes': 2})

    def __delfield_slot(self): del self.__field_slot

    slot=property(__getfield_slot, __setfield_slot, __delfield_slot, None)

    def __getfield_pad(self):
        try: self.__field_pad
        except:
            self.__field_pad=UNKNOWN(**{'sizeinbytes': 500})
        return self.__field_pad.getvalue()

    def __setfield_pad(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_pad=value
        else:
            self.__field_pad=UNKNOWN(value,**{'sizeinbytes': 500})

    def __delfield_pad(self): del self.__field_pad

    pad=property(__getfield_pad, __setfield_pad, __delfield_pad, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('slot', self.__field_slot, None)
        yield ('pad', self.__field_pad, None)




class studyresponse(BaseProtogenClass):
    __fields=['header', 'data']

    def __init__(self, *args, **kwargs):
        dict={}
        # What was supplied to this function
        dict.update(kwargs)
        # Parent constructor
        super(studyresponse,self).__init__(**dict)
        if self.__class__ is studyresponse:
            self._update(args,dict)


    def getfields(self):
        return self.__fields


    def _update(self, args, kwargs):
        super(studyresponse,self)._update(args,kwargs)
        keys=kwargs.keys()
        for key in keys:
            if key in self.__fields:
                setattr(self, key, kwargs[key])
                del kwargs[key]
        # Were any unrecognized kwargs passed in?
        if __debug__:
            self._complainaboutunusedargs(studyresponse,kwargs)
        if len(args): raise TypeError('Unexpected arguments supplied: '+`args`)
        # Make all P fields that haven't already been constructed


    def writetobuffer(self,buf,autolog=True,logtitle="<written data>"):
        'Writes this packet to the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        self.__field_header.writetobuffer(buf)
        self.__field_data.writetobuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologwrite(buf, logtitle=logtitle)


    def readfrombuffer(self,buf,autolog=True,logtitle="<read data>"):
        'Reads this packet from the supplied buffer'
        self._bufferstartoffset=buf.getcurrentoffset()
        if autolog and self._bufferstartoffset==0: self.autologread(buf, logtitle=logtitle)
        self.__field_header=sanyoheader()
        self.__field_header.readfrombuffer(buf)
        self.__field_data=UNKNOWN()
        self.__field_data.readfrombuffer(buf)
        self._bufferendoffset=buf.getcurrentoffset()


    def __getfield_header(self):
        return self.__field_header.getvalue()

    def __setfield_header(self, value):
        if isinstance(value,sanyoheader):
            self.__field_header=value
        else:
            self.__field_header=sanyoheader(value,)

    def __delfield_header(self): del self.__field_header

    header=property(__getfield_header, __setfield_header, __delfield_header, None)

    def __getfield_data(self):
        return self.__field_data.getvalue()

    def __setfield_data(self, value):
        if isinstance(value,UNKNOWN):
            self.__field_data=value
        else:
            self.__field_data=UNKNOWN(value,)

    def __delfield_data(self): del self.__field_data

    data=property(__getfield_data, __setfield_data, __delfield_data, None)

    def iscontainer(self):
        return True

    def containerelements(self):
        yield ('header', self.__field_header, None)
        yield ('data', self.__field_data, None)




