/*
 *
 *  Universal Protocol Analyzer library
 *
 *  Copyright (C) 2006-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __UPA_BLUETOOTH_L2CAP_H__
#define __UPA_BLUETOOTH_L2CAP_H__

#include <glib-object.h>

#include "upa-packet.h"

G_BEGIN_DECLS

#define UPA_TYPE_BLUETOOTH_L2CAP (upa_bluetooth_l2cap_get_type())

#define UPA_BLUETOOTH_L2CAP(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST((obj),UPA_TYPE_BLUETOOTH_L2CAP,UpaBluetoothL2cap))

typedef struct _UpaBluetoothL2cap UpaBluetoothL2cap;
typedef struct _UpaBluetoothL2capClass UpaBluetoothL2capClass;

struct _UpaBluetoothL2cap {
	UpaPacket packet;
};

struct _UpaBluetoothL2capClass {
	UpaPacketClass packet_class;
};

GType upa_bluetooth_l2cap_get_type(void);

G_END_DECLS

#endif /* __UPA_BLUETOOTH_L2CAP_H__ */
