#include "includes.h"

void configrun(struct struc_bootmanager *btmgr, char **drive, char **themesdir, char **themename, unsigned char *drivenum, char *file)
{
    FILE *f;
    
    *themename=NULL;    
//    *drive=NULL;
    f=fopen(file,"r");
    if (f)
    {
	char *line;
	int linelen;
	int getret;
	int linnum=0;
	int actrec=-1;
	int basethings=1;
	
	line=NULL; linelen=0;
	getret=getline(&line, &linelen, f);
	while (getret!=-1)
	{
	    char *trimline;
	    char *fpart,*spart;
	    char *running;
	    
	    linnum++;    
	    if ((basethings) && (*drive) && (*themename))
	    {
		if (!*themesdir)
		    asprintf(themesdir, DFLTHEMESDIR);
		emptybtmgr(btmgr, *themesdir, *themename, *drivenum, *drive);
		basethings=0;
	    }
	    trimline=trim(line);
	    if ((strlen(trimline)) && (trimline[0]!='#'))
	    {
		if (strchr(trimline,'='))
		{
		    running=trimline;
		    fpart=strsep(&running,"=");
	    	    spart=running;
	    	    if ((!spart) || (!fpart))
	    	    {
			fprintf(stderr,"Wrong syntax in line %d of the config file\n", linnum);
		        abort();
	    	    }
		    if (strcasecmp(fpart,"device")==0)
		    {
			if (actrec==-1) driveparse(spart, drive, drivenum);
			else
			{
			    fprintf(stderr,"Device must be global!\n");
			    abort();
			}
		    }
		    else if (strcasecmp(fpart,"themesdir")==0)
		    {
			if (!basethings)
			{
			    fprintf(stderr, "Themesdir option must be the first if you want to use it!\n");
			    usage();
			}
			if (actrec==-1) 
			{
			    asprintf(themesdir, "%s", spart);
			}
			else
			{
			    fprintf(stderr,"Themesdir must be global!\n");
			    abort();
			}
		    }
		    else if (strcasecmp(fpart,"theme")==0)
		    {
			if (actrec==-1) asprintf(themename,"%s", spart);
			else
			{
			    fprintf(stderr,"Theme must be global!\n");
			    abort();
			}
		    }
		    else if (basethings)
		    {
			fprintf(stderr,"First you must specify the device and theme option!\n");
			abort();
		    }
		    else if (strcasecmp(fpart,"remlast")==0)
		    {
			if (actrec==-1) remlast(btmgr, spart);
			else
			{
			    fprintf(stderr,"Remlast must be global!\n");
			    abort();
			}
		    }
		    else if (strcasecmp(fpart,"int13")==0)
		    {
			if (actrec==-1) int13(btmgr, spart);
			else
			{
			    fprintf(stderr,"Int13 must be global!\n");
			    abort();
			}
		    }
		    else if (strcasecmp(fpart,"password")==0)
		    {
			if (actrec==-1)
			{
			    password(btmgr, -2, spart);
			}
			else
			{
			    password(btmgr, actrec, spart);
			}
		    }
		    else if ((strncasecmp(fpart,"/dev/", 5)==0) || (strncasecmp(fpart,"cdrom",5)==0))
		    {
			char *adddrive;
			unsigned char addhard=0, addpartid=0;
			int addfloppy=0;
			int atoiret;
			
			if (strncasecmp(fpart,"cdrom",5)==0)
			{
			    atoiret=verifiedatoi(fpart+5);
			    if (atoiret>=0 && atoiret<256-MIN_CDROM_ID) 
				addhard=MIN_CDROM_ID+atoiret;
			    else 
			    {
				fprintf(stderr,"Invalid value for cdrom at line: %d\n", linnum);
				abort();
			    }
			}
			else parsefdhdxadd(fpart, &addfloppy, &addhard, &addpartid, &adddrive); 
			addpartition(btmgr, addfloppy, addhard, adddrive, addpartid, spart);
			actrec++;
		    }
		    else if (strcasecmp(fpart,"schedule")==0)
		    {
			if (actrec==-1)
			{
			    fprintf(stderr,"Schedule is only valid for records. Line: %d",linnum);
			    abort();
			}
			else
			{
			    schedule(btmgr, actrec, spart);
			}
		    }
		    else if (strcasecmp(fpart,"delay")==0)
		    {
			if (actrec==-1)
			{
			    int atoiret;
			    
			    atoiret=verifiedatoi(spart);
			    if (atoiret>0)
				delay(btmgr, atoiret);
			    else
			    {
				fprintf(stderr,"Wrong line(%d): %s=%s\n", linnum,fpart,spart);
				abort();
			    }
			}
			else
			{
			    fprintf(stderr,"Delay must be global. Line: %d\n", linnum);
			    abort();
			}
		    }
		    else if (strcasecmp(fpart,"style")==0)
		    {
			if (actrec==-1)
			{
			    int atoiret;
			    
			    atoiret=verifiedatoi(spart);
			    if ((atoiret>-1) && (atoiret<4))
				style(btmgr, atoiret);
			    else
			    {
				fprintf(stderr,"Wrong line(%d): %s=%s\n", linnum,fpart,spart);
				abort();
			    }
			}
			else
			{
			    fprintf(stderr,"Style must be global. Line: %d\n", linnum);
			    abort();
			}
		    }
		    else if (strcasecmp(fpart,"seclock")==0)
		    {
			if (actrec==-1)
			{
			    seclock(btmgr, spart);
			}
			else
			{
			    fprintf(stderr,"Seclock must be global. Line; %d\n", linnum);
			    abort();
			}
		    }
		    else 
		    {
			fprintf(stderr,"Wrong line(%d): %s=%s\n",linnum, fpart, spart);
			abort();
		    }
		}
		else /* '=' not found */
		{
	    	    if (strcasecmp(trimline,"default")==0)
		    {
			if (actrec==-1)
			{
			    fprintf(stderr,"Default is a record option, it can't be global. Line: %d\n", linnum);
			    abort();
			}
			else chdefault(btmgr,actrec);
		    }
		    else if (strcasecmp(trimline,"autohide")==0)
		    {
			if (actrec==-1)
			{
			    fprintf(stderr,"Autohide is a record option, it can't be global. Line: %d\n", linnum);
			    abort();
			}
			else autohide(btmgr,actrec);
		    }
		    else if (strcasecmp(trimline,"autoactive")==0)
		    {
			if (actrec==-1)
			{
			    fprintf(stderr,"Autoactive is a record option, it can't be global. Line: %d\n", linnum);
			    abort();
			}
			else autoactive(btmgr,actrec);
		    }
		    else if (strcasecmp(trimline,"swapdriveid")==0)
		    {
			if (actrec==-1)
			{
			    fprintf(stderr,"Swapdriveid is a record option, it can't be global. Line: %d\n", linnum);
			    abort();
			}
			else swapdriveid(btmgr,actrec);
		    }
		    else
		    {
			fprintf(stderr, "Wrong line(%d): %s\n", linnum, trimline);
			abort();
		    }
		}
	    }
	    free(trimline);free(line);line=NULL;linelen=0;
	    getret=getline(&line, &linelen, f);
	}
    }
    else
    {
	fprintf(stderr,"Can't open config file!\n");
	usage();
    }
    noautoscan(btmgr);
    if (*drive) list(btmgr);
}
