/*
 * Copyright (C) 1998,1999  Ross Combs (rocombs@cs.nmsu.edu)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#ifndef INCLUDED_CONNECTION_TYPES
#define INCLUDED_CONNECTION_TYPES

#ifdef CONNECTION_INTERNAL_ACCESS

#ifdef JUST_NEED_TYPES
#include "account.h"
#else
#define JUST_NEED_TYPES
#include "account.h"
#undef JUST_NEED_TYPES
#endif

typedef struct
{
    char const *  away;
    char const *  dnd;
    int           allow_whispers;
    t_account * * ignore_list;
    unsigned int  ignore_count;
} t_usersettings;
#endif

typedef enum
{
    conn_class_normal,
    conn_class_file,
    conn_class_bot,
    conn_class_none
} t_conn_class;

typedef enum
{
    conn_state_empty,
    conn_state_initial,
    conn_state_connected,
    conn_state_bot_username,
    conn_state_bot_password,
    conn_state_loggedin,
    conn_state_destroy
} t_conn_state;

#ifdef CONNECTION_INTERNAL_ACCESS
#ifdef JUST_NEED_TYPES
#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
#  if HAVE_SYS_TIME_H
#   include <sys/time.h>
#  else
#   include <time.h>
#  endif
#endif
#include "game.h"
#include "queue.h"
#include "channel.h"
#include "account.h"
#else
#define JUST_NEED_TYPES
#ifdef TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
#  if HAVE_SYS_TIME_H
#   include <sys/time.h>
#  else
#   include <time.h>
#  endif
#endif
#include "game.h"
#include "queue.h"
#include "channel.h"
#include "account.h"
#undef JUST_NEED_TYPES
#endif
#endif

typedef struct connection
#ifdef CONNECTION_INTERNAL_ACCESS
{
    int            sock;
    unsigned short port;
    unsigned int   addr;
    t_conn_class   class;
    t_conn_state   state;
    unsigned int   sessionkey;
    unsigned int   flags;
    unsigned int   latency;
    t_usersettings settings;
    char const *   clienttag;
    char const *   clientver;
    t_account *    account;
    t_channel *    channel;
    t_game *       game;
    t_queue *      outqueue;  /* packets waiting to be sent */
    unsigned int   outsize;   /* amount sent from the current output packet */
    t_queue *      inqueue;   /* packet waiting to be processed */
    unsigned int   insize;    /* amount received into the current input packet */
    int            welcomed;  /* 1 = sent welcome message, 0 = have not */
    int            protflag;  /* 1 if client used COMPINFO1, 2 if client used COMPINFO2 */
    char const *   host;
    char const *   user;
    char const *   clientexe;
    char const *   owner;
    char const *   cdkey;
    char const *   botuser;
    time_t         last_packet;
    time_t         last_message;
}
#endif
t_connection;

#endif

#ifndef JUST_NEED_TYPES
#ifndef INCLUDED_CONNECTION_PROTOS
#define INCLUDED_CONNECTION_PROTOS

#define JUST_NEED_TYPES
#include "packet.h"
#include "queue.h"
#include "channel.h"
#include "game.h"
#include "account.h"
#include "list.h"
#undef JUST_NEED_TYPES

extern char const * conn_class_get_str(t_conn_class class);
extern char const * conn_state_get_str(t_conn_state state);

extern t_connection * conn_create(int sock, unsigned int addr, unsigned short port);
extern void conn_destroy(t_connection * c);
extern int conn_match(t_connection const * c, char const * user);
extern t_conn_class conn_get_class(t_connection const * c);
extern void conn_set_class(t_connection * c, t_conn_class class);
extern t_conn_state conn_get_state(t_connection const * c);
extern void conn_set_state(t_connection * c, t_conn_state state);
extern unsigned int conn_get_sessionkey(t_connection const * c);
extern unsigned int conn_get_addr(t_connection const * c);
extern unsigned short conn_get_port(t_connection const * c);
extern unsigned int conn_get_game_addr(t_connection const * c);
extern unsigned short conn_get_game_port(t_connection const * c);
extern void conn_set_host(t_connection * c, char const * host);
extern void conn_set_user(t_connection * c, char const * user);
extern void conn_set_owner(t_connection * c, char const * owner);
extern void conn_set_cdkey(t_connection * c, char const * cdkey);
extern char const * conn_get_clientexe(t_connection const * c);
extern void conn_set_clientexe(t_connection * c, char const * clientexe);
extern char const * conn_get_clienttag(t_connection const * c);
extern void conn_set_clienttag(t_connection * c, char const * clienttag);
extern char const * conn_get_clientver(t_connection const * c);
extern void conn_set_clientver(t_connection * c, char const * clientver);
extern int conn_set_botuser(t_connection * c, char const * username);
extern char const * conn_get_botuser(t_connection const * c);
extern unsigned int conn_get_flags(t_connection const * c);
extern void conn_add_flags(t_connection * c, unsigned int flags);
extern void conn_del_flags(t_connection * c, unsigned int flags);
extern unsigned int conn_get_latency(t_connection const * c);
extern void conn_set_latency(t_connection * c, unsigned int ms);
extern char const * conn_get_awaystr(t_connection const * c);
extern int conn_set_awaystr(t_connection * c, char const * away);
extern char const * conn_get_dndstr(t_connection const * c);
extern int conn_set_dndstr(t_connection * c, char const * dnd);
extern int conn_add_ignore(t_connection * c, t_account * account);
extern int conn_del_ignore(t_connection * c, t_account const * account);
extern int conn_add_watch(t_connection * c, t_account * account);
extern int conn_del_watch(t_connection * c, t_account * account);
extern t_channel * conn_get_channel(t_connection const * c);
extern int conn_set_channel(t_connection * c, char const * channelname);
extern t_game * conn_get_game(t_connection const * c);
extern int conn_set_game(t_connection * c, char const * gamename, char const * gamepass, char const * gameinfo, t_game_type type, int version);
extern t_queue * * conn_get_in_queue(t_connection * c);
extern int conn_get_in_size(t_connection const * c);
extern void conn_set_in_size(t_connection * c, unsigned int size);
extern t_queue * * conn_get_out_queue(t_connection * c);
extern int conn_get_out_size(t_connection const * c);
extern void conn_set_out_size(t_connection * c, unsigned int size);
extern int conn_check_ignoring(t_connection const * c, char const * me);
extern t_account * conn_get_account(t_connection const * c);
extern void conn_set_account(t_connection * c, t_account * account);
extern int conn_get_socket(t_connection const * c);
extern char const * conn_get_username(t_connection const * c);
extern void conn_unget_username(char const * name);
extern unsigned int conn_get_userid(t_connection const * c);
extern int conn_get_protflag(t_connection const * c);
extern int conn_set_protflag(t_connection * c, int flag);
extern char const * conn_get_playerinfo(t_connection const * c, char const * clienttag);
extern int conn_set_playerinfo(t_connection const * c, char const * playerinfo);

extern void connlist_init(void);
extern t_connection * connlist_find_connection(char const * username);
extern t_connection * connlist_find_connection_by_sessionkey(unsigned int sessionkey);
extern int connlist_get_length(void);
extern int connlist_login_get_length(void);
extern t_connection * connlist_get_first(t_list const * const * * save);
extern t_connection * connlist_get_next(t_list const * const * * save);
extern int connlist_total_logins(void);

#endif
#endif
