// Test.java -- a short test in Java

import java.io.PrintStream;

class A {
	String a="Say \"Hello\", ";
	String a1="world!";

	void casttest()
	{
		try {
			B b=(B) this;
			System.out.println(b.b);
		} catch (ClassCastException e) {
			System.out.println("(Nothing.)");
		}
	}

	void supertest()
	{
		System.out.println("A.supertest()");
	}
}

class B extends A {
	String b=new Object().getClass().getName();
	static String b1=(new Object[0]).getClass().getName();

	static void test(Object o)
	{
		if (o instanceof A)
			System.out.println(o.getClass() + " instanceof A");
		if (o instanceof B)
			System.out.println(o.getClass() + " instanceof B");
	}

	void supertest()
	{
		System.out.println("B.supertest()");
		super.supertest();
		System.out.println("B.supertest()");
	}
}

class C extends B {

	{
		System.out.println("Object initialiser for class C");
		for (int i=5; i>=0; i--) {
			System.out.print(i+"...");
		}
		System.out.println("");
	}

	void supertest()
	{
		System.out.println("C.supertest()");
		super.supertest();
		System.out.println("C.supertest()");
	}
}

interface IA {
	public void printa();
}

interface IB {
	public void printb();
}

class AA implements IA {
	static {
		for (int i=10; i>=0; i--) {
			System.out.print(i+"...");
		}
		System.out.println("");
	}

	public void printa()
	{
		System.out.println("this implements IA, and is an AA");
	}
}

class AB implements IA {
	public void printa()
	{
		System.out.println("this implements IA, and is an AB");
	}
}

class BB implements IB {
	public void printb()
	{
		System.out.println("this implements IB");
	}
}

public class Test {
	static int tryret()
	{
		try {
			return 2;
		} finally {
			try {
				try {
					return 1;
				} finally {
					throw new Error();
				}
			} catch (Error e) {
				System.out.println(
					"Try-return test caught Error");
			}
		}
	}

	static void tryinterface(Object o)
	{
		try {
			((IA) o).printa();
		} catch (ClassCastException e) {
			if (o instanceof IB) {
				((IB) o).printb();
			}
		}
	}

	static void tryswitch(int i)
	{
		switch (i) {
		case 1: System.out.print("one ");
		case 2: System.out.print("too ");
		case 3: System.out.println("many");
		}
		switch (i) {
		case 1: System.out.println("one"); break;
		case 2: System.out.println("two"); break;
		case 3: System.out.println("many"); break;
		}
	}

	public static void main(String[] args)
	{
		PrintStream out=System.out;
		B b=new B();
		out.println(b.a+b.a1);
		out.println(b.b);
		out.println(b.b1);
		out.println((new Object[3]).getClass().getName());
		out.println((new int[3][][][][][][]).getClass().getName());
		int[] ia=new int[] { 0, 0 };
		out.println(ia[0]+++" "+ ++ia[1]);
		out.println(ia[0]+++" "+ ++ia[1]);
		for (int i=32; i>0; i--)
			out.println(Integer.toHexString(~0>>>i));
		for (int i=0; i<33; i++)
			out.println(Integer.toHexString(~0<<i));
		for (int i=0; i<33; i++)
			out.println(Integer.toHexString(0xaaaaaaaa>>i));
		for (int i=0; i<33; i++)
			out.println(Integer.toHexString(~0xaaaaaaaa>>i));
		B.test(new A());
		B.test(new B());
		new B().casttest();
		new A().casttest();
		System.out.println("Try-return test returned " + tryret());
		tryinterface(new AA());
		tryinterface(new AB());
		tryinterface(new BB());
		out.println("----------");
		new A().supertest();
		out.println("----------");
		new B().supertest();
		out.println("----------");
		new C().supertest();
		out.println("----------");
		tryswitch(1);
		tryswitch(2);
		tryswitch(3);
	}
}
